/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2019-2020 Hoffmann-La Roche.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.roche.spock.geb.reporters;

import geb.report.ReportState;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LogType;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;

public class BrowserLogsReporter extends WrappedReporterSupport {

    @Override
    public void writeReport(ReportState reportState) {
        File file = (File) getFile(reportState.getOutputDir(), reportState.getLabel(), "txt");
        List<LogEntry> all = reportState.getBrowser().getDriver().manage().logs().get(LogType.BROWSER).getAll();

        try {
            FileUtils.writeLines(file, all);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        notifyListeners(reportState, Collections.singletonList(file));
    }

}
