/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client;

import com.rockset.client.ApiClient;
import com.rockset.client.api.AliasesApi;
import com.rockset.client.api.ApiKeysApi;
import com.rockset.client.api.CollectionsApi;
import com.rockset.client.api.CustomDocumentsApi;
import com.rockset.client.api.CustomRolesBetaApi;
import com.rockset.client.api.DocumentsApi;
import com.rockset.client.api.IntegrationsApi;
import com.rockset.client.api.OrganizationsApi;
import com.rockset.client.api.QueriesApi;
import com.rockset.client.api.QueryLambdasApi;
import com.rockset.client.api.UsersApi;
import com.rockset.client.api.ViewsApi;
import com.rockset.client.api.VirtualInstancesApi;
import com.rockset.client.api.WorkspacesApi;
import java.util.Optional;

public class RocksetClient {
    private ApiClient apiClient;
    public AliasesApi aliases;
    public ApiKeysApi apiKeys;
    public CollectionsApi collections;
    public CustomRolesBetaApi customRolesBeta;
    public DocumentsApi documents;
    public IntegrationsApi integrations;
    public OrganizationsApi organizations;
    public QueriesApi queries;
    public QueryLambdasApi queryLambdas;
    public UsersApi users;
    public ViewsApi views;
    public VirtualInstancesApi virtualInstances;
    public WorkspacesApi workspaces;
    private static final String implementationVersion = Optional.ofNullable(RocksetClient.class.getPackage()).map(Package::getImplementationVersion).orElse("0.9999.9999.SNAPSHOT");

    public RocksetClient(String apiKey, String apiServer) {
        this(apiKey, apiServer, "");
    }

    public RocksetClient(String apiKey, String apiServer, String application) {
        assert (!apiKey.isEmpty());
        if (apiServer.isEmpty()) {
            apiServer = "https://api.usw2a1.rockset.com";
        }
        if (!apiServer.startsWith("https://") && !apiServer.startsWith("http://")) {
            apiServer = "https://" + apiServer;
        }
        String userAgent = "java";
        if (!application.isEmpty()) {
            userAgent = userAgent + ":";
            userAgent = userAgent + application;
        }
        this.apiClient = new ApiClient().setApiKey(apiKey).setApiServer(apiServer).setVersion(implementationVersion).setUserAgent(userAgent);
        this.aliases = new AliasesApi(this.apiClient);
        this.apiKeys = new ApiKeysApi(this.apiClient);
        this.collections = new CollectionsApi(this.apiClient);
        this.customRolesBeta = new CustomRolesBetaApi(this.apiClient);
        this.documents = new CustomDocumentsApi(this.apiClient);
        this.integrations = new IntegrationsApi(this.apiClient);
        this.organizations = new OrganizationsApi(this.apiClient);
        this.queries = new QueriesApi(this.apiClient);
        this.queryLambdas = new QueryLambdasApi(this.apiClient);
        this.users = new UsersApi(this.apiClient);
        this.views = new ViewsApi(this.apiClient);
        this.virtualInstances = new VirtualInstancesApi(this.apiClient);
        this.workspaces = new WorkspacesApi(this.apiClient);
    }

    public int getConnectTimeout() {
        return this.apiClient.getConnectTimeout();
    }

    public RocksetClient setConnectTimeout(int connectTimeout) {
        this.apiClient.setConnectTimeout(connectTimeout);
        return this;
    }

    public int getReadTimeout() {
        return this.apiClient.getReadTimeout();
    }

    public RocksetClient setReadTimeout(int readTimeout) {
        this.apiClient.setReadTimeout(readTimeout);
        return this;
    }

    public int getWriteTimeout() {
        return this.apiClient.getWriteTimeout();
    }

    public RocksetClient setWriteTimeout(int writeTimeout) {
        this.apiClient.setWriteTimeout(writeTimeout);
        return this;
    }

    public void setAliasesApi(AliasesApi aliasesApi) {
        this.aliases = aliasesApi;
    }

    public void setApiKeys(ApiKeysApi apiKeysApi) {
        this.apiKeys = apiKeysApi;
    }

    public void setCollections(CollectionsApi collectionsApi) {
        this.collections = collectionsApi;
    }

    public void setCustomRolesBeta(CustomRolesBetaApi customRolesBetaApi) {
        this.customRolesBeta = customRolesBetaApi;
    }

    public void setDocuments(DocumentsApi documentsApi) {
        this.documents = documentsApi;
    }

    public void setIntegrations(IntegrationsApi integrationsApi) {
        this.integrations = integrationsApi;
    }

    public void setOrganizations(OrganizationsApi organizationsApi) {
        this.organizations = organizationsApi;
    }

    public void setQueries(QueriesApi queriesApi) {
        this.queries = queriesApi;
    }

    public void setQueryLambdas(QueryLambdasApi queryLambdasApi) {
        this.queryLambdas = queryLambdasApi;
    }

    public void setUsers(UsersApi usersApi) {
        this.users = usersApi;
    }

    public void setViews(ViewsApi viewsApi) {
        this.views = viewsApi;
    }

    public void setVirtualInstances(VirtualInstancesApi virtualInstancesApi) {
        this.virtualInstances = virtualInstancesApi;
    }

    public void setWorkspaces(WorkspacesApi workspacesApi) {
        this.workspaces = workspacesApi;
    }
}

