/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.api;

import com.google.gson.reflect.TypeToken;
import com.rockset.client.ApiCallback;
import com.rockset.client.ApiClient;
import com.rockset.client.ApiResponse;
import com.rockset.client.Configuration;
import com.rockset.client.Pair;
import com.rockset.client.ProgressRequestBody;
import com.rockset.client.ProgressResponseBody;
import com.rockset.client.model.CreateAliasRequest;
import com.rockset.client.model.CreateAliasResponse;
import com.rockset.client.model.DeleteAliasResponse;
import com.rockset.client.model.GetAliasResponse;
import com.rockset.client.model.ListAliasesResponse;
import com.rockset.client.model.UpdateAliasRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class AliasesApi {
    private ApiClient apiClient;

    public AliasesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AliasesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createCall(String workspace, CreateAliasRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        CreateAliasRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/aliases".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createValidateBeforeCall(String workspace, CreateAliasRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling create(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling create(Async)");
        }
        Call call = this.createCall(workspace, body, progressListener, progressRequestListener);
        return call;
    }

    public CreateAliasResponse create(String workspace, CreateAliasRequest body) throws Exception {
        ApiResponse<CreateAliasResponse> resp = this.createWithHttpInfo(workspace, body);
        return resp.getData();
    }

    public ApiResponse<CreateAliasResponse> createWithHttpInfo(String workspace, CreateAliasRequest body) throws Exception {
        Call call = this.createValidateBeforeCall(workspace, body, null, null);
        Type localVarReturnType = new TypeToken<CreateAliasResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createAsync(String workspace, CreateAliasRequest body, final ApiCallback<CreateAliasResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createValidateBeforeCall(workspace, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateAliasResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCall(String workspace, String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/aliases/{alias}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteValidateBeforeCall(String workspace, String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling delete(Async)");
        }
        if (alias == null) {
            throw new Exception("Missing the required parameter 'alias' when calling delete(Async)");
        }
        Call call = this.deleteCall(workspace, alias, progressListener, progressRequestListener);
        return call;
    }

    public DeleteAliasResponse delete(String workspace, String alias) throws Exception {
        ApiResponse<DeleteAliasResponse> resp = this.deleteWithHttpInfo(workspace, alias);
        return resp.getData();
    }

    public ApiResponse<DeleteAliasResponse> deleteWithHttpInfo(String workspace, String alias) throws Exception {
        Call call = this.deleteValidateBeforeCall(workspace, alias, null, null);
        Type localVarReturnType = new TypeToken<DeleteAliasResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAsync(String workspace, String alias, final ApiCallback<DeleteAliasResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteValidateBeforeCall(workspace, alias, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeleteAliasResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCall(String workspace, String alias, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/aliases/{alias}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getValidateBeforeCall(String workspace, String alias, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling get(Async)");
        }
        if (alias == null) {
            throw new Exception("Missing the required parameter 'alias' when calling get(Async)");
        }
        Call call = this.getCall(workspace, alias, progressListener, progressRequestListener);
        return call;
    }

    public GetAliasResponse get(String workspace, String alias) throws Exception {
        ApiResponse<GetAliasResponse> resp = this.getWithHttpInfo(workspace, alias);
        return resp.getData();
    }

    public ApiResponse<GetAliasResponse> getWithHttpInfo(String workspace, String alias) throws Exception {
        Call call = this.getValidateBeforeCall(workspace, alias, null, null);
        Type localVarReturnType = new TypeToken<GetAliasResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAsync(String workspace, String alias, final ApiCallback<GetAliasResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getValidateBeforeCall(workspace, alias, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAliasResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/aliases";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Call call = this.listCall(progressListener, progressRequestListener);
        return call;
    }

    public ListAliasesResponse list() throws Exception {
        ApiResponse<ListAliasesResponse> resp = this.listWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ListAliasesResponse> listWithHttpInfo() throws Exception {
        Call call = this.listValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ListAliasesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listAsync(final ApiCallback<ListAliasesResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListAliasesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCall(String workspace, String alias, UpdateAliasRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        UpdateAliasRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/aliases/{alias}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{alias\\}", this.apiClient.escapeString(alias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateValidateBeforeCall(String workspace, String alias, UpdateAliasRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling update(Async)");
        }
        if (alias == null) {
            throw new Exception("Missing the required parameter 'alias' when calling update(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling update(Async)");
        }
        Call call = this.updateCall(workspace, alias, body, progressListener, progressRequestListener);
        return call;
    }

    public GetAliasResponse update(String workspace, String alias, UpdateAliasRequest body) throws Exception {
        ApiResponse<GetAliasResponse> resp = this.updateWithHttpInfo(workspace, alias, body);
        return resp.getData();
    }

    public ApiResponse<GetAliasResponse> updateWithHttpInfo(String workspace, String alias, UpdateAliasRequest body) throws Exception {
        Call call = this.updateValidateBeforeCall(workspace, alias, body, null, null);
        Type localVarReturnType = new TypeToken<GetAliasResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAsync(String workspace, String alias, UpdateAliasRequest body, final ApiCallback<GetAliasResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateValidateBeforeCall(workspace, alias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAliasResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call workspaceCall(String workspace, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/aliases".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call workspaceValidateBeforeCall(String workspace, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling workspace(Async)");
        }
        Call call = this.workspaceCall(workspace, progressListener, progressRequestListener);
        return call;
    }

    public ListAliasesResponse workspace(String workspace) throws Exception {
        ApiResponse<ListAliasesResponse> resp = this.workspaceWithHttpInfo(workspace);
        return resp.getData();
    }

    public ApiResponse<ListAliasesResponse> workspaceWithHttpInfo(String workspace) throws Exception {
        Call call = this.workspaceValidateBeforeCall(workspace, null, null);
        Type localVarReturnType = new TypeToken<ListAliasesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call workspaceAsync(String workspace, final ApiCallback<ListAliasesResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.workspaceValidateBeforeCall(workspace, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListAliasesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

