/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.api;

import com.rockset.client.ApiClient;
import com.rockset.client.api.DocumentsApi;
import com.rockset.client.model.AddDocumentsRequest;
import com.rockset.client.model.AddDocumentsResponse;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CustomDocumentsApi
extends DocumentsApi {
    static final String ROCKSET_TYPE = "__rockset_type";
    static final String ROCKSET_VALUE = "value";

    public CustomDocumentsApi(ApiClient apiClient) {
        super(apiClient);
    }

    @Override
    public AddDocumentsResponse add(String workspace, String collection, AddDocumentsRequest body) throws Exception {
        for (Object doc : body.getData()) {
            if (!(doc instanceof Map)) {
                throw new IllegalArgumentException("Document is not a valid Map Object");
            }
            this.buildRocksetObject(doc);
        }
        return super.add(workspace, collection, body);
    }

    Object buildRocksetObject(Object doc) {
        if (doc instanceof Map) {
            Map map = (Map)doc;
            for (Map.Entry entry : map.entrySet()) {
                Object value = this.buildRocksetObject(entry.getValue());
                map.put(entry.getKey(), value);
            }
            return map;
        }
        if (doc instanceof List) {
            List list = (List)doc;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.buildRocksetObject(list.get(i)));
            }
            return list;
        }
        if (doc instanceof Set) {
            HashSet<Object> modifiedSet = new HashSet<Object>();
            for (Object element : (Set)doc) {
                modifiedSet.add(this.buildRocksetObject(element));
            }
            return modifiedSet;
        }
        if (doc instanceof Instant) {
            return this.constructTimestamp((Instant)doc);
        }
        if (doc instanceof LocalDateTime) {
            return this.constructDateTime(((LocalDateTime)doc).toString());
        }
        if (doc instanceof LocalDate) {
            return this.constructDate(((LocalDate)doc).toString());
        }
        if (doc instanceof LocalTime) {
            return this.constructTime(((LocalTime)doc).toString());
        }
        if (doc instanceof Timestamp) {
            return this.constructTimestamp(((Timestamp)doc).toInstant());
        }
        if (doc instanceof Date) {
            return this.constructDate(((Date)doc).toString());
        }
        if (doc instanceof Time) {
            return this.constructTime(((Time)doc).toString());
        }
        if (doc instanceof java.util.Date) {
            return this.constructTimestamp(((java.util.Date)doc).toInstant());
        }
        return doc;
    }

    private Map<String, Object> constructTimestamp(Instant instant) {
        HashMap<String, Object> timestamp = new HashMap<String, Object>();
        timestamp.put(ROCKSET_TYPE, "timestamp");
        timestamp.put(ROCKSET_VALUE, this.instantToTimestamp(instant));
        return timestamp;
    }

    private Map<String, Object> constructDateTime(String datetimeStr) {
        HashMap<String, Object> datetime = new HashMap<String, Object>();
        datetime.put(ROCKSET_TYPE, "datetime");
        datetime.put(ROCKSET_VALUE, datetimeStr);
        return datetime;
    }

    private Map<String, Object> constructDate(String dateStr) {
        HashMap<String, Object> date = new HashMap<String, Object>();
        date.put(ROCKSET_TYPE, "date");
        date.put(ROCKSET_VALUE, dateStr);
        return date;
    }

    private Map<String, Object> constructTime(String timeStr) {
        HashMap<String, Object> time = new HashMap<String, Object>();
        time.put(ROCKSET_TYPE, "time");
        time.put(ROCKSET_VALUE, timeStr);
        return time;
    }

    private long instantToTimestamp(Instant instant) {
        return TimeUnit.SECONDS.toMicros(instant.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(instant.getNano());
    }
}

