/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.api;

import com.google.gson.reflect.TypeToken;
import com.rockset.client.ApiCallback;
import com.rockset.client.ApiClient;
import com.rockset.client.ApiResponse;
import com.rockset.client.Configuration;
import com.rockset.client.Pair;
import com.rockset.client.ProgressRequestBody;
import com.rockset.client.ProgressResponseBody;
import com.rockset.client.model.AddDocumentsRequest;
import com.rockset.client.model.AddDocumentsResponse;
import com.rockset.client.model.DeleteDocumentsRequest;
import com.rockset.client.model.DeleteDocumentsResponse;
import com.rockset.client.model.PatchDocumentsRequest;
import com.rockset.client.model.PatchDocumentsResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DocumentsApi {
    private ApiClient apiClient;

    public DocumentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addCall(String workspace, String collection, AddDocumentsRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        AddDocumentsRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/docs".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addValidateBeforeCall(String workspace, String collection, AddDocumentsRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling add(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling add(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling add(Async)");
        }
        Call call = this.addCall(workspace, collection, body, progressListener, progressRequestListener);
        return call;
    }

    public AddDocumentsResponse add(String workspace, String collection, AddDocumentsRequest body) throws Exception {
        ApiResponse<AddDocumentsResponse> resp = this.addWithHttpInfo(workspace, collection, body);
        return resp.getData();
    }

    public ApiResponse<AddDocumentsResponse> addWithHttpInfo(String workspace, String collection, AddDocumentsRequest body) throws Exception {
        Call call = this.addValidateBeforeCall(workspace, collection, body, null, null);
        Type localVarReturnType = new TypeToken<AddDocumentsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addAsync(String workspace, String collection, AddDocumentsRequest body, final ApiCallback<AddDocumentsResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addValidateBeforeCall(workspace, collection, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AddDocumentsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCall(String workspace, String collection, DeleteDocumentsRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        DeleteDocumentsRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/docs".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteValidateBeforeCall(String workspace, String collection, DeleteDocumentsRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling delete(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling delete(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling delete(Async)");
        }
        Call call = this.deleteCall(workspace, collection, body, progressListener, progressRequestListener);
        return call;
    }

    public DeleteDocumentsResponse delete(String workspace, String collection, DeleteDocumentsRequest body) throws Exception {
        ApiResponse<DeleteDocumentsResponse> resp = this.deleteWithHttpInfo(workspace, collection, body);
        return resp.getData();
    }

    public ApiResponse<DeleteDocumentsResponse> deleteWithHttpInfo(String workspace, String collection, DeleteDocumentsRequest body) throws Exception {
        Call call = this.deleteValidateBeforeCall(workspace, collection, body, null, null);
        Type localVarReturnType = new TypeToken<DeleteDocumentsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAsync(String workspace, String collection, DeleteDocumentsRequest body, final ApiCallback<DeleteDocumentsResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteValidateBeforeCall(workspace, collection, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeleteDocumentsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchCall(String workspace, String collection, PatchDocumentsRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        PatchDocumentsRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/docs".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchValidateBeforeCall(String workspace, String collection, PatchDocumentsRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling patch(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling patch(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling patch(Async)");
        }
        Call call = this.patchCall(workspace, collection, body, progressListener, progressRequestListener);
        return call;
    }

    public PatchDocumentsResponse patch(String workspace, String collection, PatchDocumentsRequest body) throws Exception {
        ApiResponse<PatchDocumentsResponse> resp = this.patchWithHttpInfo(workspace, collection, body);
        return resp.getData();
    }

    public ApiResponse<PatchDocumentsResponse> patchWithHttpInfo(String workspace, String collection, PatchDocumentsRequest body) throws Exception {
        Call call = this.patchValidateBeforeCall(workspace, collection, body, null, null);
        Type localVarReturnType = new TypeToken<PatchDocumentsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchAsync(String workspace, String collection, PatchDocumentsRequest body, final ApiCallback<PatchDocumentsResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchValidateBeforeCall(workspace, collection, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PatchDocumentsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

