/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.api;

import com.google.gson.reflect.TypeToken;
import com.rockset.client.ApiCallback;
import com.rockset.client.ApiClient;
import com.rockset.client.ApiResponse;
import com.rockset.client.Configuration;
import com.rockset.client.Pair;
import com.rockset.client.ProgressRequestBody;
import com.rockset.client.ProgressResponseBody;
import com.rockset.client.model.CreateIntegrationRequest;
import com.rockset.client.model.CreateIntegrationResponse;
import com.rockset.client.model.DeleteIntegrationResponse;
import com.rockset.client.model.GetIntegrationResponse;
import com.rockset.client.model.ListIntegrationsResponse;
import com.rockset.client.model.UpdateIntegrationRequest;
import com.rockset.client.model.UpdateIntegrationResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class IntegrationsApi {
    private ApiClient apiClient;

    public IntegrationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createCall(CreateIntegrationRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        CreateIntegrationRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/integrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createValidateBeforeCall(CreateIntegrationRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling create(Async)");
        }
        Call call = this.createCall(body, progressListener, progressRequestListener);
        return call;
    }

    public CreateIntegrationResponse create(CreateIntegrationRequest body) throws Exception {
        ApiResponse<CreateIntegrationResponse> resp = this.createWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<CreateIntegrationResponse> createWithHttpInfo(CreateIntegrationRequest body) throws Exception {
        Call call = this.createValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<CreateIntegrationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createAsync(CreateIntegrationRequest body, final ApiCallback<CreateIntegrationResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateIntegrationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCall(String integration, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/integrations/{integration}".replaceAll("\\{integration\\}", this.apiClient.escapeString(integration.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteValidateBeforeCall(String integration, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (integration == null) {
            throw new Exception("Missing the required parameter 'integration' when calling delete(Async)");
        }
        Call call = this.deleteCall(integration, progressListener, progressRequestListener);
        return call;
    }

    public DeleteIntegrationResponse delete(String integration) throws Exception {
        ApiResponse<DeleteIntegrationResponse> resp = this.deleteWithHttpInfo(integration);
        return resp.getData();
    }

    public ApiResponse<DeleteIntegrationResponse> deleteWithHttpInfo(String integration) throws Exception {
        Call call = this.deleteValidateBeforeCall(integration, null, null);
        Type localVarReturnType = new TypeToken<DeleteIntegrationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAsync(String integration, final ApiCallback<DeleteIntegrationResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteValidateBeforeCall(integration, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeleteIntegrationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCall(String integration, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/integrations/{integration}".replaceAll("\\{integration\\}", this.apiClient.escapeString(integration.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getValidateBeforeCall(String integration, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (integration == null) {
            throw new Exception("Missing the required parameter 'integration' when calling get(Async)");
        }
        Call call = this.getCall(integration, progressListener, progressRequestListener);
        return call;
    }

    public GetIntegrationResponse get(String integration) throws Exception {
        ApiResponse<GetIntegrationResponse> resp = this.getWithHttpInfo(integration);
        return resp.getData();
    }

    public ApiResponse<GetIntegrationResponse> getWithHttpInfo(String integration) throws Exception {
        Call call = this.getValidateBeforeCall(integration, null, null);
        Type localVarReturnType = new TypeToken<GetIntegrationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAsync(String integration, final ApiCallback<GetIntegrationResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getValidateBeforeCall(integration, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetIntegrationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/integrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Call call = this.listCall(progressListener, progressRequestListener);
        return call;
    }

    public ListIntegrationsResponse list() throws Exception {
        ApiResponse<ListIntegrationsResponse> resp = this.listWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ListIntegrationsResponse> listWithHttpInfo() throws Exception {
        Call call = this.listValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ListIntegrationsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listAsync(final ApiCallback<ListIntegrationsResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListIntegrationsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCall(String integration, UpdateIntegrationRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        UpdateIntegrationRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/integrations/{integration}".replaceAll("\\{integration\\}", this.apiClient.escapeString(integration.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateValidateBeforeCall(String integration, UpdateIntegrationRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (integration == null) {
            throw new Exception("Missing the required parameter 'integration' when calling update(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling update(Async)");
        }
        Call call = this.updateCall(integration, body, progressListener, progressRequestListener);
        return call;
    }

    public UpdateIntegrationResponse update(String integration, UpdateIntegrationRequest body) throws Exception {
        ApiResponse<UpdateIntegrationResponse> resp = this.updateWithHttpInfo(integration, body);
        return resp.getData();
    }

    public ApiResponse<UpdateIntegrationResponse> updateWithHttpInfo(String integration, UpdateIntegrationRequest body) throws Exception {
        Call call = this.updateValidateBeforeCall(integration, body, null, null);
        Type localVarReturnType = new TypeToken<UpdateIntegrationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAsync(String integration, UpdateIntegrationRequest body, final ApiCallback<UpdateIntegrationResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateValidateBeforeCall(integration, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdateIntegrationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

