/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.api;

import com.google.gson.reflect.TypeToken;
import com.rockset.client.ApiCallback;
import com.rockset.client.ApiClient;
import com.rockset.client.ApiResponse;
import com.rockset.client.Configuration;
import com.rockset.client.Pair;
import com.rockset.client.ProgressRequestBody;
import com.rockset.client.ProgressResponseBody;
import com.rockset.client.model.CancelQueryResponse;
import com.rockset.client.model.GetQueryResponse;
import com.rockset.client.model.ListQueriesResponse;
import com.rockset.client.model.QueryPaginationResponse;
import com.rockset.client.model.QueryRequest;
import com.rockset.client.model.QueryResponse;
import com.rockset.client.model.ValidateQueryResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class QueriesApi {
    private ApiClient apiClient;

    public QueriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QueriesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call cancelCall(String queryId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/queries/{queryId}".replaceAll("\\{queryId\\}", this.apiClient.escapeString(queryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cancelValidateBeforeCall(String queryId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (queryId == null) {
            throw new Exception("Missing the required parameter 'queryId' when calling cancel(Async)");
        }
        Call call = this.cancelCall(queryId, progressListener, progressRequestListener);
        return call;
    }

    public CancelQueryResponse cancel(String queryId) throws Exception {
        ApiResponse<CancelQueryResponse> resp = this.cancelWithHttpInfo(queryId);
        return resp.getData();
    }

    public ApiResponse<CancelQueryResponse> cancelWithHttpInfo(String queryId) throws Exception {
        Call call = this.cancelValidateBeforeCall(queryId, null, null);
        Type localVarReturnType = new TypeToken<CancelQueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cancelAsync(String queryId, final ApiCallback<CancelQueryResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cancelValidateBeforeCall(queryId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CancelQueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCall(String queryId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/queries/{queryId}".replaceAll("\\{queryId\\}", this.apiClient.escapeString(queryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getValidateBeforeCall(String queryId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (queryId == null) {
            throw new Exception("Missing the required parameter 'queryId' when calling get(Async)");
        }
        Call call = this.getCall(queryId, progressListener, progressRequestListener);
        return call;
    }

    public GetQueryResponse get(String queryId) throws Exception {
        ApiResponse<GetQueryResponse> resp = this.getWithHttpInfo(queryId);
        return resp.getData();
    }

    public ApiResponse<GetQueryResponse> getWithHttpInfo(String queryId) throws Exception {
        Call call = this.getValidateBeforeCall(queryId, null, null);
        Type localVarReturnType = new TypeToken<GetQueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAsync(String queryId, final ApiCallback<GetQueryResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getValidateBeforeCall(queryId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetQueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call get_0Call(String queryId, String cursor, Integer docs, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/queries/{queryId}/pages".replaceAll("\\{queryId\\}", this.apiClient.escapeString(queryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        if (docs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("docs", docs));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call get_0ValidateBeforeCall(String queryId, String cursor, Integer docs, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (queryId == null) {
            throw new Exception("Missing the required parameter 'queryId' when calling get_0(Async)");
        }
        Call call = this.get_0Call(queryId, cursor, docs, offset, progressListener, progressRequestListener);
        return call;
    }

    public QueryPaginationResponse get_0(String queryId, String cursor, Integer docs, Integer offset) throws Exception {
        ApiResponse<QueryPaginationResponse> resp = this.get_0WithHttpInfo(queryId, cursor, docs, offset);
        return resp.getData();
    }

    public ApiResponse<QueryPaginationResponse> get_0WithHttpInfo(String queryId, String cursor, Integer docs, Integer offset) throws Exception {
        Call call = this.get_0ValidateBeforeCall(queryId, cursor, docs, offset, null, null);
        Type localVarReturnType = new TypeToken<QueryPaginationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call get_0Async(String queryId, String cursor, Integer docs, Integer offset, final ApiCallback<QueryPaginationResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.get_0ValidateBeforeCall(queryId, cursor, docs, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryPaginationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/queries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Call call = this.listCall(progressListener, progressRequestListener);
        return call;
    }

    public ListQueriesResponse list() throws Exception {
        ApiResponse<ListQueriesResponse> resp = this.listWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ListQueriesResponse> listWithHttpInfo() throws Exception {
        Call call = this.listValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ListQueriesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listAsync(final ApiCallback<ListQueriesResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListQueriesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call queryCall(QueryRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        QueryRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/queries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryValidateBeforeCall(QueryRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling query(Async)");
        }
        Call call = this.queryCall(body, progressListener, progressRequestListener);
        return call;
    }

    public QueryResponse query(QueryRequest body) throws Exception {
        ApiResponse<QueryResponse> resp = this.queryWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<QueryResponse> queryWithHttpInfo(QueryRequest body) throws Exception {
        Call call = this.queryValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call queryAsync(QueryRequest body, final ApiCallback<QueryResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.queryValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call validateCall(QueryRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        QueryRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/queries/validations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call validateValidateBeforeCall(QueryRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling validate(Async)");
        }
        Call call = this.validateCall(body, progressListener, progressRequestListener);
        return call;
    }

    public ValidateQueryResponse validate(QueryRequest body) throws Exception {
        ApiResponse<ValidateQueryResponse> resp = this.validateWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<ValidateQueryResponse> validateWithHttpInfo(QueryRequest body) throws Exception {
        Call call = this.validateValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<ValidateQueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call validateAsync(QueryRequest body, final ApiCallback<ValidateQueryResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.validateValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ValidateQueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

