/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.api;

import com.google.gson.reflect.TypeToken;
import com.rockset.client.ApiCallback;
import com.rockset.client.ApiClient;
import com.rockset.client.ApiResponse;
import com.rockset.client.Configuration;
import com.rockset.client.Pair;
import com.rockset.client.ProgressRequestBody;
import com.rockset.client.ProgressResponseBody;
import com.rockset.client.model.CreateQueryLambdaRequest;
import com.rockset.client.model.CreateQueryLambdaTagRequest;
import com.rockset.client.model.DeleteQueryLambdaResponse;
import com.rockset.client.model.ExecuteQueryLambdaRequest;
import com.rockset.client.model.ListQueryLambdaTagsResponse;
import com.rockset.client.model.ListQueryLambdaVersionsResponse;
import com.rockset.client.model.ListQueryLambdasResponse;
import com.rockset.client.model.QueryLambdaTagResponse;
import com.rockset.client.model.QueryLambdaVersionResponse;
import com.rockset.client.model.QueryResponse;
import com.rockset.client.model.UpdateQueryLambdaRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class QueryLambdasApi {
    private ApiClient apiClient;

    public QueryLambdasApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QueryLambdasApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createCall(String workspace, CreateQueryLambdaRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        CreateQueryLambdaRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createValidateBeforeCall(String workspace, CreateQueryLambdaRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling create(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling create(Async)");
        }
        Call call = this.createCall(workspace, body, progressListener, progressRequestListener);
        return call;
    }

    public QueryLambdaVersionResponse create(String workspace, CreateQueryLambdaRequest body) throws Exception {
        ApiResponse<QueryLambdaVersionResponse> resp = this.createWithHttpInfo(workspace, body);
        return resp.getData();
    }

    public ApiResponse<QueryLambdaVersionResponse> createWithHttpInfo(String workspace, CreateQueryLambdaRequest body) throws Exception {
        Call call = this.createValidateBeforeCall(workspace, body, null, null);
        Type localVarReturnType = new TypeToken<QueryLambdaVersionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createAsync(String workspace, CreateQueryLambdaRequest body, final ApiCallback<QueryLambdaVersionResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createValidateBeforeCall(workspace, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryLambdaVersionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call create_0Call(String workspace, String queryLambda, CreateQueryLambdaTagRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        CreateQueryLambdaTagRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call create_0ValidateBeforeCall(String workspace, String queryLambda, CreateQueryLambdaTagRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling create_0(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling create_0(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling create_0(Async)");
        }
        Call call = this.create_0Call(workspace, queryLambda, body, progressListener, progressRequestListener);
        return call;
    }

    public QueryLambdaTagResponse create_0(String workspace, String queryLambda, CreateQueryLambdaTagRequest body) throws Exception {
        ApiResponse<QueryLambdaTagResponse> resp = this.create_0WithHttpInfo(workspace, queryLambda, body);
        return resp.getData();
    }

    public ApiResponse<QueryLambdaTagResponse> create_0WithHttpInfo(String workspace, String queryLambda, CreateQueryLambdaTagRequest body) throws Exception {
        Call call = this.create_0ValidateBeforeCall(workspace, queryLambda, body, null, null);
        Type localVarReturnType = new TypeToken<QueryLambdaTagResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call create_0Async(String workspace, String queryLambda, CreateQueryLambdaTagRequest body, final ApiCallback<QueryLambdaTagResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.create_0ValidateBeforeCall(workspace, queryLambda, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryLambdaTagResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCall(String workspace, String queryLambda, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteValidateBeforeCall(String workspace, String queryLambda, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling delete(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling delete(Async)");
        }
        Call call = this.deleteCall(workspace, queryLambda, progressListener, progressRequestListener);
        return call;
    }

    public DeleteQueryLambdaResponse delete(String workspace, String queryLambda) throws Exception {
        ApiResponse<DeleteQueryLambdaResponse> resp = this.deleteWithHttpInfo(workspace, queryLambda);
        return resp.getData();
    }

    public ApiResponse<DeleteQueryLambdaResponse> deleteWithHttpInfo(String workspace, String queryLambda) throws Exception {
        Call call = this.deleteValidateBeforeCall(workspace, queryLambda, null, null);
        Type localVarReturnType = new TypeToken<DeleteQueryLambdaResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAsync(String workspace, String queryLambda, final ApiCallback<DeleteQueryLambdaResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteValidateBeforeCall(workspace, queryLambda, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeleteQueryLambdaResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call delete_0Call(String workspace, String queryLambda, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString())).replaceAll("\\{tag\\}", this.apiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call delete_0ValidateBeforeCall(String workspace, String queryLambda, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling delete_0(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling delete_0(Async)");
        }
        if (tag == null) {
            throw new Exception("Missing the required parameter 'tag' when calling delete_0(Async)");
        }
        Call call = this.delete_0Call(workspace, queryLambda, tag, progressListener, progressRequestListener);
        return call;
    }

    public QueryLambdaTagResponse delete_0(String workspace, String queryLambda, String tag) throws Exception {
        ApiResponse<QueryLambdaTagResponse> resp = this.delete_0WithHttpInfo(workspace, queryLambda, tag);
        return resp.getData();
    }

    public ApiResponse<QueryLambdaTagResponse> delete_0WithHttpInfo(String workspace, String queryLambda, String tag) throws Exception {
        Call call = this.delete_0ValidateBeforeCall(workspace, queryLambda, tag, null, null);
        Type localVarReturnType = new TypeToken<QueryLambdaTagResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call delete_0Async(String workspace, String queryLambda, String tag, final ApiCallback<QueryLambdaTagResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.delete_0ValidateBeforeCall(workspace, queryLambda, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryLambdaTagResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call delete_1Call(String workspace, String queryLambda, String version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/version/{version}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call delete_1ValidateBeforeCall(String workspace, String queryLambda, String version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling delete_1(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling delete_1(Async)");
        }
        if (version == null) {
            throw new Exception("Missing the required parameter 'version' when calling delete_1(Async)");
        }
        Call call = this.delete_1Call(workspace, queryLambda, version, progressListener, progressRequestListener);
        return call;
    }

    public QueryLambdaVersionResponse delete_1(String workspace, String queryLambda, String version) throws Exception {
        ApiResponse<QueryLambdaVersionResponse> resp = this.delete_1WithHttpInfo(workspace, queryLambda, version);
        return resp.getData();
    }

    public ApiResponse<QueryLambdaVersionResponse> delete_1WithHttpInfo(String workspace, String queryLambda, String version) throws Exception {
        Call call = this.delete_1ValidateBeforeCall(workspace, queryLambda, version, null, null);
        Type localVarReturnType = new TypeToken<QueryLambdaVersionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call delete_1Async(String workspace, String queryLambda, String version, final ApiCallback<QueryLambdaVersionResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.delete_1ValidateBeforeCall(workspace, queryLambda, version, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryLambdaVersionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call executeCall(String workspace, String queryLambda, String tag, ExecuteQueryLambdaRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        ExecuteQueryLambdaRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString())).replaceAll("\\{tag\\}", this.apiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call executeValidateBeforeCall(String workspace, String queryLambda, String tag, ExecuteQueryLambdaRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling execute(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling execute(Async)");
        }
        if (tag == null) {
            throw new Exception("Missing the required parameter 'tag' when calling execute(Async)");
        }
        Call call = this.executeCall(workspace, queryLambda, tag, body, progressListener, progressRequestListener);
        return call;
    }

    public QueryResponse execute(String workspace, String queryLambda, String tag, ExecuteQueryLambdaRequest body) throws Exception {
        ApiResponse<QueryResponse> resp = this.executeWithHttpInfo(workspace, queryLambda, tag, body);
        return resp.getData();
    }

    public ApiResponse<QueryResponse> executeWithHttpInfo(String workspace, String queryLambda, String tag, ExecuteQueryLambdaRequest body) throws Exception {
        Call call = this.executeValidateBeforeCall(workspace, queryLambda, tag, body, null, null);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call executeAsync(String workspace, String queryLambda, String tag, ExecuteQueryLambdaRequest body, final ApiCallback<QueryResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.executeValidateBeforeCall(workspace, queryLambda, tag, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call execute_0Call(String workspace, String queryLambda, String version, ExecuteQueryLambdaRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        ExecuteQueryLambdaRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions/{version}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call execute_0ValidateBeforeCall(String workspace, String queryLambda, String version, ExecuteQueryLambdaRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling execute_0(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling execute_0(Async)");
        }
        if (version == null) {
            throw new Exception("Missing the required parameter 'version' when calling execute_0(Async)");
        }
        Call call = this.execute_0Call(workspace, queryLambda, version, body, progressListener, progressRequestListener);
        return call;
    }

    public QueryResponse execute_0(String workspace, String queryLambda, String version, ExecuteQueryLambdaRequest body) throws Exception {
        ApiResponse<QueryResponse> resp = this.execute_0WithHttpInfo(workspace, queryLambda, version, body);
        return resp.getData();
    }

    public ApiResponse<QueryResponse> execute_0WithHttpInfo(String workspace, String queryLambda, String version, ExecuteQueryLambdaRequest body) throws Exception {
        Call call = this.execute_0ValidateBeforeCall(workspace, queryLambda, version, body, null, null);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call execute_0Async(String workspace, String queryLambda, String version, ExecuteQueryLambdaRequest body, final ApiCallback<QueryResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.execute_0ValidateBeforeCall(workspace, queryLambda, version, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCall(String workspace, String queryLambda, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString())).replaceAll("\\{tag\\}", this.apiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getValidateBeforeCall(String workspace, String queryLambda, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling get(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling get(Async)");
        }
        if (tag == null) {
            throw new Exception("Missing the required parameter 'tag' when calling get(Async)");
        }
        Call call = this.getCall(workspace, queryLambda, tag, progressListener, progressRequestListener);
        return call;
    }

    public QueryLambdaTagResponse get(String workspace, String queryLambda, String tag) throws Exception {
        ApiResponse<QueryLambdaTagResponse> resp = this.getWithHttpInfo(workspace, queryLambda, tag);
        return resp.getData();
    }

    public ApiResponse<QueryLambdaTagResponse> getWithHttpInfo(String workspace, String queryLambda, String tag) throws Exception {
        Call call = this.getValidateBeforeCall(workspace, queryLambda, tag, null, null);
        Type localVarReturnType = new TypeToken<QueryLambdaTagResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAsync(String workspace, String queryLambda, String tag, final ApiCallback<QueryLambdaTagResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getValidateBeforeCall(workspace, queryLambda, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryLambdaTagResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call get_0Call(String workspace, String queryLambda, String version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions/{version}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call get_0ValidateBeforeCall(String workspace, String queryLambda, String version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling get_0(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling get_0(Async)");
        }
        if (version == null) {
            throw new Exception("Missing the required parameter 'version' when calling get_0(Async)");
        }
        Call call = this.get_0Call(workspace, queryLambda, version, progressListener, progressRequestListener);
        return call;
    }

    public QueryLambdaVersionResponse get_0(String workspace, String queryLambda, String version) throws Exception {
        ApiResponse<QueryLambdaVersionResponse> resp = this.get_0WithHttpInfo(workspace, queryLambda, version);
        return resp.getData();
    }

    public ApiResponse<QueryLambdaVersionResponse> get_0WithHttpInfo(String workspace, String queryLambda, String version) throws Exception {
        Call call = this.get_0ValidateBeforeCall(workspace, queryLambda, version, null, null);
        Type localVarReturnType = new TypeToken<QueryLambdaVersionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call get_0Async(String workspace, String queryLambda, String version, final ApiCallback<QueryLambdaVersionResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.get_0ValidateBeforeCall(workspace, queryLambda, version, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryLambdaVersionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/lambdas";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Call call = this.listCall(progressListener, progressRequestListener);
        return call;
    }

    public ListQueryLambdasResponse list() throws Exception {
        ApiResponse<ListQueryLambdasResponse> resp = this.listWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ListQueryLambdasResponse> listWithHttpInfo() throws Exception {
        Call call = this.listValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ListQueryLambdasResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listAsync(final ApiCallback<ListQueryLambdasResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListQueryLambdasResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call list_0Call(String workspace, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call list_0ValidateBeforeCall(String workspace, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling list_0(Async)");
        }
        Call call = this.list_0Call(workspace, progressListener, progressRequestListener);
        return call;
    }

    public ListQueryLambdasResponse list_0(String workspace) throws Exception {
        ApiResponse<ListQueryLambdasResponse> resp = this.list_0WithHttpInfo(workspace);
        return resp.getData();
    }

    public ApiResponse<ListQueryLambdasResponse> list_0WithHttpInfo(String workspace) throws Exception {
        Call call = this.list_0ValidateBeforeCall(workspace, null, null);
        Type localVarReturnType = new TypeToken<ListQueryLambdasResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call list_0Async(String workspace, final ApiCallback<ListQueryLambdasResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.list_0ValidateBeforeCall(workspace, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListQueryLambdasResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call list_1Call(String workspace, String queryLambda, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call list_1ValidateBeforeCall(String workspace, String queryLambda, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling list_1(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling list_1(Async)");
        }
        Call call = this.list_1Call(workspace, queryLambda, progressListener, progressRequestListener);
        return call;
    }

    public ListQueryLambdaTagsResponse list_1(String workspace, String queryLambda) throws Exception {
        ApiResponse<ListQueryLambdaTagsResponse> resp = this.list_1WithHttpInfo(workspace, queryLambda);
        return resp.getData();
    }

    public ApiResponse<ListQueryLambdaTagsResponse> list_1WithHttpInfo(String workspace, String queryLambda) throws Exception {
        Call call = this.list_1ValidateBeforeCall(workspace, queryLambda, null, null);
        Type localVarReturnType = new TypeToken<ListQueryLambdaTagsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call list_1Async(String workspace, String queryLambda, final ApiCallback<ListQueryLambdaTagsResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.list_1ValidateBeforeCall(workspace, queryLambda, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListQueryLambdaTagsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call list_2Call(String workspace, String queryLambda, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call list_2ValidateBeforeCall(String workspace, String queryLambda, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling list_2(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling list_2(Async)");
        }
        Call call = this.list_2Call(workspace, queryLambda, progressListener, progressRequestListener);
        return call;
    }

    public ListQueryLambdaVersionsResponse list_2(String workspace, String queryLambda) throws Exception {
        ApiResponse<ListQueryLambdaVersionsResponse> resp = this.list_2WithHttpInfo(workspace, queryLambda);
        return resp.getData();
    }

    public ApiResponse<ListQueryLambdaVersionsResponse> list_2WithHttpInfo(String workspace, String queryLambda) throws Exception {
        Call call = this.list_2ValidateBeforeCall(workspace, queryLambda, null, null);
        Type localVarReturnType = new TypeToken<ListQueryLambdaVersionsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call list_2Async(String workspace, String queryLambda, final ApiCallback<ListQueryLambdaVersionsResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.list_2ValidateBeforeCall(workspace, queryLambda, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListQueryLambdaVersionsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCall(String workspace, String queryLambda, UpdateQueryLambdaRequest body, Boolean create, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        UpdateQueryLambdaRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{queryLambda\\}", this.apiClient.escapeString(queryLambda.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (create != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("create", create));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateValidateBeforeCall(String workspace, String queryLambda, UpdateQueryLambdaRequest body, Boolean create, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling update(Async)");
        }
        if (queryLambda == null) {
            throw new Exception("Missing the required parameter 'queryLambda' when calling update(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling update(Async)");
        }
        Call call = this.updateCall(workspace, queryLambda, body, create, progressListener, progressRequestListener);
        return call;
    }

    public QueryLambdaVersionResponse update(String workspace, String queryLambda, UpdateQueryLambdaRequest body, Boolean create) throws Exception {
        ApiResponse<QueryLambdaVersionResponse> resp = this.updateWithHttpInfo(workspace, queryLambda, body, create);
        return resp.getData();
    }

    public ApiResponse<QueryLambdaVersionResponse> updateWithHttpInfo(String workspace, String queryLambda, UpdateQueryLambdaRequest body, Boolean create) throws Exception {
        Call call = this.updateValidateBeforeCall(workspace, queryLambda, body, create, null, null);
        Type localVarReturnType = new TypeToken<QueryLambdaVersionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAsync(String workspace, String queryLambda, UpdateQueryLambdaRequest body, Boolean create, final ApiCallback<QueryLambdaVersionResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateValidateBeforeCall(workspace, queryLambda, body, create, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryLambdaVersionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

