/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.api;

import com.google.gson.reflect.TypeToken;
import com.rockset.client.ApiCallback;
import com.rockset.client.ApiClient;
import com.rockset.client.ApiResponse;
import com.rockset.client.Configuration;
import com.rockset.client.Pair;
import com.rockset.client.ProgressRequestBody;
import com.rockset.client.ProgressResponseBody;
import com.rockset.client.model.ExecutePublicQueryLambdaRequest;
import com.rockset.client.model.QueryResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class SharedLambdasApi {
    private ApiClient apiClient;

    public SharedLambdasApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SharedLambdasApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call executeCall(String publicAccessId, ExecutePublicQueryLambdaRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        ExecutePublicQueryLambdaRequest localVarPostBody = body;
        String localVarPath = "/v1/public/shared_lambdas/{public_access_id}".replaceAll("\\{public_access_id\\}", this.apiClient.escapeString(publicAccessId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call executeValidateBeforeCall(String publicAccessId, ExecutePublicQueryLambdaRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (publicAccessId == null) {
            throw new Exception("Missing the required parameter 'publicAccessId' when calling execute(Async)");
        }
        Call call = this.executeCall(publicAccessId, body, progressListener, progressRequestListener);
        return call;
    }

    public QueryResponse execute(String publicAccessId, ExecutePublicQueryLambdaRequest body) throws Exception {
        ApiResponse<QueryResponse> resp = this.executeWithHttpInfo(publicAccessId, body);
        return resp.getData();
    }

    public ApiResponse<QueryResponse> executeWithHttpInfo(String publicAccessId, ExecutePublicQueryLambdaRequest body) throws Exception {
        Call call = this.executeValidateBeforeCall(publicAccessId, body, null, null);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call executeAsync(String publicAccessId, ExecutePublicQueryLambdaRequest body, final ApiCallback<QueryResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.executeValidateBeforeCall(publicAccessId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

