/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.api;

import com.google.gson.reflect.TypeToken;
import com.rockset.client.ApiCallback;
import com.rockset.client.ApiClient;
import com.rockset.client.ApiResponse;
import com.rockset.client.Configuration;
import com.rockset.client.Pair;
import com.rockset.client.ProgressRequestBody;
import com.rockset.client.ProgressResponseBody;
import com.rockset.client.model.DeleteSourceResponse;
import com.rockset.client.model.GetSourceResponse;
import com.rockset.client.model.ListSourcesResponse;
import com.rockset.client.model.Source;
import com.rockset.client.model.SourceBase;
import com.rockset.client.model.SuspendSourceRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class SourcesApi {
    private ApiClient apiClient;

    public SourcesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SourcesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createCall(String workspace, String collection, Source body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Source localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/sources".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createValidateBeforeCall(String workspace, String collection, Source body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling create(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling create(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling create(Async)");
        }
        Call call = this.createCall(workspace, collection, body, progressListener, progressRequestListener);
        return call;
    }

    public GetSourceResponse create(String workspace, String collection, Source body) throws Exception {
        ApiResponse<GetSourceResponse> resp = this.createWithHttpInfo(workspace, collection, body);
        return resp.getData();
    }

    public ApiResponse<GetSourceResponse> createWithHttpInfo(String workspace, String collection, Source body) throws Exception {
        Call call = this.createValidateBeforeCall(workspace, collection, body, null, null);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createAsync(String workspace, String collection, Source body, final ApiCallback<GetSourceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createValidateBeforeCall(workspace, collection, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCall(String workspace, String collection, String source, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/sources/{source}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString())).replaceAll("\\{source\\}", this.apiClient.escapeString(source.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteValidateBeforeCall(String workspace, String collection, String source, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling delete(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling delete(Async)");
        }
        if (source == null) {
            throw new Exception("Missing the required parameter 'source' when calling delete(Async)");
        }
        Call call = this.deleteCall(workspace, collection, source, progressListener, progressRequestListener);
        return call;
    }

    public DeleteSourceResponse delete(String workspace, String collection, String source) throws Exception {
        ApiResponse<DeleteSourceResponse> resp = this.deleteWithHttpInfo(workspace, collection, source);
        return resp.getData();
    }

    public ApiResponse<DeleteSourceResponse> deleteWithHttpInfo(String workspace, String collection, String source) throws Exception {
        Call call = this.deleteValidateBeforeCall(workspace, collection, source, null, null);
        Type localVarReturnType = new TypeToken<DeleteSourceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAsync(String workspace, String collection, String source, final ApiCallback<DeleteSourceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteValidateBeforeCall(workspace, collection, source, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeleteSourceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCall(String workspace, String collection, String source, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/sources/{source}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString())).replaceAll("\\{source\\}", this.apiClient.escapeString(source.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getValidateBeforeCall(String workspace, String collection, String source, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling get(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling get(Async)");
        }
        if (source == null) {
            throw new Exception("Missing the required parameter 'source' when calling get(Async)");
        }
        Call call = this.getCall(workspace, collection, source, progressListener, progressRequestListener);
        return call;
    }

    public GetSourceResponse get(String workspace, String collection, String source) throws Exception {
        ApiResponse<GetSourceResponse> resp = this.getWithHttpInfo(workspace, collection, source);
        return resp.getData();
    }

    public ApiResponse<GetSourceResponse> getWithHttpInfo(String workspace, String collection, String source) throws Exception {
        Call call = this.getValidateBeforeCall(workspace, collection, source, null, null);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAsync(String workspace, String collection, String source, final ApiCallback<GetSourceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getValidateBeforeCall(workspace, collection, source, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listCall(String workspace, String collection, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/sources".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listValidateBeforeCall(String workspace, String collection, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling list(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling list(Async)");
        }
        Call call = this.listCall(workspace, collection, progressListener, progressRequestListener);
        return call;
    }

    public ListSourcesResponse list(String workspace, String collection) throws Exception {
        ApiResponse<ListSourcesResponse> resp = this.listWithHttpInfo(workspace, collection);
        return resp.getData();
    }

    public ApiResponse<ListSourcesResponse> listWithHttpInfo(String workspace, String collection) throws Exception {
        Call call = this.listValidateBeforeCall(workspace, collection, null, null);
        Type localVarReturnType = new TypeToken<ListSourcesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listAsync(String workspace, String collection, final ApiCallback<ListSourcesResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listValidateBeforeCall(workspace, collection, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListSourcesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call resumeCall(String workspace, String collection, String source, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/sources/{source}/resume".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString())).replaceAll("\\{source\\}", this.apiClient.escapeString(source.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call resumeValidateBeforeCall(String workspace, String collection, String source, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling resume(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling resume(Async)");
        }
        if (source == null) {
            throw new Exception("Missing the required parameter 'source' when calling resume(Async)");
        }
        Call call = this.resumeCall(workspace, collection, source, progressListener, progressRequestListener);
        return call;
    }

    public GetSourceResponse resume(String workspace, String collection, String source) throws Exception {
        ApiResponse<GetSourceResponse> resp = this.resumeWithHttpInfo(workspace, collection, source);
        return resp.getData();
    }

    public ApiResponse<GetSourceResponse> resumeWithHttpInfo(String workspace, String collection, String source) throws Exception {
        Call call = this.resumeValidateBeforeCall(workspace, collection, source, null, null);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call resumeAsync(String workspace, String collection, String source, final ApiCallback<GetSourceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.resumeValidateBeforeCall(workspace, collection, source, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call suspendCall(String workspace, String collection, String source, SuspendSourceRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        SuspendSourceRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/sources/{source}/suspend".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString())).replaceAll("\\{source\\}", this.apiClient.escapeString(source.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call suspendValidateBeforeCall(String workspace, String collection, String source, SuspendSourceRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling suspend(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling suspend(Async)");
        }
        if (source == null) {
            throw new Exception("Missing the required parameter 'source' when calling suspend(Async)");
        }
        Call call = this.suspendCall(workspace, collection, source, body, progressListener, progressRequestListener);
        return call;
    }

    public GetSourceResponse suspend(String workspace, String collection, String source, SuspendSourceRequest body) throws Exception {
        ApiResponse<GetSourceResponse> resp = this.suspendWithHttpInfo(workspace, collection, source, body);
        return resp.getData();
    }

    public ApiResponse<GetSourceResponse> suspendWithHttpInfo(String workspace, String collection, String source, SuspendSourceRequest body) throws Exception {
        Call call = this.suspendValidateBeforeCall(workspace, collection, source, body, null, null);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call suspendAsync(String workspace, String collection, String source, SuspendSourceRequest body, final ApiCallback<GetSourceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.suspendValidateBeforeCall(workspace, collection, source, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCall(String workspace, String collection, String source, SourceBase body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        SourceBase localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/ws/{workspace}/collections/{collection}/sources/{source}".replaceAll("\\{workspace\\}", this.apiClient.escapeString(workspace.toString())).replaceAll("\\{collection\\}", this.apiClient.escapeString(collection.toString())).replaceAll("\\{source\\}", this.apiClient.escapeString(source.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateValidateBeforeCall(String workspace, String collection, String source, SourceBase body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (workspace == null) {
            throw new Exception("Missing the required parameter 'workspace' when calling update(Async)");
        }
        if (collection == null) {
            throw new Exception("Missing the required parameter 'collection' when calling update(Async)");
        }
        if (source == null) {
            throw new Exception("Missing the required parameter 'source' when calling update(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling update(Async)");
        }
        Call call = this.updateCall(workspace, collection, source, body, progressListener, progressRequestListener);
        return call;
    }

    public GetSourceResponse update(String workspace, String collection, String source, SourceBase body) throws Exception {
        ApiResponse<GetSourceResponse> resp = this.updateWithHttpInfo(workspace, collection, source, body);
        return resp.getData();
    }

    public ApiResponse<GetSourceResponse> updateWithHttpInfo(String workspace, String collection, String source, SourceBase body) throws Exception {
        Call call = this.updateValidateBeforeCall(workspace, collection, source, body, null, null);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAsync(String workspace, String collection, String source, SourceBase body, final ApiCallback<GetSourceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateValidateBeforeCall(workspace, collection, source, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSourceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

