/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.api;

import com.google.gson.reflect.TypeToken;
import com.rockset.client.ApiCallback;
import com.rockset.client.ApiClient;
import com.rockset.client.ApiResponse;
import com.rockset.client.Configuration;
import com.rockset.client.Pair;
import com.rockset.client.ProgressRequestBody;
import com.rockset.client.ProgressResponseBody;
import com.rockset.client.model.CollectionMountResponse;
import com.rockset.client.model.CreateCollectionMountRequest;
import com.rockset.client.model.CreateCollectionMountsResponse;
import com.rockset.client.model.CreateVirtualInstanceRequest;
import com.rockset.client.model.CreateVirtualInstanceResponse;
import com.rockset.client.model.DeleteVirtualInstanceResponse;
import com.rockset.client.model.GetCollectionCommit;
import com.rockset.client.model.GetCollectionCommitRequest;
import com.rockset.client.model.GetVirtualInstanceResponse;
import com.rockset.client.model.ListCollectionMountsResponse;
import com.rockset.client.model.ListQueriesResponse;
import com.rockset.client.model.ListVirtualInstancesResponse;
import com.rockset.client.model.QueryRequest;
import com.rockset.client.model.QueryResponse;
import com.rockset.client.model.ResumeVirtualInstanceResponse;
import com.rockset.client.model.SuspendVirtualInstanceResponse;
import com.rockset.client.model.UpdateVirtualInstanceRequest;
import com.rockset.client.model.UpdateVirtualInstanceResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class VirtualInstancesApi {
    private ApiClient apiClient;

    public VirtualInstancesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VirtualInstancesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createCall(CreateVirtualInstanceRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        CreateVirtualInstanceRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/virtualinstances";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createValidateBeforeCall(CreateVirtualInstanceRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling create(Async)");
        }
        Call call = this.createCall(body, progressListener, progressRequestListener);
        return call;
    }

    public CreateVirtualInstanceResponse create(CreateVirtualInstanceRequest body) throws Exception {
        ApiResponse<CreateVirtualInstanceResponse> resp = this.createWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<CreateVirtualInstanceResponse> createWithHttpInfo(CreateVirtualInstanceRequest body) throws Exception {
        Call call = this.createValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<CreateVirtualInstanceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createAsync(CreateVirtualInstanceRequest body, final ApiCallback<CreateVirtualInstanceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateVirtualInstanceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCall(String virtualInstanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteValidateBeforeCall(String virtualInstanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling delete(Async)");
        }
        Call call = this.deleteCall(virtualInstanceId, progressListener, progressRequestListener);
        return call;
    }

    public DeleteVirtualInstanceResponse delete(String virtualInstanceId) throws Exception {
        ApiResponse<DeleteVirtualInstanceResponse> resp = this.deleteWithHttpInfo(virtualInstanceId);
        return resp.getData();
    }

    public ApiResponse<DeleteVirtualInstanceResponse> deleteWithHttpInfo(String virtualInstanceId) throws Exception {
        Call call = this.deleteValidateBeforeCall(virtualInstanceId, null, null);
        Type localVarReturnType = new TypeToken<DeleteVirtualInstanceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAsync(String virtualInstanceId, final ApiCallback<DeleteVirtualInstanceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteValidateBeforeCall(virtualInstanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeleteVirtualInstanceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCall(String virtualInstanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getValidateBeforeCall(String virtualInstanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling get(Async)");
        }
        Call call = this.getCall(virtualInstanceId, progressListener, progressRequestListener);
        return call;
    }

    public GetVirtualInstanceResponse get(String virtualInstanceId) throws Exception {
        ApiResponse<GetVirtualInstanceResponse> resp = this.getWithHttpInfo(virtualInstanceId);
        return resp.getData();
    }

    public ApiResponse<GetVirtualInstanceResponse> getWithHttpInfo(String virtualInstanceId) throws Exception {
        Call call = this.getValidateBeforeCall(virtualInstanceId, null, null);
        Type localVarReturnType = new TypeToken<GetVirtualInstanceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAsync(String virtualInstanceId, final ApiCallback<GetVirtualInstanceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getValidateBeforeCall(virtualInstanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetVirtualInstanceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call get_0Call(String virtualInstanceId, String collectionPath, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}/mounts/{collectionPath}".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString())).replaceAll("\\{collectionPath\\}", this.apiClient.escapeString(collectionPath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call get_0ValidateBeforeCall(String virtualInstanceId, String collectionPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling get_0(Async)");
        }
        if (collectionPath == null) {
            throw new Exception("Missing the required parameter 'collectionPath' when calling get_0(Async)");
        }
        Call call = this.get_0Call(virtualInstanceId, collectionPath, progressListener, progressRequestListener);
        return call;
    }

    public CollectionMountResponse get_0(String virtualInstanceId, String collectionPath) throws Exception {
        ApiResponse<CollectionMountResponse> resp = this.get_0WithHttpInfo(virtualInstanceId, collectionPath);
        return resp.getData();
    }

    public ApiResponse<CollectionMountResponse> get_0WithHttpInfo(String virtualInstanceId, String collectionPath) throws Exception {
        Call call = this.get_0ValidateBeforeCall(virtualInstanceId, collectionPath, null, null);
        Type localVarReturnType = new TypeToken<CollectionMountResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call get_0Async(String virtualInstanceId, String collectionPath, final ApiCallback<CollectionMountResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.get_0ValidateBeforeCall(virtualInstanceId, collectionPath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CollectionMountResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call get_1Call(String virtualInstanceId, String collectionPath, GetCollectionCommitRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        GetCollectionCommitRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}/mounts/{collectionPath}/offsets/commit".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString())).replaceAll("\\{collectionPath\\}", this.apiClient.escapeString(collectionPath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call get_1ValidateBeforeCall(String virtualInstanceId, String collectionPath, GetCollectionCommitRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling get_1(Async)");
        }
        if (collectionPath == null) {
            throw new Exception("Missing the required parameter 'collectionPath' when calling get_1(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling get_1(Async)");
        }
        Call call = this.get_1Call(virtualInstanceId, collectionPath, body, progressListener, progressRequestListener);
        return call;
    }

    public GetCollectionCommit get_1(String virtualInstanceId, String collectionPath, GetCollectionCommitRequest body) throws Exception {
        ApiResponse<GetCollectionCommit> resp = this.get_1WithHttpInfo(virtualInstanceId, collectionPath, body);
        return resp.getData();
    }

    public ApiResponse<GetCollectionCommit> get_1WithHttpInfo(String virtualInstanceId, String collectionPath, GetCollectionCommitRequest body) throws Exception {
        Call call = this.get_1ValidateBeforeCall(virtualInstanceId, collectionPath, body, null, null);
        Type localVarReturnType = new TypeToken<GetCollectionCommit>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call get_1Async(String virtualInstanceId, String collectionPath, GetCollectionCommitRequest body, final ApiCallback<GetCollectionCommit> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.get_1ValidateBeforeCall(virtualInstanceId, collectionPath, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetCollectionCommit>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call get_2Call(String virtualInstanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}/queries".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call get_2ValidateBeforeCall(String virtualInstanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling get_2(Async)");
        }
        Call call = this.get_2Call(virtualInstanceId, progressListener, progressRequestListener);
        return call;
    }

    public ListQueriesResponse get_2(String virtualInstanceId) throws Exception {
        ApiResponse<ListQueriesResponse> resp = this.get_2WithHttpInfo(virtualInstanceId);
        return resp.getData();
    }

    public ApiResponse<ListQueriesResponse> get_2WithHttpInfo(String virtualInstanceId) throws Exception {
        Call call = this.get_2ValidateBeforeCall(virtualInstanceId, null, null);
        Type localVarReturnType = new TypeToken<ListQueriesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call get_2Async(String virtualInstanceId, final ApiCallback<ListQueriesResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.get_2ValidateBeforeCall(virtualInstanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListQueriesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/virtualinstances";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Call call = this.listCall(progressListener, progressRequestListener);
        return call;
    }

    public ListVirtualInstancesResponse list() throws Exception {
        ApiResponse<ListVirtualInstancesResponse> resp = this.listWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ListVirtualInstancesResponse> listWithHttpInfo() throws Exception {
        Call call = this.listValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ListVirtualInstancesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listAsync(final ApiCallback<ListVirtualInstancesResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListVirtualInstancesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call list_0Call(String virtualInstanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}/mounts".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call list_0ValidateBeforeCall(String virtualInstanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling list_0(Async)");
        }
        Call call = this.list_0Call(virtualInstanceId, progressListener, progressRequestListener);
        return call;
    }

    public ListCollectionMountsResponse list_0(String virtualInstanceId) throws Exception {
        ApiResponse<ListCollectionMountsResponse> resp = this.list_0WithHttpInfo(virtualInstanceId);
        return resp.getData();
    }

    public ApiResponse<ListCollectionMountsResponse> list_0WithHttpInfo(String virtualInstanceId) throws Exception {
        Call call = this.list_0ValidateBeforeCall(virtualInstanceId, null, null);
        Type localVarReturnType = new TypeToken<ListCollectionMountsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call list_0Async(String virtualInstanceId, final ApiCallback<ListCollectionMountsResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.list_0ValidateBeforeCall(virtualInstanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCollectionMountsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call mountCall(String virtualInstanceId, CreateCollectionMountRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        CreateCollectionMountRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}/mounts".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call mountValidateBeforeCall(String virtualInstanceId, CreateCollectionMountRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling mount(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling mount(Async)");
        }
        Call call = this.mountCall(virtualInstanceId, body, progressListener, progressRequestListener);
        return call;
    }

    public CreateCollectionMountsResponse mount(String virtualInstanceId, CreateCollectionMountRequest body) throws Exception {
        ApiResponse<CreateCollectionMountsResponse> resp = this.mountWithHttpInfo(virtualInstanceId, body);
        return resp.getData();
    }

    public ApiResponse<CreateCollectionMountsResponse> mountWithHttpInfo(String virtualInstanceId, CreateCollectionMountRequest body) throws Exception {
        Call call = this.mountValidateBeforeCall(virtualInstanceId, body, null, null);
        Type localVarReturnType = new TypeToken<CreateCollectionMountsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call mountAsync(String virtualInstanceId, CreateCollectionMountRequest body, final ApiCallback<CreateCollectionMountsResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.mountValidateBeforeCall(virtualInstanceId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateCollectionMountsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call queryCall(String virtualInstanceId, QueryRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        QueryRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}/queries".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryValidateBeforeCall(String virtualInstanceId, QueryRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling query(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling query(Async)");
        }
        Call call = this.queryCall(virtualInstanceId, body, progressListener, progressRequestListener);
        return call;
    }

    public QueryResponse query(String virtualInstanceId, QueryRequest body) throws Exception {
        ApiResponse<QueryResponse> resp = this.queryWithHttpInfo(virtualInstanceId, body);
        return resp.getData();
    }

    public ApiResponse<QueryResponse> queryWithHttpInfo(String virtualInstanceId, QueryRequest body) throws Exception {
        Call call = this.queryValidateBeforeCall(virtualInstanceId, body, null, null);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call queryAsync(String virtualInstanceId, QueryRequest body, final ApiCallback<QueryResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.queryValidateBeforeCall(virtualInstanceId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call resumeCall(String virtualInstanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}/resume".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call resumeValidateBeforeCall(String virtualInstanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling resume(Async)");
        }
        Call call = this.resumeCall(virtualInstanceId, progressListener, progressRequestListener);
        return call;
    }

    public ResumeVirtualInstanceResponse resume(String virtualInstanceId) throws Exception {
        ApiResponse<ResumeVirtualInstanceResponse> resp = this.resumeWithHttpInfo(virtualInstanceId);
        return resp.getData();
    }

    public ApiResponse<ResumeVirtualInstanceResponse> resumeWithHttpInfo(String virtualInstanceId) throws Exception {
        Call call = this.resumeValidateBeforeCall(virtualInstanceId, null, null);
        Type localVarReturnType = new TypeToken<ResumeVirtualInstanceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call resumeAsync(String virtualInstanceId, final ApiCallback<ResumeVirtualInstanceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.resumeValidateBeforeCall(virtualInstanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResumeVirtualInstanceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call setCall(String virtualInstanceId, UpdateVirtualInstanceRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        UpdateVirtualInstanceRequest localVarPostBody = body;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setValidateBeforeCall(String virtualInstanceId, UpdateVirtualInstanceRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling set(Async)");
        }
        if (body == null) {
            throw new Exception("Missing the required parameter 'body' when calling set(Async)");
        }
        Call call = this.setCall(virtualInstanceId, body, progressListener, progressRequestListener);
        return call;
    }

    public UpdateVirtualInstanceResponse set(String virtualInstanceId, UpdateVirtualInstanceRequest body) throws Exception {
        ApiResponse<UpdateVirtualInstanceResponse> resp = this.setWithHttpInfo(virtualInstanceId, body);
        return resp.getData();
    }

    public ApiResponse<UpdateVirtualInstanceResponse> setWithHttpInfo(String virtualInstanceId, UpdateVirtualInstanceRequest body) throws Exception {
        Call call = this.setValidateBeforeCall(virtualInstanceId, body, null, null);
        Type localVarReturnType = new TypeToken<UpdateVirtualInstanceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setAsync(String virtualInstanceId, UpdateVirtualInstanceRequest body, final ApiCallback<UpdateVirtualInstanceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setValidateBeforeCall(virtualInstanceId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdateVirtualInstanceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call suspendCall(String virtualInstanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}/suspend".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call suspendValidateBeforeCall(String virtualInstanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling suspend(Async)");
        }
        Call call = this.suspendCall(virtualInstanceId, progressListener, progressRequestListener);
        return call;
    }

    public SuspendVirtualInstanceResponse suspend(String virtualInstanceId) throws Exception {
        ApiResponse<SuspendVirtualInstanceResponse> resp = this.suspendWithHttpInfo(virtualInstanceId);
        return resp.getData();
    }

    public ApiResponse<SuspendVirtualInstanceResponse> suspendWithHttpInfo(String virtualInstanceId) throws Exception {
        Call call = this.suspendValidateBeforeCall(virtualInstanceId, null, null);
        Type localVarReturnType = new TypeToken<SuspendVirtualInstanceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call suspendAsync(String virtualInstanceId, final ApiCallback<SuspendVirtualInstanceResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.suspendValidateBeforeCall(virtualInstanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SuspendVirtualInstanceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call unmountCall(String virtualInstanceId, String collectionPath, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        Object localVarPostBody = null;
        String localVarPath = "/v1/orgs/self/virtualinstances/{virtualInstanceId}/mounts/{collectionPath}".replaceAll("\\{virtualInstanceId\\}", this.apiClient.escapeString(virtualInstanceId.toString())).replaceAll("\\{collectionPath\\}", this.apiClient.escapeString(collectionPath.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            }).build());
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call unmountValidateBeforeCall(String virtualInstanceId, String collectionPath, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws Exception {
        if (virtualInstanceId == null) {
            throw new Exception("Missing the required parameter 'virtualInstanceId' when calling unmount(Async)");
        }
        if (collectionPath == null) {
            throw new Exception("Missing the required parameter 'collectionPath' when calling unmount(Async)");
        }
        Call call = this.unmountCall(virtualInstanceId, collectionPath, progressListener, progressRequestListener);
        return call;
    }

    public CollectionMountResponse unmount(String virtualInstanceId, String collectionPath) throws Exception {
        ApiResponse<CollectionMountResponse> resp = this.unmountWithHttpInfo(virtualInstanceId, collectionPath);
        return resp.getData();
    }

    public ApiResponse<CollectionMountResponse> unmountWithHttpInfo(String virtualInstanceId, String collectionPath) throws Exception {
        Call call = this.unmountValidateBeforeCall(virtualInstanceId, collectionPath, null, null);
        Type localVarReturnType = new TypeToken<CollectionMountResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call unmountAsync(String virtualInstanceId, String collectionPath, final ApiCallback<CollectionMountResponse> callback) throws Exception {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.unmountValidateBeforeCall(virtualInstanceId, collectionPath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CollectionMountResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

