/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Alias {
    @SerializedName(value="collections")
    private List<String> collections = null;
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="created_by_apikey_name")
    private String createdByApikeyName = null;
    @SerializedName(value="creator_email")
    private String creatorEmail = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="modified_at")
    private String modifiedAt = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="workspace")
    private String workspace = null;

    public Alias collections(List<String> collections) {
        this.collections = collections;
        return this;
    }

    public Alias addCollectionsItem(String collectionsItem) {
        if (this.collections == null) {
            this.collections = new ArrayList<String>();
        }
        this.collections.add(collectionsItem);
        return this;
    }

    @JsonProperty(value="collections")
    @ApiModelProperty(example="\"[\\\"commons.foo\\\", \\\"prod.demo\\\"]\"", value="List of fully qualified collection names referenced by alias.")
    public List<String> getCollections() {
        return this.collections;
    }

    public void setCollections(List<String> collections) {
        this.collections = collections;
    }

    public Alias createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Alias createdByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
        return this;
    }

    @JsonProperty(value="created_by_apikey_name")
    @ApiModelProperty(value="Name of the API key that was used to create this object if one was used.")
    public String getCreatedByApikeyName() {
        return this.createdByApikeyName;
    }

    public void setCreatedByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
    }

    public Alias creatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
        return this;
    }

    @JsonProperty(value="creator_email")
    @ApiModelProperty(example="xyz@rockset.com", value="Email of the creator.")
    public String getCreatorEmail() {
        return this.creatorEmail;
    }

    public void setCreatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
    }

    public Alias description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="alias referencing collection in workspace", value="Alias description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Alias modifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @JsonProperty(value="modified_at")
    @ApiModelProperty(example="2001-08-28T00:23:42Z", value="ISO-8601 date.")
    public String getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public Alias name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="demo", value="Name of the alias.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Alias state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="CREATED", value="State of the alias.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Alias workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @JsonProperty(value="workspace")
    @ApiModelProperty(example="commons", value="Name of the workspace.")
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alias alias = (Alias)o;
        return Objects.equals(this.collections, alias.collections) && Objects.equals(this.createdAt, alias.createdAt) && Objects.equals(this.createdByApikeyName, alias.createdByApikeyName) && Objects.equals(this.creatorEmail, alias.creatorEmail) && Objects.equals(this.description, alias.description) && Objects.equals(this.modifiedAt, alias.modifiedAt) && Objects.equals(this.name, alias.name) && Objects.equals((Object)this.state, (Object)alias.state) && Objects.equals(this.workspace, alias.workspace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.collections, this.createdAt, this.createdByApikeyName, this.creatorEmail, this.description, this.modifiedAt, this.name, this.state, this.workspace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Alias {\n");
        sb.append("    collections: ").append(this.toIndentedString(this.collections)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdByApikeyName: ").append(this.toIndentedString(this.createdByApikeyName)).append("\n");
        sb.append("    creatorEmail: ").append(this.toIndentedString(this.creatorEmail)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        CREATED("CREATED"),
        DELETED("DELETED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

