/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="API keys are used to authenticate requests to Rockset's API. An API key is tied to the user who creates it.")
public class ApiKey {
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="created_by")
    private String createdBy = null;
    @SerializedName(value="created_by_apikey_name")
    private String createdByApikeyName = null;
    @SerializedName(value="expiry_time")
    private String expiryTime = null;
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="last_access_time")
    private String lastAccessTime = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="role")
    private String role = null;
    @SerializedName(value="state")
    private StateEnum state = null;

    public ApiKey createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="Date that API key was created (ISO-8601 format).")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public ApiKey createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="created_by")
    @ApiModelProperty(example="test@rockset.com", value="Email of API key owner.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public ApiKey createdByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
        return this;
    }

    @JsonProperty(value="created_by_apikey_name")
    @ApiModelProperty(value="Name of the API key that was used to create this object if one was used.")
    public String getCreatedByApikeyName() {
        return this.createdByApikeyName;
    }

    public void setCreatedByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
    }

    public ApiKey expiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    @JsonProperty(value="expiry_time")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="The expiration date of this API key.")
    public String getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
    }

    public ApiKey key(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty(value="key")
    @ApiModelProperty(example="aB35kD", required=true, value="This field will only be populated with the full key when creating an API key. Otherwise, it will be an API key identifier of 6 characters.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ApiKey lastAccessTime(String lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    @JsonProperty(value="last_access_time")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="Date that API key was most recently used (ISO-8601 format).")
    public String getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(String lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public ApiKey name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="my-key", required=true, value="Name of the API key.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiKey role(String role) {
        this.role = role;
        return this;
    }

    @JsonProperty(value="role")
    @ApiModelProperty(example="read-only", value="Role specifying access control. If not specified, API key will have access to all of the associated user's roles.")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public ApiKey state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="ACTIVE", value="Current state of this key.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKey apiKey = (ApiKey)o;
        return Objects.equals(this.createdAt, apiKey.createdAt) && Objects.equals(this.createdBy, apiKey.createdBy) && Objects.equals(this.createdByApikeyName, apiKey.createdByApikeyName) && Objects.equals(this.expiryTime, apiKey.expiryTime) && Objects.equals(this.key, apiKey.key) && Objects.equals(this.lastAccessTime, apiKey.lastAccessTime) && Objects.equals(this.name, apiKey.name) && Objects.equals(this.role, apiKey.role) && Objects.equals((Object)this.state, (Object)apiKey.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.createdBy, this.createdByApikeyName, this.expiryTime, this.key, this.lastAccessTime, this.name, this.role, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiKey {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdByApikeyName: ").append(this.toIndentedString(this.createdByApikeyName)).append("\n");
        sb.append("    expiryTime: ").append(this.toIndentedString(this.expiryTime)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    lastAccessTime: ").append(this.toIndentedString(this.lastAccessTime)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACTIVE("ACTIVE"),
        SUSPENDED("SUSPENDED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

