/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class AsyncQueryOptions {
    @SerializedName(value="client_timeout_ms")
    private Long clientTimeoutMs = null;
    @SerializedName(value="max_initial_results")
    private Long maxInitialResults = null;
    @SerializedName(value="timeout_ms")
    private Long timeoutMs = null;

    public AsyncQueryOptions clientTimeoutMs(Long clientTimeoutMs) {
        this.clientTimeoutMs = clientTimeoutMs;
        return this;
    }

    @JsonProperty(value="client_timeout_ms")
    @ApiModelProperty(value="If the query completes before the client timeout, the results are returned. Otherwise if the client timeout is exceeded, the query id will be returned, and the query will continue to run in the background for up to 30 minutes. (The 30 minute timeout can be configured lower with timeout_ms.) `async_options.client_timeout_ms` only applies when `async` is true. The default value of `client_timeout_ms` is 0, so async query requests will immediately return with a query id by default. ")
    public Long getClientTimeoutMs() {
        return this.clientTimeoutMs;
    }

    public void setClientTimeoutMs(Long clientTimeoutMs) {
        this.clientTimeoutMs = clientTimeoutMs;
    }

    public AsyncQueryOptions maxInitialResults(Long maxInitialResults) {
        this.maxInitialResults = maxInitialResults;
        return this;
    }

    @JsonProperty(value="max_initial_results")
    @ApiModelProperty(value="[DEPRECATED] Use the query request `max_initial_results` instead. The maximum number of results you will receive as a client. If the query exceeds this limit, the remaining results can be requested using a returned pagination cursor. In addition, there is a maximum response size of 100MiB so fewer than `max_results` may be returned.")
    public Long getMaxInitialResults() {
        return this.maxInitialResults;
    }

    public void setMaxInitialResults(Long maxInitialResults) {
        this.maxInitialResults = maxInitialResults;
    }

    public AsyncQueryOptions timeoutMs(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    @JsonProperty(value="timeout_ms")
    @ApiModelProperty(value="[DEPRECATED] Use the query request `timeout_ms` instead. The maximum amount of time that the system will attempt to complete query execution before aborting the query and returning an error. This must be set to a value that is greater than or equal to the client timeout, and the maximum value of this timeout is 30 minutes.")
    public Long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setTimeoutMs(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncQueryOptions asyncQueryOptions = (AsyncQueryOptions)o;
        return Objects.equals(this.clientTimeoutMs, asyncQueryOptions.clientTimeoutMs) && Objects.equals(this.maxInitialResults, asyncQueryOptions.maxInitialResults) && Objects.equals(this.timeoutMs, asyncQueryOptions.timeoutMs);
    }

    public int hashCode() {
        return Objects.hash(this.clientTimeoutMs, this.maxInitialResults, this.timeoutMs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AsyncQueryOptions {\n");
        sb.append("    clientTimeoutMs: ").append(this.toIndentedString(this.clientTimeoutMs)).append("\n");
        sb.append("    maxInitialResults: ").append(this.toIndentedString(this.maxInitialResults)).append("\n");
        sb.append("    timeoutMs: ").append(this.toIndentedString(this.timeoutMs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

