/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class AutoScalingPolicy {
    @SerializedName(value="enabled")
    private Boolean enabled = null;
    @SerializedName(value="max_size")
    private MaxSizeEnum maxSize = null;
    @SerializedName(value="min_size")
    private MinSizeEnum minSize = null;

    public AutoScalingPolicy enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="enabled")
    @ApiModelProperty(example="true", value="Whether auto scaling policy is enabled.")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AutoScalingPolicy maxSize(MaxSizeEnum maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @JsonProperty(value="max_size")
    @ApiModelProperty(example="XLARGE2", value="Maximum size Rockset can auto scale the Virtual Instance to. This value should be one of the dedicated sizes greater than or same as the min_size and lower than or same as the current size.")
    public MaxSizeEnum getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(MaxSizeEnum maxSize) {
        this.maxSize = maxSize;
    }

    public AutoScalingPolicy minSize(MinSizeEnum minSize) {
        this.minSize = minSize;
        return this;
    }

    @JsonProperty(value="min_size")
    @ApiModelProperty(example="LARGE", value="Minimum size Rockset can auto scale the Virtual Instance to. This value should be one of the dedicated sizes lower than or same as the max_size and greater than or same as the current size.")
    public MinSizeEnum getMinSize() {
        return this.minSize;
    }

    public void setMinSize(MinSizeEnum minSize) {
        this.minSize = minSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoScalingPolicy autoScalingPolicy = (AutoScalingPolicy)o;
        return Objects.equals(this.enabled, autoScalingPolicy.enabled) && Objects.equals((Object)this.maxSize, (Object)autoScalingPolicy.maxSize) && Objects.equals((Object)this.minSize, (Object)autoScalingPolicy.minSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.maxSize, this.minSize});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoScalingPolicy {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    maxSize: ").append(this.toIndentedString((Object)this.maxSize)).append("\n");
        sb.append("    minSize: ").append(this.toIndentedString((Object)this.minSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MinSizeEnum {
        FREE("FREE"),
        NANO("NANO"),
        SHARED("SHARED"),
        MILLI("MILLI"),
        XSMALL("XSMALL"),
        SMALL("SMALL"),
        MEDIUM("MEDIUM"),
        LARGE("LARGE"),
        XLARGE("XLARGE"),
        XLARGE2("XLARGE2"),
        XLARGE4("XLARGE4"),
        XLARGE8("XLARGE8"),
        XLARGE16("XLARGE16");

        private String value;

        private MinSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MinSizeEnum fromValue(String text) {
            for (MinSizeEnum b : MinSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MinSizeEnum> {
            public void write(JsonWriter jsonWriter, MinSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MinSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MinSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MaxSizeEnum {
        FREE("FREE"),
        NANO("NANO"),
        SHARED("SHARED"),
        MILLI("MILLI"),
        XSMALL("XSMALL"),
        SMALL("SMALL"),
        MEDIUM("MEDIUM"),
        LARGE("LARGE"),
        XLARGE("XLARGE"),
        XLARGE2("XLARGE2"),
        XLARGE4("XLARGE4"),
        XLARGE8("XLARGE8"),
        XLARGE16("XLARGE16");

        private String value;

        private MaxSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MaxSizeEnum fromValue(String text) {
            for (MaxSizeEnum b : MaxSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MaxSizeEnum> {
            public void write(JsonWriter jsonWriter, MaxSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MaxSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MaxSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

