/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class BulkStats {
    @SerializedName(value="data_downloaded_bytes")
    private Long dataDownloadedBytes = null;
    @SerializedName(value="data_indexed_bytes")
    private Long dataIndexedBytes = null;
    @SerializedName(value="data_indexed_throughput_bytes")
    private Double dataIndexedThroughputBytes = null;
    @SerializedName(value="documents_downloaded")
    private Long documentsDownloaded = null;
    @SerializedName(value="download_compute_ms")
    private Long downloadComputeMs = null;
    @SerializedName(value="downloading_stage_done_at")
    private String downloadingStageDoneAt = null;
    @SerializedName(value="finalizing_stage_done_at")
    private String finalizingStageDoneAt = null;
    @SerializedName(value="index_compute_ms")
    private Long indexComputeMs = null;
    @SerializedName(value="indexing_stage_done_at")
    private String indexingStageDoneAt = null;
    @SerializedName(value="initializing_stage_done_at")
    private String initializingStageDoneAt = null;
    @SerializedName(value="pre_index_size_bytes")
    private Long preIndexSizeBytes = null;
    @SerializedName(value="provisioning_stage_done_at")
    private String provisioningStageDoneAt = null;
    @SerializedName(value="started_at")
    private String startedAt = null;
    @SerializedName(value="total_index_size_bytes")
    private Long totalIndexSizeBytes = null;
    @SerializedName(value="transformation_compute_ms")
    private Long transformationComputeMs = null;

    public BulkStats dataDownloadedBytes(Long dataDownloadedBytes) {
        this.dataDownloadedBytes = dataDownloadedBytes;
        return this;
    }

    @JsonProperty(value="data_downloaded_bytes")
    @ApiModelProperty(example="10000000", value="Size in bytes of documents downloaded from source during an ongoing or completed bulk ingest. This includes documents that are dropped and reingested.")
    public Long getDataDownloadedBytes() {
        return this.dataDownloadedBytes;
    }

    public void setDataDownloadedBytes(Long dataDownloadedBytes) {
        this.dataDownloadedBytes = dataDownloadedBytes;
    }

    public BulkStats dataIndexedBytes(Long dataIndexedBytes) {
        this.dataIndexedBytes = dataIndexedBytes;
        return this;
    }

    @JsonProperty(value="data_indexed_bytes")
    @ApiModelProperty(example="8000000", value="Size in bytes of documents indexed. This is the total size of documents after transformations and dropping before indexes are built.")
    public Long getDataIndexedBytes() {
        return this.dataIndexedBytes;
    }

    public void setDataIndexedBytes(Long dataIndexedBytes) {
        this.dataIndexedBytes = dataIndexedBytes;
    }

    public BulkStats dataIndexedThroughputBytes(Double dataIndexedThroughputBytes) {
        this.dataIndexedThroughputBytes = dataIndexedThroughputBytes;
        return this;
    }

    @JsonProperty(value="data_indexed_throughput_bytes")
    @ApiModelProperty(example="800000.5", value="Throughput of documents indexed in the last minute measured in bytes/s. This is based off the data_indexed_bytes size. Throughput during the download stage is shown on a per-source granularity in the sources field of the Collection response.")
    public Double getDataIndexedThroughputBytes() {
        return this.dataIndexedThroughputBytes;
    }

    public void setDataIndexedThroughputBytes(Double dataIndexedThroughputBytes) {
        this.dataIndexedThroughputBytes = dataIndexedThroughputBytes;
    }

    public BulkStats documentsDownloaded(Long documentsDownloaded) {
        this.documentsDownloaded = documentsDownloaded;
        return this;
    }

    @JsonProperty(value="documents_downloaded")
    @ApiModelProperty(example="10000", value="Number of documents downloaded from source during an ongoing or completed bulk ingest. This includes documents that are dropped and reingested.")
    public Long getDocumentsDownloaded() {
        return this.documentsDownloaded;
    }

    public void setDocumentsDownloaded(Long documentsDownloaded) {
        this.documentsDownloaded = documentsDownloaded;
    }

    public BulkStats downloadComputeMs(Long downloadComputeMs) {
        this.downloadComputeMs = downloadComputeMs;
        return this;
    }

    @JsonProperty(value="download_compute_ms")
    @ApiModelProperty(example="50000", value="Bulk ingest compute units in milliseconds used for downloading documents.")
    public Long getDownloadComputeMs() {
        return this.downloadComputeMs;
    }

    public void setDownloadComputeMs(Long downloadComputeMs) {
        this.downloadComputeMs = downloadComputeMs;
    }

    public BulkStats downloadingStageDoneAt(String downloadingStageDoneAt) {
        this.downloadingStageDoneAt = downloadingStageDoneAt;
        return this;
    }

    @JsonProperty(value="downloading_stage_done_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when the downloading stage was completed.")
    public String getDownloadingStageDoneAt() {
        return this.downloadingStageDoneAt;
    }

    public void setDownloadingStageDoneAt(String downloadingStageDoneAt) {
        this.downloadingStageDoneAt = downloadingStageDoneAt;
    }

    public BulkStats finalizingStageDoneAt(String finalizingStageDoneAt) {
        this.finalizingStageDoneAt = finalizingStageDoneAt;
        return this;
    }

    @JsonProperty(value="finalizing_stage_done_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when the finalizing stage was completed.")
    public String getFinalizingStageDoneAt() {
        return this.finalizingStageDoneAt;
    }

    public void setFinalizingStageDoneAt(String finalizingStageDoneAt) {
        this.finalizingStageDoneAt = finalizingStageDoneAt;
    }

    public BulkStats indexComputeMs(Long indexComputeMs) {
        this.indexComputeMs = indexComputeMs;
        return this;
    }

    @JsonProperty(value="index_compute_ms")
    @ApiModelProperty(example="100000", value="Bulk ingest compute units in milliseconds used for indexing documents.")
    public Long getIndexComputeMs() {
        return this.indexComputeMs;
    }

    public void setIndexComputeMs(Long indexComputeMs) {
        this.indexComputeMs = indexComputeMs;
    }

    public BulkStats indexingStageDoneAt(String indexingStageDoneAt) {
        this.indexingStageDoneAt = indexingStageDoneAt;
        return this;
    }

    @JsonProperty(value="indexing_stage_done_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when the indexing stage was completed.")
    public String getIndexingStageDoneAt() {
        return this.indexingStageDoneAt;
    }

    public void setIndexingStageDoneAt(String indexingStageDoneAt) {
        this.indexingStageDoneAt = indexingStageDoneAt;
    }

    public BulkStats initializingStageDoneAt(String initializingStageDoneAt) {
        this.initializingStageDoneAt = initializingStageDoneAt;
        return this;
    }

    @JsonProperty(value="initializing_stage_done_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when the initializing stage was completed.")
    public String getInitializingStageDoneAt() {
        return this.initializingStageDoneAt;
    }

    public void setInitializingStageDoneAt(String initializingStageDoneAt) {
        this.initializingStageDoneAt = initializingStageDoneAt;
    }

    public BulkStats preIndexSizeBytes(Long preIndexSizeBytes) {
        this.preIndexSizeBytes = preIndexSizeBytes;
        return this;
    }

    @JsonProperty(value="pre_index_size_bytes")
    @ApiModelProperty(example="8000000", value="Size in bytes of documents before being indexed. This is the total size of documents after decompression, transformations, and dropping. This is equal to data_indexed_bytes after the indexing stage is done unless there are retries during indexing the data.")
    public Long getPreIndexSizeBytes() {
        return this.preIndexSizeBytes;
    }

    public void setPreIndexSizeBytes(Long preIndexSizeBytes) {
        this.preIndexSizeBytes = preIndexSizeBytes;
    }

    public BulkStats provisioningStageDoneAt(String provisioningStageDoneAt) {
        this.provisioningStageDoneAt = provisioningStageDoneAt;
        return this;
    }

    @JsonProperty(value="provisioning_stage_done_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when the provisioning stage was completed.")
    public String getProvisioningStageDoneAt() {
        return this.provisioningStageDoneAt;
    }

    public void setProvisioningStageDoneAt(String provisioningStageDoneAt) {
        this.provisioningStageDoneAt = provisioningStageDoneAt;
    }

    public BulkStats startedAt(String startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @JsonProperty(value="started_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when the bulk ingest was started.")
    public String getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(String startedAt) {
        this.startedAt = startedAt;
    }

    public BulkStats totalIndexSizeBytes(Long totalIndexSizeBytes) {
        this.totalIndexSizeBytes = totalIndexSizeBytes;
        return this;
    }

    @JsonProperty(value="total_index_size_bytes")
    @ApiModelProperty(example="10000000", value="Total size of indexes after the completed bulk ingest. This is the same as collection size.")
    public Long getTotalIndexSizeBytes() {
        return this.totalIndexSizeBytes;
    }

    public void setTotalIndexSizeBytes(Long totalIndexSizeBytes) {
        this.totalIndexSizeBytes = totalIndexSizeBytes;
    }

    public BulkStats transformationComputeMs(Long transformationComputeMs) {
        this.transformationComputeMs = transformationComputeMs;
        return this;
    }

    @JsonProperty(value="transformation_compute_ms")
    @ApiModelProperty(example="50000", value="Bulk ingest compute units in milliseconds used for ingest transformation.")
    public Long getTransformationComputeMs() {
        return this.transformationComputeMs;
    }

    public void setTransformationComputeMs(Long transformationComputeMs) {
        this.transformationComputeMs = transformationComputeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkStats bulkStats = (BulkStats)o;
        return Objects.equals(this.dataDownloadedBytes, bulkStats.dataDownloadedBytes) && Objects.equals(this.dataIndexedBytes, bulkStats.dataIndexedBytes) && Objects.equals(this.dataIndexedThroughputBytes, bulkStats.dataIndexedThroughputBytes) && Objects.equals(this.documentsDownloaded, bulkStats.documentsDownloaded) && Objects.equals(this.downloadComputeMs, bulkStats.downloadComputeMs) && Objects.equals(this.downloadingStageDoneAt, bulkStats.downloadingStageDoneAt) && Objects.equals(this.finalizingStageDoneAt, bulkStats.finalizingStageDoneAt) && Objects.equals(this.indexComputeMs, bulkStats.indexComputeMs) && Objects.equals(this.indexingStageDoneAt, bulkStats.indexingStageDoneAt) && Objects.equals(this.initializingStageDoneAt, bulkStats.initializingStageDoneAt) && Objects.equals(this.preIndexSizeBytes, bulkStats.preIndexSizeBytes) && Objects.equals(this.provisioningStageDoneAt, bulkStats.provisioningStageDoneAt) && Objects.equals(this.startedAt, bulkStats.startedAt) && Objects.equals(this.totalIndexSizeBytes, bulkStats.totalIndexSizeBytes) && Objects.equals(this.transformationComputeMs, bulkStats.transformationComputeMs);
    }

    public int hashCode() {
        return Objects.hash(this.dataDownloadedBytes, this.dataIndexedBytes, this.dataIndexedThroughputBytes, this.documentsDownloaded, this.downloadComputeMs, this.downloadingStageDoneAt, this.finalizingStageDoneAt, this.indexComputeMs, this.indexingStageDoneAt, this.initializingStageDoneAt, this.preIndexSizeBytes, this.provisioningStageDoneAt, this.startedAt, this.totalIndexSizeBytes, this.transformationComputeMs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkStats {\n");
        sb.append("    dataDownloadedBytes: ").append(this.toIndentedString(this.dataDownloadedBytes)).append("\n");
        sb.append("    dataIndexedBytes: ").append(this.toIndentedString(this.dataIndexedBytes)).append("\n");
        sb.append("    dataIndexedThroughputBytes: ").append(this.toIndentedString(this.dataIndexedThroughputBytes)).append("\n");
        sb.append("    documentsDownloaded: ").append(this.toIndentedString(this.documentsDownloaded)).append("\n");
        sb.append("    downloadComputeMs: ").append(this.toIndentedString(this.downloadComputeMs)).append("\n");
        sb.append("    downloadingStageDoneAt: ").append(this.toIndentedString(this.downloadingStageDoneAt)).append("\n");
        sb.append("    finalizingStageDoneAt: ").append(this.toIndentedString(this.finalizingStageDoneAt)).append("\n");
        sb.append("    indexComputeMs: ").append(this.toIndentedString(this.indexComputeMs)).append("\n");
        sb.append("    indexingStageDoneAt: ").append(this.toIndentedString(this.indexingStageDoneAt)).append("\n");
        sb.append("    initializingStageDoneAt: ").append(this.toIndentedString(this.initializingStageDoneAt)).append("\n");
        sb.append("    preIndexSizeBytes: ").append(this.toIndentedString(this.preIndexSizeBytes)).append("\n");
        sb.append("    provisioningStageDoneAt: ").append(this.toIndentedString(this.provisioningStageDoneAt)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    totalIndexSizeBytes: ").append(this.toIndentedString(this.totalIndexSizeBytes)).append("\n");
        sb.append("    transformationComputeMs: ").append(this.toIndentedString(this.transformationComputeMs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

