/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class Cluster {
    @SerializedName(value="apiserver_url")
    private String apiserverUrl = null;
    @SerializedName(value="aws_region")
    private String awsRegion = null;
    @SerializedName(value="cluster_type")
    private ClusterTypeEnum clusterType = null;
    @SerializedName(value="domain")
    private String domain = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="top_level_domain")
    private String topLevelDomain = null;

    public Cluster apiserverUrl(String apiserverUrl) {
        this.apiserverUrl = apiserverUrl;
        return this;
    }

    @JsonProperty(value="apiserver_url")
    @ApiModelProperty(example="api.rockset.us-west-2.rockset.com", value="Api server url for cluster.")
    public String getApiserverUrl() {
        return this.apiserverUrl;
    }

    public void setApiserverUrl(String apiserverUrl) {
        this.apiserverUrl = apiserverUrl;
    }

    public Cluster awsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    @JsonProperty(value="aws_region")
    @ApiModelProperty(example="us-west-2", value="Aws region.")
    public String getAwsRegion() {
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public Cluster clusterType(ClusterTypeEnum clusterType) {
        this.clusterType = clusterType;
        return this;
    }

    @JsonProperty(value="cluster_type")
    @ApiModelProperty(example="PRIVATE", value="Cluster type.")
    public ClusterTypeEnum getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(ClusterTypeEnum clusterType) {
        this.clusterType = clusterType;
    }

    public Cluster domain(String domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty(value="domain")
    @ApiModelProperty(example="rockset", value="Domain of org using cluster.")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Cluster id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @ApiModelProperty(example="asdf98-as9df8adf-adsf9asfd", value="Unique identifier for the cluster.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Cluster topLevelDomain(String topLevelDomain) {
        this.topLevelDomain = topLevelDomain;
        return this;
    }

    @JsonProperty(value="top_level_domain")
    @ApiModelProperty(example=".com", value="Top level domain of org using cluster.")
    public String getTopLevelDomain() {
        return this.topLevelDomain;
    }

    public void setTopLevelDomain(String topLevelDomain) {
        this.topLevelDomain = topLevelDomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        return Objects.equals(this.apiserverUrl, cluster.apiserverUrl) && Objects.equals(this.awsRegion, cluster.awsRegion) && Objects.equals((Object)this.clusterType, (Object)cluster.clusterType) && Objects.equals(this.domain, cluster.domain) && Objects.equals(this.id, cluster.id) && Objects.equals(this.topLevelDomain, cluster.topLevelDomain);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiserverUrl, this.awsRegion, this.clusterType, this.domain, this.id, this.topLevelDomain});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Cluster {\n");
        sb.append("    apiserverUrl: ").append(this.toIndentedString(this.apiserverUrl)).append("\n");
        sb.append("    awsRegion: ").append(this.toIndentedString(this.awsRegion)).append("\n");
        sb.append("    clusterType: ").append(this.toIndentedString((Object)this.clusterType)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    topLevelDomain: ").append(this.toIndentedString(this.topLevelDomain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ClusterTypeEnum {
        PUBLIC("PUBLIC");

        private String value;

        private ClusterTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClusterTypeEnum fromValue(String text) {
            for (ClusterTypeEnum b : ClusterTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ClusterTypeEnum> {
            public void write(JsonWriter jsonWriter, ClusterTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ClusterTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ClusterTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

