/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.Alias;
import com.rockset.client.model.BulkStats;
import com.rockset.client.model.CollectionStats;
import com.rockset.client.model.FieldMappingQuery;
import com.rockset.client.model.FieldMappingV2;
import com.rockset.client.model.FieldPartition;
import com.rockset.client.model.Source;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Collection {
    @SerializedName(value="aliases")
    private List<Alias> aliases = null;
    @SerializedName(value="bulk_stats")
    private List<BulkStats> bulkStats = null;
    @SerializedName(value="clustering_key")
    private List<FieldPartition> clusteringKey = null;
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="created_by")
    private String createdBy = null;
    @SerializedName(value="created_by_apikey_name")
    private String createdByApikeyName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="field_mapping_query")
    private FieldMappingQuery fieldMappingQuery = null;
    @SerializedName(value="field_mappings")
    private List<FieldMappingV2> fieldMappings = null;
    @SerializedName(value="insert_only")
    private Boolean insertOnly = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="read_only")
    private Boolean readOnly = null;
    @SerializedName(value="retention_secs")
    private Long retentionSecs = null;
    @SerializedName(value="rrn")
    private String rrn = null;
    @SerializedName(value="sources")
    private List<Source> sources = null;
    @SerializedName(value="stats")
    private CollectionStats stats = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="storage_compression_type")
    private StorageCompressionTypeEnum storageCompressionType = null;
    @SerializedName(value="workspace")
    private String workspace = null;

    public Collection aliases(List<Alias> aliases) {
        this.aliases = aliases;
        return this;
    }

    public Collection addAliasesItem(Alias aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<Alias>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    @JsonProperty(value="aliases")
    @ApiModelProperty(value="List of aliases for a collection.")
    public List<Alias> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<Alias> aliases) {
        this.aliases = aliases;
    }

    public Collection bulkStats(List<BulkStats> bulkStats) {
        this.bulkStats = bulkStats;
        return this;
    }

    public Collection addBulkStatsItem(BulkStats bulkStatsItem) {
        if (this.bulkStats == null) {
            this.bulkStats = new ArrayList<BulkStats>();
        }
        this.bulkStats.add(bulkStatsItem);
        return this;
    }

    @JsonProperty(value="bulk_stats")
    @ApiModelProperty(value="")
    public List<BulkStats> getBulkStats() {
        return this.bulkStats;
    }

    public void setBulkStats(List<BulkStats> bulkStats) {
        this.bulkStats = bulkStats;
    }

    public Collection clusteringKey(List<FieldPartition> clusteringKey) {
        this.clusteringKey = clusteringKey;
        return this;
    }

    public Collection addClusteringKeyItem(FieldPartition clusteringKeyItem) {
        if (this.clusteringKey == null) {
            this.clusteringKey = new ArrayList<FieldPartition>();
        }
        this.clusteringKey.add(clusteringKeyItem);
        return this;
    }

    @JsonProperty(value="clustering_key")
    @ApiModelProperty(value="List of clustering fields for a collection.")
    public List<FieldPartition> getClusteringKey() {
        return this.clusteringKey;
    }

    public void setClusteringKey(List<FieldPartition> clusteringKey) {
        this.clusteringKey = clusteringKey;
    }

    public Collection createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Collection createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="created_by")
    @ApiModelProperty(example="hello@rockset.com", value="Email of user who created the collection.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Collection createdByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
        return this;
    }

    @JsonProperty(value="created_by_apikey_name")
    @ApiModelProperty(value="Name of the API key that was used to create this collection if one was used.")
    public String getCreatedByApikeyName() {
        return this.createdByApikeyName;
    }

    public void setCreatedByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
    }

    public Collection description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="transactions from stores worldwide", value="Text describing the collection.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection fieldMappingQuery(FieldMappingQuery fieldMappingQuery) {
        this.fieldMappingQuery = fieldMappingQuery;
        return this;
    }

    @JsonProperty(value="field_mapping_query")
    @ApiModelProperty(value="Field mapping for a collection.")
    public FieldMappingQuery getFieldMappingQuery() {
        return this.fieldMappingQuery;
    }

    public void setFieldMappingQuery(FieldMappingQuery fieldMappingQuery) {
        this.fieldMappingQuery = fieldMappingQuery;
    }

    public Collection fieldMappings(List<FieldMappingV2> fieldMappings) {
        this.fieldMappings = fieldMappings;
        return this;
    }

    public Collection addFieldMappingsItem(FieldMappingV2 fieldMappingsItem) {
        if (this.fieldMappings == null) {
            this.fieldMappings = new ArrayList<FieldMappingV2>();
        }
        this.fieldMappings.add(fieldMappingsItem);
        return this;
    }

    @JsonProperty(value="field_mappings")
    @ApiModelProperty(value="List of mappings applied on all documents in a collection.")
    public List<FieldMappingV2> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(List<FieldMappingV2> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public Collection insertOnly(Boolean insertOnly) {
        this.insertOnly = insertOnly;
        return this;
    }

    @JsonProperty(value="insert_only")
    @ApiModelProperty(value="Whether the collection is insert only or not.")
    public Boolean isInsertOnly() {
        return this.insertOnly;
    }

    public void setInsertOnly(Boolean insertOnly) {
        this.insertOnly = insertOnly;
    }

    public Collection name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="global-transactions", value="Unique identifer for collection, can contain alphanumeric or dash characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @JsonProperty(value="read_only")
    @ApiModelProperty(value="Whether the collection is read-only or not.")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Collection retentionSecs(Long retentionSecs) {
        this.retentionSecs = retentionSecs;
        return this;
    }

    @JsonProperty(value="retention_secs")
    @ApiModelProperty(example="2592000", value="Number of seconds after which data is purged based on event time.")
    public Long getRetentionSecs() {
        return this.retentionSecs;
    }

    public void setRetentionSecs(Long retentionSecs) {
        this.retentionSecs = retentionSecs;
    }

    public Collection rrn(String rrn) {
        this.rrn = rrn;
        return this;
    }

    @JsonProperty(value="rrn")
    @ApiModelProperty(example="rrn:col:use1a1:123e4567-e89b-12d3-a456-556642440000", value="Collection RRN.")
    public String getRrn() {
        return this.rrn;
    }

    public void setRrn(String rrn) {
        this.rrn = rrn;
    }

    public Collection sources(List<Source> sources) {
        this.sources = sources;
        return this;
    }

    public Collection addSourcesItem(Source sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<Source>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @JsonProperty(value="sources")
    @ApiModelProperty(value="List of sources from which collection ingests.")
    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public Collection stats(CollectionStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="stats")
    @ApiModelProperty(value="Metrics about the collection.")
    public CollectionStats getStats() {
        return this.stats;
    }

    public void setStats(CollectionStats stats) {
        this.stats = stats;
    }

    public Collection status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(example="READY", value="Current status of collection.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Collection storageCompressionType(StorageCompressionTypeEnum storageCompressionType) {
        this.storageCompressionType = storageCompressionType;
        return this;
    }

    @JsonProperty(value="storage_compression_type")
    @ApiModelProperty(value="RocksDB storage compression type.")
    public StorageCompressionTypeEnum getStorageCompressionType() {
        return this.storageCompressionType;
    }

    public void setStorageCompressionType(StorageCompressionTypeEnum storageCompressionType) {
        this.storageCompressionType = storageCompressionType;
    }

    public Collection workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @JsonProperty(value="workspace")
    @ApiModelProperty(example="commons", value="Name of the workspace that the collection is in.")
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collection collection = (Collection)o;
        return Objects.equals(this.aliases, collection.aliases) && Objects.equals(this.bulkStats, collection.bulkStats) && Objects.equals(this.clusteringKey, collection.clusteringKey) && Objects.equals(this.createdAt, collection.createdAt) && Objects.equals(this.createdBy, collection.createdBy) && Objects.equals(this.createdByApikeyName, collection.createdByApikeyName) && Objects.equals(this.description, collection.description) && Objects.equals(this.fieldMappingQuery, collection.fieldMappingQuery) && Objects.equals(this.fieldMappings, collection.fieldMappings) && Objects.equals(this.insertOnly, collection.insertOnly) && Objects.equals(this.name, collection.name) && Objects.equals(this.readOnly, collection.readOnly) && Objects.equals(this.retentionSecs, collection.retentionSecs) && Objects.equals(this.rrn, collection.rrn) && Objects.equals(this.sources, collection.sources) && Objects.equals(this.stats, collection.stats) && Objects.equals((Object)this.status, (Object)collection.status) && Objects.equals((Object)this.storageCompressionType, (Object)collection.storageCompressionType) && Objects.equals(this.workspace, collection.workspace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aliases, this.bulkStats, this.clusteringKey, this.createdAt, this.createdBy, this.createdByApikeyName, this.description, this.fieldMappingQuery, this.fieldMappings, this.insertOnly, this.name, this.readOnly, this.retentionSecs, this.rrn, this.sources, this.stats, this.status, this.storageCompressionType, this.workspace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Collection {\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    bulkStats: ").append(this.toIndentedString(this.bulkStats)).append("\n");
        sb.append("    clusteringKey: ").append(this.toIndentedString(this.clusteringKey)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdByApikeyName: ").append(this.toIndentedString(this.createdByApikeyName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fieldMappingQuery: ").append(this.toIndentedString(this.fieldMappingQuery)).append("\n");
        sb.append("    fieldMappings: ").append(this.toIndentedString(this.fieldMappings)).append("\n");
        sb.append("    insertOnly: ").append(this.toIndentedString(this.insertOnly)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    retentionSecs: ").append(this.toIndentedString(this.retentionSecs)).append("\n");
        sb.append("    rrn: ").append(this.toIndentedString(this.rrn)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    storageCompressionType: ").append(this.toIndentedString((Object)this.storageCompressionType)).append("\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StorageCompressionTypeEnum {
        LZ4("LZ4"),
        ZSTD("ZSTD"),
        UNKNOWN("UNKNOWN");

        private String value;

        private StorageCompressionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StorageCompressionTypeEnum fromValue(String text) {
            for (StorageCompressionTypeEnum b : StorageCompressionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StorageCompressionTypeEnum> {
            public void write(JsonWriter jsonWriter, StorageCompressionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StorageCompressionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StorageCompressionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        INITIALIZED("INITIALIZED"),
        CREATED("CREATED"),
        READY("READY"),
        PAUSED("PAUSED"),
        DELETED("DELETED"),
        PAUSING("PAUSING"),
        RESUMING("RESUMING"),
        PREPARING_BULK("PREPARINGBULK"),
        BULK_INGEST_MODE("BULKINGESTMODE"),
        EXITING_BULK_INGEST_MODE("EXITINGBULKINGESTMODE"),
        ENCRYPTION_KEY_ERROR("ENCRYPTIONKEYERROR"),
        UNKNOWN("UNKNOWN");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

