/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.CollectionMountStats;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class CollectionMount {
    @SerializedName(value="collection_path")
    private String collectionPath = null;
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="last_refresh_time_millis")
    private Long lastRefreshTimeMillis = null;
    @SerializedName(value="rrn")
    private String rrn = null;
    @SerializedName(value="snapshot_expiration_time_millis")
    private Long snapshotExpirationTimeMillis = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="stats")
    private CollectionMountStats stats = null;
    @SerializedName(value="virtual_instance_id")
    private String virtualInstanceId = null;
    @SerializedName(value="virtual_instance_rrn")
    private String virtualInstanceRrn = null;

    public CollectionMount collectionPath(String collectionPath) {
        this.collectionPath = collectionPath;
        return this;
    }

    @JsonProperty(value="collection_path")
    @ApiModelProperty(example="commons.foo", value="Collection path.")
    public String getCollectionPath() {
        return this.collectionPath;
    }

    public void setCollectionPath(String collectionPath) {
        this.collectionPath = collectionPath;
    }

    public CollectionMount createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public CollectionMount id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @ApiModelProperty(example="5ac23....", value="Mount ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CollectionMount lastRefreshTimeMillis(Long lastRefreshTimeMillis) {
        this.lastRefreshTimeMillis = lastRefreshTimeMillis;
        return this;
    }

    @JsonProperty(value="last_refresh_time_millis")
    @ApiModelProperty(example="123123764", value="Unix timestamp of most recent refresh. Not applicable for live mounts.")
    public Long getLastRefreshTimeMillis() {
        return this.lastRefreshTimeMillis;
    }

    public void setLastRefreshTimeMillis(Long lastRefreshTimeMillis) {
        this.lastRefreshTimeMillis = lastRefreshTimeMillis;
    }

    public CollectionMount rrn(String rrn) {
        this.rrn = rrn;
        return this;
    }

    @JsonProperty(value="rrn")
    @ApiModelProperty(example="rrn:mnt:use1a1:123e4567-e89b-12d3-a456-556642440000", value="Mount RRN.")
    public String getRrn() {
        return this.rrn;
    }

    public void setRrn(String rrn) {
        this.rrn = rrn;
    }

    public CollectionMount snapshotExpirationTimeMillis(Long snapshotExpirationTimeMillis) {
        this.snapshotExpirationTimeMillis = snapshotExpirationTimeMillis;
        return this;
    }

    @JsonProperty(value="snapshot_expiration_time_millis")
    @ApiModelProperty(example="864000000", value="Time in millis at which the snapshot expires.")
    public Long getSnapshotExpirationTimeMillis() {
        return this.snapshotExpirationTimeMillis;
    }

    public void setSnapshotExpirationTimeMillis(Long snapshotExpirationTimeMillis) {
        this.snapshotExpirationTimeMillis = snapshotExpirationTimeMillis;
    }

    public CollectionMount state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="ACTIVE", value="Mount type.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CollectionMount stats(CollectionMountStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="stats")
    @ApiModelProperty(value="Stats about this Collection Mount")
    public CollectionMountStats getStats() {
        return this.stats;
    }

    public void setStats(CollectionMountStats stats) {
        this.stats = stats;
    }

    public CollectionMount virtualInstanceId(String virtualInstanceId) {
        this.virtualInstanceId = virtualInstanceId;
        return this;
    }

    @JsonProperty(value="virtual_instance_id")
    @ApiModelProperty(example="5ac23....", value="Virtual instance ID.")
    public String getVirtualInstanceId() {
        return this.virtualInstanceId;
    }

    public void setVirtualInstanceId(String virtualInstanceId) {
        this.virtualInstanceId = virtualInstanceId;
    }

    public CollectionMount virtualInstanceRrn(String virtualInstanceRrn) {
        this.virtualInstanceRrn = virtualInstanceRrn;
        return this;
    }

    @JsonProperty(value="virtual_instance_rrn")
    @ApiModelProperty(example="rrn:vi:use1a1:123e4567-e89b-12d3-a456-556642440000", value="Virtual Instance RRN.")
    public String getVirtualInstanceRrn() {
        return this.virtualInstanceRrn;
    }

    public void setVirtualInstanceRrn(String virtualInstanceRrn) {
        this.virtualInstanceRrn = virtualInstanceRrn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionMount collectionMount = (CollectionMount)o;
        return Objects.equals(this.collectionPath, collectionMount.collectionPath) && Objects.equals(this.createdAt, collectionMount.createdAt) && Objects.equals(this.id, collectionMount.id) && Objects.equals(this.lastRefreshTimeMillis, collectionMount.lastRefreshTimeMillis) && Objects.equals(this.rrn, collectionMount.rrn) && Objects.equals(this.snapshotExpirationTimeMillis, collectionMount.snapshotExpirationTimeMillis) && Objects.equals((Object)this.state, (Object)collectionMount.state) && Objects.equals(this.stats, collectionMount.stats) && Objects.equals(this.virtualInstanceId, collectionMount.virtualInstanceId) && Objects.equals(this.virtualInstanceRrn, collectionMount.virtualInstanceRrn);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.collectionPath, this.createdAt, this.id, this.lastRefreshTimeMillis, this.rrn, this.snapshotExpirationTimeMillis, this.state, this.stats, this.virtualInstanceId, this.virtualInstanceRrn});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectionMount {\n");
        sb.append("    collectionPath: ").append(this.toIndentedString(this.collectionPath)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastRefreshTimeMillis: ").append(this.toIndentedString(this.lastRefreshTimeMillis)).append("\n");
        sb.append("    rrn: ").append(this.toIndentedString(this.rrn)).append("\n");
        sb.append("    snapshotExpirationTimeMillis: ").append(this.toIndentedString(this.snapshotExpirationTimeMillis)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("    virtualInstanceId: ").append(this.toIndentedString(this.virtualInstanceId)).append("\n");
        sb.append("    virtualInstanceRrn: ").append(this.toIndentedString(this.virtualInstanceRrn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        CREATING("CREATING"),
        ACTIVE("ACTIVE"),
        REFRESHING("REFRESHING"),
        EXPIRED("EXPIRED"),
        DELETING("DELETING"),
        SWITCHING_REFRESH_TYPE("SWITCHINGREFRESHTYPE"),
        SUSPENDED("SUSPENDED"),
        SUSPENDING("SUSPENDING");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

