/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class CollectionStats {
    @SerializedName(value="bulk_bytes_inserted")
    private Long bulkBytesInserted = null;
    @SerializedName(value="bulk_bytes_overwritten")
    private Long bulkBytesOverwritten = null;
    @SerializedName(value="bytes_inserted")
    private Long bytesInserted = null;
    @SerializedName(value="bytes_overwritten")
    private Long bytesOverwritten = null;
    @SerializedName(value="column_index_size")
    private Long columnIndexSize = null;
    @SerializedName(value="doc_count")
    private Long docCount = null;
    @SerializedName(value="fill_progress")
    private Double fillProgress = null;
    @SerializedName(value="inverted_index_size")
    private Long invertedIndexSize = null;
    @SerializedName(value="last_queried_ms")
    private Long lastQueriedMs = null;
    @SerializedName(value="last_updated_ms")
    private Long lastUpdatedMs = null;
    @SerializedName(value="purged_doc_count")
    private Long purgedDocCount = null;
    @SerializedName(value="purged_doc_size")
    private Long purgedDocSize = null;
    @SerializedName(value="range_index_size")
    private Long rangeIndexSize = null;
    @SerializedName(value="row_index_size")
    private Long rowIndexSize = null;
    @SerializedName(value="total_index_size")
    private Long totalIndexSize = null;
    @SerializedName(value="total_size")
    private Long totalSize = null;

    public CollectionStats bulkBytesInserted(Long bulkBytesInserted) {
        this.bulkBytesInserted = bulkBytesInserted;
        return this;
    }

    @JsonProperty(value="bulk_bytes_inserted")
    @ApiModelProperty(value="Total number of bytes inserted into the collection during bulk.")
    public Long getBulkBytesInserted() {
        return this.bulkBytesInserted;
    }

    public void setBulkBytesInserted(Long bulkBytesInserted) {
        this.bulkBytesInserted = bulkBytesInserted;
    }

    public CollectionStats bulkBytesOverwritten(Long bulkBytesOverwritten) {
        this.bulkBytesOverwritten = bulkBytesOverwritten;
        return this;
    }

    @JsonProperty(value="bulk_bytes_overwritten")
    @ApiModelProperty(value="Total number of bytes overwritten in writing into the collection during bulk.")
    public Long getBulkBytesOverwritten() {
        return this.bulkBytesOverwritten;
    }

    public void setBulkBytesOverwritten(Long bulkBytesOverwritten) {
        this.bulkBytesOverwritten = bulkBytesOverwritten;
    }

    public CollectionStats bytesInserted(Long bytesInserted) {
        this.bytesInserted = bytesInserted;
        return this;
    }

    @JsonProperty(value="bytes_inserted")
    @ApiModelProperty(example="123456", value="Total number of bytes inserted into the collection.")
    public Long getBytesInserted() {
        return this.bytesInserted;
    }

    public void setBytesInserted(Long bytesInserted) {
        this.bytesInserted = bytesInserted;
    }

    public CollectionStats bytesOverwritten(Long bytesOverwritten) {
        this.bytesOverwritten = bytesOverwritten;
        return this;
    }

    @JsonProperty(value="bytes_overwritten")
    @ApiModelProperty(example="123456", value="Total number of bytes overwritten in writing into the collection.")
    public Long getBytesOverwritten() {
        return this.bytesOverwritten;
    }

    public void setBytesOverwritten(Long bytesOverwritten) {
        this.bytesOverwritten = bytesOverwritten;
    }

    public CollectionStats columnIndexSize(Long columnIndexSize) {
        this.columnIndexSize = columnIndexSize;
        return this;
    }

    @JsonProperty(value="column_index_size")
    @ApiModelProperty(example="123456", value="Total collection column index size in bytes.")
    public Long getColumnIndexSize() {
        return this.columnIndexSize;
    }

    public void setColumnIndexSize(Long columnIndexSize) {
        this.columnIndexSize = columnIndexSize;
    }

    public CollectionStats docCount(Long docCount) {
        this.docCount = docCount;
        return this;
    }

    @JsonProperty(value="doc_count")
    @ApiModelProperty(example="2145", value="Number of documents in the collection.")
    public Long getDocCount() {
        return this.docCount;
    }

    public void setDocCount(Long docCount) {
        this.docCount = docCount;
    }

    public CollectionStats fillProgress(Double fillProgress) {
        this.fillProgress = fillProgress;
        return this;
    }

    @JsonProperty(value="fill_progress")
    @ApiModelProperty(example="0.6", value="Number between 0 and 1 that indicates progress of collection creation.")
    public Double getFillProgress() {
        return this.fillProgress;
    }

    public void setFillProgress(Double fillProgress) {
        this.fillProgress = fillProgress;
    }

    public CollectionStats invertedIndexSize(Long invertedIndexSize) {
        this.invertedIndexSize = invertedIndexSize;
        return this;
    }

    @JsonProperty(value="inverted_index_size")
    @ApiModelProperty(example="123456", value="Total collection inverted index size in bytes.")
    public Long getInvertedIndexSize() {
        return this.invertedIndexSize;
    }

    public void setInvertedIndexSize(Long invertedIndexSize) {
        this.invertedIndexSize = invertedIndexSize;
    }

    public CollectionStats lastQueriedMs(Long lastQueriedMs) {
        this.lastQueriedMs = lastQueriedMs;
        return this;
    }

    @JsonProperty(value="last_queried_ms")
    @ApiModelProperty(example="1535101119334", value="Milliseconds since Unix epoch Jan 1, 1970.")
    public Long getLastQueriedMs() {
        return this.lastQueriedMs;
    }

    public void setLastQueriedMs(Long lastQueriedMs) {
        this.lastQueriedMs = lastQueriedMs;
    }

    public CollectionStats lastUpdatedMs(Long lastUpdatedMs) {
        this.lastUpdatedMs = lastUpdatedMs;
        return this;
    }

    @JsonProperty(value="last_updated_ms")
    @ApiModelProperty(example="1535101094433", value="Milliseconds since Unix epoch Jan 1, 1970.")
    public Long getLastUpdatedMs() {
        return this.lastUpdatedMs;
    }

    public void setLastUpdatedMs(Long lastUpdatedMs) {
        this.lastUpdatedMs = lastUpdatedMs;
    }

    public CollectionStats purgedDocCount(Long purgedDocCount) {
        this.purgedDocCount = purgedDocCount;
        return this;
    }

    @JsonProperty(value="purged_doc_count")
    @ApiModelProperty(example="2145", value="Number of documents purged from the collection.")
    public Long getPurgedDocCount() {
        return this.purgedDocCount;
    }

    public void setPurgedDocCount(Long purgedDocCount) {
        this.purgedDocCount = purgedDocCount;
    }

    public CollectionStats purgedDocSize(Long purgedDocSize) {
        this.purgedDocSize = purgedDocSize;
        return this;
    }

    @JsonProperty(value="purged_doc_size")
    @ApiModelProperty(example="123456", value="Total size of bytes purged in bytes.")
    public Long getPurgedDocSize() {
        return this.purgedDocSize;
    }

    public void setPurgedDocSize(Long purgedDocSize) {
        this.purgedDocSize = purgedDocSize;
    }

    public CollectionStats rangeIndexSize(Long rangeIndexSize) {
        this.rangeIndexSize = rangeIndexSize;
        return this;
    }

    @JsonProperty(value="range_index_size")
    @ApiModelProperty(example="123456", value="Total collection range index size in bytes.")
    public Long getRangeIndexSize() {
        return this.rangeIndexSize;
    }

    public void setRangeIndexSize(Long rangeIndexSize) {
        this.rangeIndexSize = rangeIndexSize;
    }

    public CollectionStats rowIndexSize(Long rowIndexSize) {
        this.rowIndexSize = rowIndexSize;
        return this;
    }

    @JsonProperty(value="row_index_size")
    @ApiModelProperty(example="123456", value="Total collection row index size in bytes.")
    public Long getRowIndexSize() {
        return this.rowIndexSize;
    }

    public void setRowIndexSize(Long rowIndexSize) {
        this.rowIndexSize = rowIndexSize;
    }

    public CollectionStats totalIndexSize(Long totalIndexSize) {
        this.totalIndexSize = totalIndexSize;
        return this;
    }

    @JsonProperty(value="total_index_size")
    @ApiModelProperty(example="123456", value="Total collection index size in bytes.")
    public Long getTotalIndexSize() {
        return this.totalIndexSize;
    }

    public void setTotalIndexSize(Long totalIndexSize) {
        this.totalIndexSize = totalIndexSize;
    }

    public CollectionStats totalSize(Long totalSize) {
        this.totalSize = totalSize;
        return this;
    }

    @JsonProperty(value="total_size")
    @ApiModelProperty(example="123456", value="Total collection size in bytes.")
    public Long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(Long totalSize) {
        this.totalSize = totalSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionStats collectionStats = (CollectionStats)o;
        return Objects.equals(this.bulkBytesInserted, collectionStats.bulkBytesInserted) && Objects.equals(this.bulkBytesOverwritten, collectionStats.bulkBytesOverwritten) && Objects.equals(this.bytesInserted, collectionStats.bytesInserted) && Objects.equals(this.bytesOverwritten, collectionStats.bytesOverwritten) && Objects.equals(this.columnIndexSize, collectionStats.columnIndexSize) && Objects.equals(this.docCount, collectionStats.docCount) && Objects.equals(this.fillProgress, collectionStats.fillProgress) && Objects.equals(this.invertedIndexSize, collectionStats.invertedIndexSize) && Objects.equals(this.lastQueriedMs, collectionStats.lastQueriedMs) && Objects.equals(this.lastUpdatedMs, collectionStats.lastUpdatedMs) && Objects.equals(this.purgedDocCount, collectionStats.purgedDocCount) && Objects.equals(this.purgedDocSize, collectionStats.purgedDocSize) && Objects.equals(this.rangeIndexSize, collectionStats.rangeIndexSize) && Objects.equals(this.rowIndexSize, collectionStats.rowIndexSize) && Objects.equals(this.totalIndexSize, collectionStats.totalIndexSize) && Objects.equals(this.totalSize, collectionStats.totalSize);
    }

    public int hashCode() {
        return Objects.hash(this.bulkBytesInserted, this.bulkBytesOverwritten, this.bytesInserted, this.bytesOverwritten, this.columnIndexSize, this.docCount, this.fillProgress, this.invertedIndexSize, this.lastQueriedMs, this.lastUpdatedMs, this.purgedDocCount, this.purgedDocSize, this.rangeIndexSize, this.rowIndexSize, this.totalIndexSize, this.totalSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectionStats {\n");
        sb.append("    bulkBytesInserted: ").append(this.toIndentedString(this.bulkBytesInserted)).append("\n");
        sb.append("    bulkBytesOverwritten: ").append(this.toIndentedString(this.bulkBytesOverwritten)).append("\n");
        sb.append("    bytesInserted: ").append(this.toIndentedString(this.bytesInserted)).append("\n");
        sb.append("    bytesOverwritten: ").append(this.toIndentedString(this.bytesOverwritten)).append("\n");
        sb.append("    columnIndexSize: ").append(this.toIndentedString(this.columnIndexSize)).append("\n");
        sb.append("    docCount: ").append(this.toIndentedString(this.docCount)).append("\n");
        sb.append("    fillProgress: ").append(this.toIndentedString(this.fillProgress)).append("\n");
        sb.append("    invertedIndexSize: ").append(this.toIndentedString(this.invertedIndexSize)).append("\n");
        sb.append("    lastQueriedMs: ").append(this.toIndentedString(this.lastQueriedMs)).append("\n");
        sb.append("    lastUpdatedMs: ").append(this.toIndentedString(this.lastUpdatedMs)).append("\n");
        sb.append("    purgedDocCount: ").append(this.toIndentedString(this.purgedDocCount)).append("\n");
        sb.append("    purgedDocSize: ").append(this.toIndentedString(this.purgedDocSize)).append("\n");
        sb.append("    rangeIndexSize: ").append(this.toIndentedString(this.rangeIndexSize)).append("\n");
        sb.append("    rowIndexSize: ").append(this.toIndentedString(this.rowIndexSize)).append("\n");
        sb.append("    totalIndexSize: ").append(this.toIndentedString(this.totalIndexSize)).append("\n");
        sb.append("    totalSize: ").append(this.toIndentedString(this.totalSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

