/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.EventTimeInfo;
import com.rockset.client.model.FieldMappingQuery;
import com.rockset.client.model.FieldPartition;
import com.rockset.client.model.Source;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateCollectionRequest {
    @SerializedName(value="clustering_key")
    private List<FieldPartition> clusteringKey = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="event_time_info")
    private EventTimeInfo eventTimeInfo = null;
    @SerializedName(value="field_mapping_query")
    private FieldMappingQuery fieldMappingQuery = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="retention_secs")
    private Long retentionSecs = null;
    @SerializedName(value="source_download_soft_limit_bytes")
    private Long sourceDownloadSoftLimitBytes = null;
    @SerializedName(value="sources")
    private List<Source> sources = null;
    @SerializedName(value="storage_compression_type")
    private StorageCompressionTypeEnum storageCompressionType = null;

    public CreateCollectionRequest clusteringKey(List<FieldPartition> clusteringKey) {
        this.clusteringKey = clusteringKey;
        return this;
    }

    public CreateCollectionRequest addClusteringKeyItem(FieldPartition clusteringKeyItem) {
        if (this.clusteringKey == null) {
            this.clusteringKey = new ArrayList<FieldPartition>();
        }
        this.clusteringKey.add(clusteringKeyItem);
        return this;
    }

    @JsonProperty(value="clustering_key")
    @ApiModelProperty(value="Deprecated. List of clustering fields. Use CLUSTER BY clause in `field_mapping_query` instead.")
    public List<FieldPartition> getClusteringKey() {
        return this.clusteringKey;
    }

    public void setClusteringKey(List<FieldPartition> clusteringKey) {
        this.clusteringKey = clusteringKey;
    }

    public CreateCollectionRequest description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="transactions from stores worldwide", value="Text describing the collection.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateCollectionRequest eventTimeInfo(EventTimeInfo eventTimeInfo) {
        this.eventTimeInfo = eventTimeInfo;
        return this;
    }

    @JsonProperty(value="event_time_info")
    @ApiModelProperty(value="Deprecated. Configuration for event data. Use an _event_time mapping in `field_mapping_query` instead.")
    public EventTimeInfo getEventTimeInfo() {
        return this.eventTimeInfo;
    }

    public void setEventTimeInfo(EventTimeInfo eventTimeInfo) {
        this.eventTimeInfo = eventTimeInfo;
    }

    public CreateCollectionRequest fieldMappingQuery(FieldMappingQuery fieldMappingQuery) {
        this.fieldMappingQuery = fieldMappingQuery;
        return this;
    }

    @JsonProperty(value="field_mapping_query")
    @ApiModelProperty(value="Ingest transformation query.")
    public FieldMappingQuery getFieldMappingQuery() {
        return this.fieldMappingQuery;
    }

    public void setFieldMappingQuery(FieldMappingQuery fieldMappingQuery) {
        this.fieldMappingQuery = fieldMappingQuery;
    }

    public CreateCollectionRequest name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="global-transactions", value="Unique identifier for collection, can contain alphanumeric or dash characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateCollectionRequest retentionSecs(Long retentionSecs) {
        this.retentionSecs = retentionSecs;
        return this;
    }

    @JsonProperty(value="retention_secs")
    @ApiModelProperty(example="1000000", value="Number of seconds after which data is purged, based on event time. Minimum allowable value is 3600s/1 hour. The maximum value is strictly less than 10 years.")
    public Long getRetentionSecs() {
        return this.retentionSecs;
    }

    public void setRetentionSecs(Long retentionSecs) {
        this.retentionSecs = retentionSecs;
    }

    public CreateCollectionRequest sourceDownloadSoftLimitBytes(Long sourceDownloadSoftLimitBytes) {
        this.sourceDownloadSoftLimitBytes = sourceDownloadSoftLimitBytes;
        return this;
    }

    @JsonProperty(value="source_download_soft_limit_bytes")
    @ApiModelProperty(value="Soft ingest limit for this collection.")
    public Long getSourceDownloadSoftLimitBytes() {
        return this.sourceDownloadSoftLimitBytes;
    }

    public void setSourceDownloadSoftLimitBytes(Long sourceDownloadSoftLimitBytes) {
        this.sourceDownloadSoftLimitBytes = sourceDownloadSoftLimitBytes;
    }

    public CreateCollectionRequest sources(List<Source> sources) {
        this.sources = sources;
        return this;
    }

    public CreateCollectionRequest addSourcesItem(Source sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<Source>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @JsonProperty(value="sources")
    @ApiModelProperty(value="List of sources from which to ingest data.")
    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public CreateCollectionRequest storageCompressionType(StorageCompressionTypeEnum storageCompressionType) {
        this.storageCompressionType = storageCompressionType;
        return this;
    }

    @JsonProperty(value="storage_compression_type")
    @ApiModelProperty(example="LZ4", value="RocksDB storage compression type.")
    public StorageCompressionTypeEnum getStorageCompressionType() {
        return this.storageCompressionType;
    }

    public void setStorageCompressionType(StorageCompressionTypeEnum storageCompressionType) {
        this.storageCompressionType = storageCompressionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCollectionRequest createCollectionRequest = (CreateCollectionRequest)o;
        return Objects.equals(this.clusteringKey, createCollectionRequest.clusteringKey) && Objects.equals(this.description, createCollectionRequest.description) && Objects.equals(this.eventTimeInfo, createCollectionRequest.eventTimeInfo) && Objects.equals(this.fieldMappingQuery, createCollectionRequest.fieldMappingQuery) && Objects.equals(this.name, createCollectionRequest.name) && Objects.equals(this.retentionSecs, createCollectionRequest.retentionSecs) && Objects.equals(this.sourceDownloadSoftLimitBytes, createCollectionRequest.sourceDownloadSoftLimitBytes) && Objects.equals(this.sources, createCollectionRequest.sources) && Objects.equals((Object)this.storageCompressionType, (Object)createCollectionRequest.storageCompressionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusteringKey, this.description, this.eventTimeInfo, this.fieldMappingQuery, this.name, this.retentionSecs, this.sourceDownloadSoftLimitBytes, this.sources, this.storageCompressionType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCollectionRequest {\n");
        sb.append("    clusteringKey: ").append(this.toIndentedString(this.clusteringKey)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    eventTimeInfo: ").append(this.toIndentedString(this.eventTimeInfo)).append("\n");
        sb.append("    fieldMappingQuery: ").append(this.toIndentedString(this.fieldMappingQuery)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    retentionSecs: ").append(this.toIndentedString(this.retentionSecs)).append("\n");
        sb.append("    sourceDownloadSoftLimitBytes: ").append(this.toIndentedString(this.sourceDownloadSoftLimitBytes)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    storageCompressionType: ").append(this.toIndentedString((Object)this.storageCompressionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StorageCompressionTypeEnum {
        LZ4("LZ4"),
        ZSTD("ZSTD");

        private String value;

        private StorageCompressionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StorageCompressionTypeEnum fromValue(String text) {
            for (StorageCompressionTypeEnum b : StorageCompressionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StorageCompressionTypeEnum> {
            public void write(JsonWriter jsonWriter, StorageCompressionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StorageCompressionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StorageCompressionTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

