/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.Privilege;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateRoleRequest {
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="privileges")
    private List<Privilege> privileges = null;
    @SerializedName(value="role_name")
    private String roleName = null;

    public CreateRoleRequest description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="Role with read and write privileges to all collections.", value="Description for the role.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateRoleRequest privileges(List<Privilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    public CreateRoleRequest addPrivilegesItem(Privilege privilegesItem) {
        if (this.privileges == null) {
            this.privileges = new ArrayList<Privilege>();
        }
        this.privileges.add(privilegesItem);
        return this;
    }

    @JsonProperty(value="privileges")
    @ApiModelProperty(value="List of privileges that will be associated with the role.")
    public List<Privilege> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(List<Privilege> privileges) {
        this.privileges = privileges;
    }

    public CreateRoleRequest roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @JsonProperty(value="role_name")
    @ApiModelProperty(example="read_write", value="Unique identifier for the role.")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRoleRequest createRoleRequest = (CreateRoleRequest)o;
        return Objects.equals(this.description, createRoleRequest.description) && Objects.equals(this.privileges, createRoleRequest.privileges) && Objects.equals(this.roleName, createRoleRequest.roleName);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.privileges, this.roleName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateRoleRequest {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    privileges: ").append(this.toIndentedString(this.privileges)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

