/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.SavedQueryParameter;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateSavedQueryRequest {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="version_tag")
    private String versionTag = null;
    @SerializedName(value="query_sql")
    private String querySql = null;
    @SerializedName(value="parameters")
    private List<SavedQueryParameter> parameters = null;

    public CreateSavedQueryRequest name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="myQuery", required=true, value="query name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateSavedQueryRequest versionTag(String versionTag) {
        this.versionTag = versionTag;
        return this;
    }

    @JsonProperty(value="version_tag")
    @ApiModelProperty(example="production version foo", value="optional version tag")
    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    public CreateSavedQueryRequest querySql(String querySql) {
        this.querySql = querySql;
        return this;
    }

    @JsonProperty(value="query_sql")
    @ApiModelProperty(example="SELECT 'Foo'", required=true, value="SQL text of this query")
    public String getQuerySql() {
        return this.querySql;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }

    public CreateSavedQueryRequest parameters(List<SavedQueryParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public CreateSavedQueryRequest addParametersItem(SavedQueryParameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<SavedQueryParameter>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @JsonProperty(value="parameters")
    @ApiModelProperty(value="parameters associated with this query")
    public List<SavedQueryParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<SavedQueryParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSavedQueryRequest createSavedQueryRequest = (CreateSavedQueryRequest)o;
        return Objects.equals(this.name, createSavedQueryRequest.name) && Objects.equals(this.versionTag, createSavedQueryRequest.versionTag) && Objects.equals(this.querySql, createSavedQueryRequest.querySql) && Objects.equals(this.parameters, createSavedQueryRequest.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.versionTag, this.querySql, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateSavedQueryRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    versionTag: ").append(this.toIndentedString(this.versionTag)).append("\n");
        sb.append("    querySql: ").append(this.toIndentedString(this.querySql)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

