/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class CreateScheduledLambdaRequest {
    @SerializedName(value="apikey")
    private String apikey = null;
    @SerializedName(value="cron_string")
    private String cronString = null;
    @SerializedName(value="ql_name")
    private String qlName = null;
    @SerializedName(value="tag")
    private String tag = null;
    @SerializedName(value="total_times_to_execute")
    private Long totalTimesToExecute = null;
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="webhook_auth_header")
    private String webhookAuthHeader = null;
    @SerializedName(value="webhook_payload")
    private String webhookPayload = null;
    @SerializedName(value="webhook_url")
    private String webhookUrl = null;

    public CreateScheduledLambdaRequest apikey(String apikey) {
        this.apikey = apikey;
        return this;
    }

    @JsonProperty(value="apikey")
    @ApiModelProperty(example="qoiwkjndksd", value="The apikey to use when triggering execution of the associated query lambda.")
    public String getApikey() {
        return this.apikey;
    }

    public void setApikey(String apikey) {
        this.apikey = apikey;
    }

    public CreateScheduledLambdaRequest cronString(String cronString) {
        this.cronString = cronString;
        return this;
    }

    @JsonProperty(value="cron_string")
    @ApiModelProperty(example="* * * * *", required=true, value="The UNIX-formatted cron string for this scheduled query lambda.")
    public String getCronString() {
        return this.cronString;
    }

    public void setCronString(String cronString) {
        this.cronString = cronString;
    }

    public CreateScheduledLambdaRequest qlName(String qlName) {
        this.qlName = qlName;
        return this;
    }

    @JsonProperty(value="ql_name")
    @ApiModelProperty(example="ql_name", required=true, value="The name of the QL to use for scheduled execution.")
    public String getQlName() {
        return this.qlName;
    }

    public void setQlName(String qlName) {
        this.qlName = qlName;
    }

    public CreateScheduledLambdaRequest tag(String tag) {
        this.tag = tag;
        return this;
    }

    @JsonProperty(value="tag")
    @ApiModelProperty(example="production", value="The QL tag to use for scheduled execution.")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public CreateScheduledLambdaRequest totalTimesToExecute(Long totalTimesToExecute) {
        this.totalTimesToExecute = totalTimesToExecute;
        return this;
    }

    @JsonProperty(value="total_times_to_execute")
    @ApiModelProperty(example="1", value="The number of times to execute this scheduled query lambda. Once this scheduled query lambda has been executed this many times, it will no longer be executed.")
    public Long getTotalTimesToExecute() {
        return this.totalTimesToExecute;
    }

    public void setTotalTimesToExecute(Long totalTimesToExecute) {
        this.totalTimesToExecute = totalTimesToExecute;
    }

    public CreateScheduledLambdaRequest version(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @ApiModelProperty(example="abcdef1234", value="The version of the QL to use for scheduled execution.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public CreateScheduledLambdaRequest webhookAuthHeader(String webhookAuthHeader) {
        this.webhookAuthHeader = webhookAuthHeader;
        return this;
    }

    @JsonProperty(value="webhook_auth_header")
    @ApiModelProperty(example="bearer qiowjkjkdskdskldio", value="The value to use as the authorization header when hitting the webhook.")
    public String getWebhookAuthHeader() {
        return this.webhookAuthHeader;
    }

    public void setWebhookAuthHeader(String webhookAuthHeader) {
        this.webhookAuthHeader = webhookAuthHeader;
    }

    public CreateScheduledLambdaRequest webhookPayload(String webhookPayload) {
        this.webhookPayload = webhookPayload;
        return this;
    }

    @JsonProperty(value="webhook_payload")
    @ApiModelProperty(value="The payload that should be sent to the webhook. JSON format.")
    public String getWebhookPayload() {
        return this.webhookPayload;
    }

    public void setWebhookPayload(String webhookPayload) {
        this.webhookPayload = webhookPayload;
    }

    public CreateScheduledLambdaRequest webhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    @JsonProperty(value="webhook_url")
    @ApiModelProperty(example="https://hooks.slack.com/services/T00000000/B00000000/XXXXXXXXXXXXXXXXXXXXXXXX", value="The URL of the webhook that should be triggered after this scheduled query lambda completes.")
    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateScheduledLambdaRequest createScheduledLambdaRequest = (CreateScheduledLambdaRequest)o;
        return Objects.equals(this.apikey, createScheduledLambdaRequest.apikey) && Objects.equals(this.cronString, createScheduledLambdaRequest.cronString) && Objects.equals(this.qlName, createScheduledLambdaRequest.qlName) && Objects.equals(this.tag, createScheduledLambdaRequest.tag) && Objects.equals(this.totalTimesToExecute, createScheduledLambdaRequest.totalTimesToExecute) && Objects.equals(this.version, createScheduledLambdaRequest.version) && Objects.equals(this.webhookAuthHeader, createScheduledLambdaRequest.webhookAuthHeader) && Objects.equals(this.webhookPayload, createScheduledLambdaRequest.webhookPayload) && Objects.equals(this.webhookUrl, createScheduledLambdaRequest.webhookUrl);
    }

    public int hashCode() {
        return Objects.hash(this.apikey, this.cronString, this.qlName, this.tag, this.totalTimesToExecute, this.version, this.webhookAuthHeader, this.webhookPayload, this.webhookUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateScheduledLambdaRequest {\n");
        sb.append("    apikey: ").append(this.toIndentedString(this.apikey)).append("\n");
        sb.append("    cronString: ").append(this.toIndentedString(this.cronString)).append("\n");
        sb.append("    qlName: ").append(this.toIndentedString(this.qlName)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    totalTimesToExecute: ").append(this.toIndentedString(this.totalTimesToExecute)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    webhookAuthHeader: ").append(this.toIndentedString(this.webhookAuthHeader)).append("\n");
        sb.append("    webhookPayload: ").append(this.toIndentedString(this.webhookPayload)).append("\n");
        sb.append("    webhookUrl: ").append(this.toIndentedString(this.webhookUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

