/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateUserRequest {
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="first_name")
    private String firstName = null;
    @SerializedName(value="last_name")
    private String lastName = null;
    @SerializedName(value="roles")
    private List<String> roles = new ArrayList<String>();

    public CreateUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="email")
    @ApiModelProperty(example="hello@rockset.com", required=true, value="User email, must be unique.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CreateUserRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @JsonProperty(value="first_name")
    @ApiModelProperty(example="John", value="User first name.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public CreateUserRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @JsonProperty(value="last_name")
    @ApiModelProperty(example="Doe", value="User last name.")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public CreateUserRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CreateUserRequest addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @JsonProperty(value="roles")
    @ApiModelProperty(example="\"[\\\"admin\\\", \\\"member\\\", \\\"read-only\\\"]\"", required=true, value="List of roles for a given user.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUserRequest createUserRequest = (CreateUserRequest)o;
        return Objects.equals(this.email, createUserRequest.email) && Objects.equals(this.firstName, createUserRequest.firstName) && Objects.equals(this.lastName, createUserRequest.lastName) && Objects.equals(this.roles, createUserRequest.roles);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.firstName, this.lastName, this.roles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUserRequest {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

