/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class CreateVirtualInstanceRequest {
    @SerializedName(value="auto_suspend_seconds")
    private Integer autoSuspendSeconds = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="enable_remount_on_resume")
    private Boolean enableRemountOnResume = null;
    @SerializedName(value="mount_refresh_interval_seconds")
    private Integer mountRefreshIntervalSeconds = null;
    @SerializedName(value="mount_type")
    private MountTypeEnum mountType = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public CreateVirtualInstanceRequest autoSuspendSeconds(Integer autoSuspendSeconds) {
        this.autoSuspendSeconds = autoSuspendSeconds;
        return this;
    }

    @JsonProperty(value="auto_suspend_seconds")
    @ApiModelProperty(example="3600", value="Number of seconds without queries after which the VI is suspended")
    public Integer getAutoSuspendSeconds() {
        return this.autoSuspendSeconds;
    }

    public void setAutoSuspendSeconds(Integer autoSuspendSeconds) {
        this.autoSuspendSeconds = autoSuspendSeconds;
    }

    public CreateVirtualInstanceRequest description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="VI serving prod traffic", value="Description of requested virtual instance.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateVirtualInstanceRequest enableRemountOnResume(Boolean enableRemountOnResume) {
        this.enableRemountOnResume = enableRemountOnResume;
        return this;
    }

    @JsonProperty(value="enable_remount_on_resume")
    @ApiModelProperty(example="true", value="When a Virtual Instance is resumed, it will remount all collections that were mounted when the Virtual Instance was suspended.")
    public Boolean isEnableRemountOnResume() {
        return this.enableRemountOnResume;
    }

    public void setEnableRemountOnResume(Boolean enableRemountOnResume) {
        this.enableRemountOnResume = enableRemountOnResume;
    }

    public CreateVirtualInstanceRequest mountRefreshIntervalSeconds(Integer mountRefreshIntervalSeconds) {
        this.mountRefreshIntervalSeconds = mountRefreshIntervalSeconds;
        return this;
    }

    @JsonProperty(value="mount_refresh_interval_seconds")
    @ApiModelProperty(example="0", value="DEPRECATED. Use `mount_type` instead. Number of seconds between data refreshes for mounts on this Virtual Instance. The only valid values are 0 and null. 0 means the data will be refreshed continuously and null means the data will never refresh.")
    public Integer getMountRefreshIntervalSeconds() {
        return this.mountRefreshIntervalSeconds;
    }

    public void setMountRefreshIntervalSeconds(Integer mountRefreshIntervalSeconds) {
        this.mountRefreshIntervalSeconds = mountRefreshIntervalSeconds;
    }

    public CreateVirtualInstanceRequest mountType(MountTypeEnum mountType) {
        this.mountType = mountType;
        return this;
    }

    @JsonProperty(value="mount_type")
    @ApiModelProperty(example="LIVE", value="The mount type of collections that this Virtual Instance will query. Live mounted collections stay up-to-date with the underlying collection in real-time. Static mounted collections do not stay up-to-date. See https://docs.rockset.com/documentation/docs/virtual-instances#virtual-instance-configuration")
    public MountTypeEnum getMountType() {
        return this.mountType;
    }

    public void setMountType(MountTypeEnum mountType) {
        this.mountType = mountType;
    }

    public CreateVirtualInstanceRequest name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="prod_vi", required=true, value="Unique identifier for virtual instance, can contain alphanumeric or dash characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateVirtualInstanceRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @ApiModelProperty(example="LARGE", value="Requested virtual instance type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateVirtualInstanceRequest createVirtualInstanceRequest = (CreateVirtualInstanceRequest)o;
        return Objects.equals(this.autoSuspendSeconds, createVirtualInstanceRequest.autoSuspendSeconds) && Objects.equals(this.description, createVirtualInstanceRequest.description) && Objects.equals(this.enableRemountOnResume, createVirtualInstanceRequest.enableRemountOnResume) && Objects.equals(this.mountRefreshIntervalSeconds, createVirtualInstanceRequest.mountRefreshIntervalSeconds) && Objects.equals((Object)this.mountType, (Object)createVirtualInstanceRequest.mountType) && Objects.equals(this.name, createVirtualInstanceRequest.name) && Objects.equals((Object)this.type, (Object)createVirtualInstanceRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoSuspendSeconds, this.description, this.enableRemountOnResume, this.mountRefreshIntervalSeconds, this.mountType, this.name, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateVirtualInstanceRequest {\n");
        sb.append("    autoSuspendSeconds: ").append(this.toIndentedString(this.autoSuspendSeconds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    enableRemountOnResume: ").append(this.toIndentedString(this.enableRemountOnResume)).append("\n");
        sb.append("    mountRefreshIntervalSeconds: ").append(this.toIndentedString(this.mountRefreshIntervalSeconds)).append("\n");
        sb.append("    mountType: ").append(this.toIndentedString((Object)this.mountType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FREE("FREE"),
        NANO("NANO"),
        SHARED("SHARED"),
        MILLI("MILLI"),
        XSMALL("XSMALL"),
        SMALL("SMALL"),
        MEDIUM("MEDIUM"),
        LARGE("LARGE"),
        XLARGE("XLARGE"),
        XLARGE2("XLARGE2"),
        XLARGE4("XLARGE4"),
        XLARGE8("XLARGE8"),
        XLARGE16("XLARGE16");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MountTypeEnum {
        LIVE("LIVE"),
        STATIC("STATIC");

        private String value;

        private MountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MountTypeEnum fromValue(String text) {
            for (MountTypeEnum b : MountTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MountTypeEnum> {
            public void write(JsonWriter jsonWriter, MountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MountTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MountTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

