/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CsvParams {
    @SerializedName(value="columnNames")
    private List<String> columnNames = null;
    @SerializedName(value="columnTypes")
    private List<ColumnTypesEnum> columnTypes = null;
    @SerializedName(value="encoding")
    private String encoding = null;
    @SerializedName(value="escapeChar")
    private String escapeChar = null;
    @SerializedName(value="firstLineAsColumnNames")
    private Boolean firstLineAsColumnNames = null;
    @SerializedName(value="quoteChar")
    private String quoteChar = null;
    @SerializedName(value="separator")
    private String separator = null;

    public CsvParams columnNames(List<String> columnNames) {
        this.columnNames = columnNames;
        return this;
    }

    public CsvParams addColumnNamesItem(String columnNamesItem) {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<String>();
        }
        this.columnNames.add(columnNamesItem);
        return this;
    }

    @JsonProperty(value="columnNames")
    @ApiModelProperty(example="\"[\\\"c1\\\", \\\"c2\\\", \\\"c3\\\"]\"", value="Names of columns.")
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public CsvParams columnTypes(List<ColumnTypesEnum> columnTypes) {
        this.columnTypes = columnTypes;
        return this;
    }

    public CsvParams addColumnTypesItem(ColumnTypesEnum columnTypesItem) {
        if (this.columnTypes == null) {
            this.columnTypes = new ArrayList<ColumnTypesEnum>();
        }
        this.columnTypes.add(columnTypesItem);
        return this;
    }

    @JsonProperty(value="columnTypes")
    @ApiModelProperty(example="\"[\\\"BOOLEAN\\\", \\\"INTEGER\\\", \\\"FLOAT\\\", \\\"STRING\\\"]\"", value="Names of columns.")
    public List<ColumnTypesEnum> getColumnTypes() {
        return this.columnTypes;
    }

    public void setColumnTypes(List<ColumnTypesEnum> columnTypes) {
        this.columnTypes = columnTypes;
    }

    public CsvParams encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @JsonProperty(value="encoding")
    @ApiModelProperty(example="UTF-8", value="One of: UTF-8, ISO_8859_1, UTF-16.")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public CsvParams escapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    @JsonProperty(value="escapeChar")
    @ApiModelProperty(example="\\", value="escape character removes any special meaning from the following character,default is '\\'")
    public String getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
    }

    public CsvParams firstLineAsColumnNames(Boolean firstLineAsColumnNames) {
        this.firstLineAsColumnNames = firstLineAsColumnNames;
        return this;
    }

    @JsonProperty(value="firstLineAsColumnNames")
    @ApiModelProperty(example="true", value="If the first line in every object specifies the column names.")
    public Boolean isFirstLineAsColumnNames() {
        return this.firstLineAsColumnNames;
    }

    public void setFirstLineAsColumnNames(Boolean firstLineAsColumnNames) {
        this.firstLineAsColumnNames = firstLineAsColumnNames;
    }

    public CsvParams quoteChar(String quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    @JsonProperty(value="quoteChar")
    @ApiModelProperty(example="\"", value="character within which a cell value is enclosed,null character if no such character, default is '\"'")
    public String getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(String quoteChar) {
        this.quoteChar = quoteChar;
    }

    public CsvParams separator(String separator) {
        this.separator = separator;
        return this;
    }

    @JsonProperty(value="separator")
    @ApiModelProperty(example=",", value="A single character that is the column separator.")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvParams csvParams = (CsvParams)o;
        return Objects.equals(this.columnNames, csvParams.columnNames) && Objects.equals(this.columnTypes, csvParams.columnTypes) && Objects.equals(this.encoding, csvParams.encoding) && Objects.equals(this.escapeChar, csvParams.escapeChar) && Objects.equals(this.firstLineAsColumnNames, csvParams.firstLineAsColumnNames) && Objects.equals(this.quoteChar, csvParams.quoteChar) && Objects.equals(this.separator, csvParams.separator);
    }

    public int hashCode() {
        return Objects.hash(this.columnNames, this.columnTypes, this.encoding, this.escapeChar, this.firstLineAsColumnNames, this.quoteChar, this.separator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CsvParams {\n");
        sb.append("    columnNames: ").append(this.toIndentedString(this.columnNames)).append("\n");
        sb.append("    columnTypes: ").append(this.toIndentedString(this.columnTypes)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("    escapeChar: ").append(this.toIndentedString(this.escapeChar)).append("\n");
        sb.append("    firstLineAsColumnNames: ").append(this.toIndentedString(this.firstLineAsColumnNames)).append("\n");
        sb.append("    quoteChar: ").append(this.toIndentedString(this.quoteChar)).append("\n");
        sb.append("    separator: ").append(this.toIndentedString(this.separator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ColumnTypesEnum {
        UNKNOWN("UNKNOWN"),
        BOOLEAN("BOOLEAN"),
        BOOL("BOOL"),
        INTEGER("INTEGER"),
        INT("INT"),
        FLOAT("FLOAT"),
        TIME("TIME"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIMESTAMP("TIMESTAMP"),
        STRING("STRING");

        private String value;

        private ColumnTypesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ColumnTypesEnum fromValue(String text) {
            for (ColumnTypesEnum b : ColumnTypesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ColumnTypesEnum> {
            public void write(JsonWriter jsonWriter, ColumnTypesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ColumnTypesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ColumnTypesEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

