/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.ErrorModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class DocumentStatus {
    @SerializedName(value="_collection")
    private String collection = null;
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="error")
    private ErrorModel error = null;
    @SerializedName(value="patch_id")
    private String patchId = null;
    @SerializedName(value="status")
    private StatusEnum status = null;

    public DocumentStatus collection(String collection) {
        this.collection = collection;
        return this;
    }

    @JsonProperty(value="_collection")
    @ApiModelProperty(example="customers", value="Collection name.")
    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public DocumentStatus id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="_id")
    @ApiModelProperty(example="2cd61e3b", value="Unique document ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DocumentStatus error(ErrorModel error) {
        this.error = error;
        return this;
    }

    @JsonProperty(value="error")
    @ApiModelProperty(value="Error message, if any.")
    public ErrorModel getError() {
        return this.error;
    }

    public void setError(ErrorModel error) {
        this.error = error;
    }

    public DocumentStatus patchId(String patchId) {
        this.patchId = patchId;
        return this;
    }

    @JsonProperty(value="patch_id")
    @ApiModelProperty(example="486gsg8", value="Unique id used to represent each patch request.")
    public String getPatchId() {
        return this.patchId;
    }

    public void setPatchId(String patchId) {
        this.patchId = patchId;
    }

    public DocumentStatus status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(example="ADDED", value="Status of the document.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentStatus documentStatus = (DocumentStatus)o;
        return Objects.equals(this.collection, documentStatus.collection) && Objects.equals(this.id, documentStatus.id) && Objects.equals(this.error, documentStatus.error) && Objects.equals(this.patchId, documentStatus.patchId) && Objects.equals((Object)this.status, (Object)documentStatus.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.collection, this.id, this.error, this.patchId, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentStatus {\n");
        sb.append("    collection: ").append(this.toIndentedString(this.collection)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    patchId: ").append(this.toIndentedString(this.patchId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ADDED("ADDED"),
        REPLACED("REPLACED"),
        DELETED("DELETED"),
        PATCHED("PATCHED"),
        ERROR("ERROR");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

