/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.AwsAccessKey;
import com.rockset.client.model.AwsRole;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class DynamodbIntegration {
    @SerializedName(value="aws_access_key")
    private AwsAccessKey awsAccessKey = null;
    @SerializedName(value="aws_role")
    private AwsRole awsRole = null;
    @SerializedName(value="s3_export_bucket_name")
    private String s3ExportBucketName = null;

    public DynamodbIntegration awsAccessKey(AwsAccessKey awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    @JsonProperty(value="aws_access_key")
    @ApiModelProperty(value="Credentials for an AWS access key integration.")
    public AwsAccessKey getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(AwsAccessKey awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public DynamodbIntegration awsRole(AwsRole awsRole) {
        this.awsRole = awsRole;
        return this;
    }

    @JsonProperty(value="aws_role")
    @ApiModelProperty(value="Role used for external id type authentication.")
    public AwsRole getAwsRole() {
        return this.awsRole;
    }

    public void setAwsRole(AwsRole awsRole) {
        this.awsRole = awsRole;
    }

    public DynamodbIntegration s3ExportBucketName(String s3ExportBucketName) {
        this.s3ExportBucketName = s3ExportBucketName;
        return this;
    }

    @JsonProperty(value="s3_export_bucket_name")
    @ApiModelProperty(value="S3 bucket used for export during collection initial dump.")
    public String getS3ExportBucketName() {
        return this.s3ExportBucketName;
    }

    public void setS3ExportBucketName(String s3ExportBucketName) {
        this.s3ExportBucketName = s3ExportBucketName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamodbIntegration dynamodbIntegration = (DynamodbIntegration)o;
        return Objects.equals(this.awsAccessKey, dynamodbIntegration.awsAccessKey) && Objects.equals(this.awsRole, dynamodbIntegration.awsRole) && Objects.equals(this.s3ExportBucketName, dynamodbIntegration.s3ExportBucketName);
    }

    public int hashCode() {
        return Objects.hash(this.awsAccessKey, this.awsRole, this.s3ExportBucketName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DynamodbIntegration {\n");
        sb.append("    awsAccessKey: ").append(this.toIndentedString(this.awsAccessKey)).append("\n");
        sb.append("    awsRole: ").append(this.toIndentedString(this.awsRole)).append("\n");
        sb.append("    s3ExportBucketName: ").append(this.toIndentedString(this.s3ExportBucketName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

