/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Describes details about an error")
public class ErrorModel {
    @SerializedName(value="column")
    private Integer column = null;
    @SerializedName(value="error_id")
    private String errorId = null;
    @SerializedName(value="line")
    private Integer line = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="query_id")
    private String queryId = null;
    @SerializedName(value="trace_id")
    private String traceId = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public ErrorModel column(Integer column) {
        this.column = column;
        return this;
    }

    @JsonProperty(value="column")
    @ApiModelProperty(value="Column where the error happened (if applicable).")
    public Integer getColumn() {
        return this.column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    public ErrorModel errorId(String errorId) {
        this.errorId = errorId;
        return this;
    }

    @JsonProperty(value="error_id")
    @ApiModelProperty(value="ID of the error.")
    public String getErrorId() {
        return this.errorId;
    }

    public void setErrorId(String errorId) {
        this.errorId = errorId;
    }

    public ErrorModel line(Integer line) {
        this.line = line;
        return this;
    }

    @JsonProperty(value="line")
    @ApiModelProperty(value="Line where the error happened (if applicable).")
    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public ErrorModel message(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="message")
    @ApiModelProperty(example="collection not found", value="Descriptive message about the error.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ErrorModel queryId(String queryId) {
        this.queryId = queryId;
        return this;
    }

    @JsonProperty(value="query_id")
    @ApiModelProperty(value="ID of the query (if applicable).")
    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public ErrorModel traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @JsonProperty(value="trace_id")
    @ApiModelProperty(value="Internal trace ID to help with debugging.")
    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public ErrorModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @ApiModelProperty(example="INVALIDINPUT", value="Category of the error.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorModel errorModel = (ErrorModel)o;
        return Objects.equals(this.column, errorModel.column) && Objects.equals(this.errorId, errorModel.errorId) && Objects.equals(this.line, errorModel.line) && Objects.equals(this.message, errorModel.message) && Objects.equals(this.queryId, errorModel.queryId) && Objects.equals(this.traceId, errorModel.traceId) && Objects.equals((Object)this.type, (Object)errorModel.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.errorId, this.line, this.message, this.queryId, this.traceId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorModel {\n");
        sb.append("    column: ").append(this.toIndentedString(this.column)).append("\n");
        sb.append("    errorId: ").append(this.toIndentedString(this.errorId)).append("\n");
        sb.append("    line: ").append(this.toIndentedString(this.line)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    queryId: ").append(this.toIndentedString(this.queryId)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        AUTHEXCEPTION("AUTHEXCEPTION"),
        VERSIONEXCEPTION("VERSIONEXCEPTION"),
        INTERNALERROR("INTERNALERROR"),
        INVALIDINPUT("INVALIDINPUT"),
        NOTIMPLEMENTEDYET("NOTIMPLEMENTEDYET"),
        RESOURCEEXCEEDED("RESOURCEEXCEEDED"),
        ALREADYEXISTS("ALREADYEXISTS"),
        METHODNOTALLOWED("METHODNOTALLOWED"),
        NOTACCEPTABLE("NOTACCEPTABLE"),
        UNSUPPORTEDMEDIATYPE("UNSUPPORTEDMEDIATYPE"),
        NOTFOUND("NOTFOUND"),
        DEPENDENTRESOURCES("DEPENDENTRESOURCES"),
        QUERY_ERROR("QUERYERROR"),
        NOT_READY("NOTREADY"),
        FORBIDDEN("FORBIDDEN"),
        QUERY_TIMEOUT("QUERYTIMEOUT"),
        CONNECTION_ERROR("CONNECTIONERROR"),
        CONTENTTOOLARGE("CONTENTTOOLARGE"),
        CREATING("CREATING"),
        BADREQUEST("BADREQUEST"),
        SERVICEUNAVAILABLE("SERVICEUNAVAILABLE"),
        CONFLICT("CONFLICT"),
        RATELIMITEXCEEDED("RATELIMITEXCEEDED"),
        QUERY_CANCELLED("QUERYCANCELLED"),
        CLIENT_CONNECTION_ERROR("CLIENTCONNECTIONERROR");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

