/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.AsyncQueryOptions;
import com.rockset.client.model.QueryParameter;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExecuteQueryLambdaRequest {
    @SerializedName(value="async")
    private Boolean async = null;
    @SerializedName(value="async_options")
    private AsyncQueryOptions asyncOptions = null;
    @SerializedName(value="debug_threshold_ms")
    private Long debugThresholdMs = null;
    @SerializedName(value="default_row_limit")
    private Integer defaultRowLimit = null;
    @SerializedName(value="initial_paginate_response_doc_count")
    private Integer initialPaginateResponseDocCount = null;
    @SerializedName(value="max_initial_results")
    private Long maxInitialResults = null;
    @SerializedName(value="paginate")
    private Boolean paginate = null;
    @SerializedName(value="parameters")
    private List<QueryParameter> parameters = null;
    @SerializedName(value="timeout_ms")
    private Long timeoutMs = null;
    @SerializedName(value="virtual_instance_id")
    private String virtualInstanceId = null;

    public ExecuteQueryLambdaRequest async(Boolean async) {
        this.async = async;
        return this;
    }

    @JsonProperty(value="async")
    @ApiModelProperty(value="If true, the query will run asynchronously for up to 30 minutes. The query request will immediately return with a query id that can be used to retrieve the query status and results. If false or not specified, the query will return with results once completed or timeout after 2 minutes. (To return results directly for shorter queries while still allowing a timeout of up to 30 minutes, set `async_options.client_timeout_ms`.) ")
    public Boolean isAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public ExecuteQueryLambdaRequest asyncOptions(AsyncQueryOptions asyncOptions) {
        this.asyncOptions = asyncOptions;
        return this;
    }

    @JsonProperty(value="async_options")
    @ApiModelProperty(value="Options for configuring Asynchronous Query Mode.")
    public AsyncQueryOptions getAsyncOptions() {
        return this.asyncOptions;
    }

    public void setAsyncOptions(AsyncQueryOptions asyncOptions) {
        this.asyncOptions = asyncOptions;
    }

    public ExecuteQueryLambdaRequest debugThresholdMs(Long debugThresholdMs) {
        this.debugThresholdMs = debugThresholdMs;
        return this;
    }

    @JsonProperty(value="debug_threshold_ms")
    @ApiModelProperty(value="If query execution takes longer than this value, debug information will be logged. If the query text includes the DEBUG hint and this parameter is also provided, only this value will be used and the DEBUG hint will be ignored.")
    public Long getDebugThresholdMs() {
        return this.debugThresholdMs;
    }

    public void setDebugThresholdMs(Long debugThresholdMs) {
        this.debugThresholdMs = debugThresholdMs;
    }

    public ExecuteQueryLambdaRequest defaultRowLimit(Integer defaultRowLimit) {
        this.defaultRowLimit = defaultRowLimit;
        return this;
    }

    @JsonProperty(value="default_row_limit")
    @ApiModelProperty(value="Row limit to use if no limit specified in the SQL query text.")
    public Integer getDefaultRowLimit() {
        return this.defaultRowLimit;
    }

    public void setDefaultRowLimit(Integer defaultRowLimit) {
        this.defaultRowLimit = defaultRowLimit;
    }

    public ExecuteQueryLambdaRequest initialPaginateResponseDocCount(Integer initialPaginateResponseDocCount) {
        this.initialPaginateResponseDocCount = initialPaginateResponseDocCount;
        return this;
    }

    @JsonProperty(value="initial_paginate_response_doc_count")
    @ApiModelProperty(value="[DEPRECATED] Use `max_initial_results` instead. Number of documents to return in addition to paginating for this query call. Only relevant if `paginate` flag is also set.")
    public Integer getInitialPaginateResponseDocCount() {
        return this.initialPaginateResponseDocCount;
    }

    public void setInitialPaginateResponseDocCount(Integer initialPaginateResponseDocCount) {
        this.initialPaginateResponseDocCount = initialPaginateResponseDocCount;
    }

    public ExecuteQueryLambdaRequest maxInitialResults(Long maxInitialResults) {
        this.maxInitialResults = maxInitialResults;
        return this;
    }

    @JsonProperty(value="max_initial_results")
    @ApiModelProperty(value="This limits the maximum number of results in the initial response. A pagination cursor is returned if the number of results exceeds `max_initial_results`. If `max_initial_results` is not set, all results will be returned in the initial response up to 4 million. If `max_initial_results` is set, the value must be between 0 and 100,000. If the query is async and `client_timeout_ms` is exceeded, `max_initial_results` does not apply since none of the results will be returned with the initial response.")
    public Long getMaxInitialResults() {
        return this.maxInitialResults;
    }

    public void setMaxInitialResults(Long maxInitialResults) {
        this.maxInitialResults = maxInitialResults;
    }

    public ExecuteQueryLambdaRequest paginate(Boolean paginate) {
        this.paginate = paginate;
        return this;
    }

    @JsonProperty(value="paginate")
    @ApiModelProperty(value="Flag to paginate and store the results of this query for later / sequential retrieval.")
    public Boolean isPaginate() {
        return this.paginate;
    }

    public void setPaginate(Boolean paginate) {
        this.paginate = paginate;
    }

    public ExecuteQueryLambdaRequest parameters(List<QueryParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ExecuteQueryLambdaRequest addParametersItem(QueryParameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<QueryParameter>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @JsonProperty(value="parameters")
    @ApiModelProperty(value="List of named parameters.")
    public List<QueryParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<QueryParameter> parameters) {
        this.parameters = parameters;
    }

    public ExecuteQueryLambdaRequest timeoutMs(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    @JsonProperty(value="timeout_ms")
    @ApiModelProperty(value="If a query exceeds the specified timeout, the query will automatically stop and return an error. The query timeout defaults to a maximum of 2 minutes. If `async` is true, the query timeout defaults to a maximum of 30 minutes.")
    public Long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setTimeoutMs(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public ExecuteQueryLambdaRequest virtualInstanceId(String virtualInstanceId) {
        this.virtualInstanceId = virtualInstanceId;
        return this;
    }

    @JsonProperty(value="virtual_instance_id")
    @ApiModelProperty(value="Virtual instance on which to run the query.")
    public String getVirtualInstanceId() {
        return this.virtualInstanceId;
    }

    public void setVirtualInstanceId(String virtualInstanceId) {
        this.virtualInstanceId = virtualInstanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteQueryLambdaRequest executeQueryLambdaRequest = (ExecuteQueryLambdaRequest)o;
        return Objects.equals(this.async, executeQueryLambdaRequest.async) && Objects.equals(this.asyncOptions, executeQueryLambdaRequest.asyncOptions) && Objects.equals(this.debugThresholdMs, executeQueryLambdaRequest.debugThresholdMs) && Objects.equals(this.defaultRowLimit, executeQueryLambdaRequest.defaultRowLimit) && Objects.equals(this.initialPaginateResponseDocCount, executeQueryLambdaRequest.initialPaginateResponseDocCount) && Objects.equals(this.maxInitialResults, executeQueryLambdaRequest.maxInitialResults) && Objects.equals(this.paginate, executeQueryLambdaRequest.paginate) && Objects.equals(this.parameters, executeQueryLambdaRequest.parameters) && Objects.equals(this.timeoutMs, executeQueryLambdaRequest.timeoutMs) && Objects.equals(this.virtualInstanceId, executeQueryLambdaRequest.virtualInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.async, this.asyncOptions, this.debugThresholdMs, this.defaultRowLimit, this.initialPaginateResponseDocCount, this.maxInitialResults, this.paginate, this.parameters, this.timeoutMs, this.virtualInstanceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecuteQueryLambdaRequest {\n");
        sb.append("    async: ").append(this.toIndentedString(this.async)).append("\n");
        sb.append("    asyncOptions: ").append(this.toIndentedString(this.asyncOptions)).append("\n");
        sb.append("    debugThresholdMs: ").append(this.toIndentedString(this.debugThresholdMs)).append("\n");
        sb.append("    defaultRowLimit: ").append(this.toIndentedString(this.defaultRowLimit)).append("\n");
        sb.append("    initialPaginateResponseDocCount: ").append(this.toIndentedString(this.initialPaginateResponseDocCount)).append("\n");
        sb.append("    maxInitialResults: ").append(this.toIndentedString(this.maxInitialResults)).append("\n");
        sb.append("    paginate: ").append(this.toIndentedString(this.paginate)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    timeoutMs: ").append(this.toIndentedString(this.timeoutMs)).append("\n");
        sb.append("    virtualInstanceId: ").append(this.toIndentedString(this.virtualInstanceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

