/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.ExecuteSavedQueryParameter;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExecuteSavedQueryRequest {
    @SerializedName(value="workspace")
    private String workspace = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="parameters")
    private List<ExecuteSavedQueryParameter> parameters = null;
    @SerializedName(value="default_row_limit")
    private Integer defaultRowLimit = null;
    @SerializedName(value="generate_warnings")
    private Boolean generateWarnings = null;

    public ExecuteSavedQueryRequest workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @JsonProperty(value="workspace")
    @ApiModelProperty(example="commons", value="workspace of this saved query")
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public ExecuteSavedQueryRequest name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="myQuery", value="query name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExecuteSavedQueryRequest version(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @ApiModelProperty(example="1", value="query version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ExecuteSavedQueryRequest parameters(List<ExecuteSavedQueryParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ExecuteSavedQueryRequest addParametersItem(ExecuteSavedQueryParameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ExecuteSavedQueryParameter>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @JsonProperty(value="parameters")
    @ApiModelProperty(value="list of named parameters")
    public List<ExecuteSavedQueryParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ExecuteSavedQueryParameter> parameters) {
        this.parameters = parameters;
    }

    public ExecuteSavedQueryRequest defaultRowLimit(Integer defaultRowLimit) {
        this.defaultRowLimit = defaultRowLimit;
        return this;
    }

    @JsonProperty(value="default_row_limit")
    @ApiModelProperty(value="Row limit to use if no limit specified in the query")
    public Integer getDefaultRowLimit() {
        return this.defaultRowLimit;
    }

    public void setDefaultRowLimit(Integer defaultRowLimit) {
        this.defaultRowLimit = defaultRowLimit;
    }

    public ExecuteSavedQueryRequest generateWarnings(Boolean generateWarnings) {
        this.generateWarnings = generateWarnings;
        return this;
    }

    @JsonProperty(value="generate_warnings")
    @ApiModelProperty(value="Whether to generate warnings")
    public Boolean isGenerateWarnings() {
        return this.generateWarnings;
    }

    public void setGenerateWarnings(Boolean generateWarnings) {
        this.generateWarnings = generateWarnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteSavedQueryRequest executeSavedQueryRequest = (ExecuteSavedQueryRequest)o;
        return Objects.equals(this.workspace, executeSavedQueryRequest.workspace) && Objects.equals(this.name, executeSavedQueryRequest.name) && Objects.equals(this.version, executeSavedQueryRequest.version) && Objects.equals(this.parameters, executeSavedQueryRequest.parameters) && Objects.equals(this.defaultRowLimit, executeSavedQueryRequest.defaultRowLimit) && Objects.equals(this.generateWarnings, executeSavedQueryRequest.generateWarnings);
    }

    public int hashCode() {
        return Objects.hash(this.workspace, this.name, this.version, this.parameters, this.defaultRowLimit, this.generateWarnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecuteSavedQueryRequest {\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    defaultRowLimit: ").append(this.toIndentedString(this.defaultRowLimit)).append("\n");
        sb.append("    generateWarnings: ").append(this.toIndentedString(this.generateWarnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

