/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.InputField;
import com.rockset.client.model.OutputField;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FieldMappingV2 {
    @SerializedName(value="input_fields")
    private List<InputField> inputFields = null;
    @SerializedName(value="is_drop_all_fields")
    private Boolean isDropAllFields = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="output_field")
    private OutputField outputField = null;

    public FieldMappingV2 inputFields(List<InputField> inputFields) {
        this.inputFields = inputFields;
        return this;
    }

    public FieldMappingV2 addInputFieldsItem(InputField inputFieldsItem) {
        if (this.inputFields == null) {
            this.inputFields = new ArrayList<InputField>();
        }
        this.inputFields.add(inputFieldsItem);
        return this;
    }

    @JsonProperty(value="input_fields")
    @ApiModelProperty(value="A List of InputField for this mapping.")
    public List<InputField> getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(List<InputField> inputFields) {
        this.inputFields = inputFields;
    }

    public FieldMappingV2 isDropAllFields(Boolean isDropAllFields) {
        this.isDropAllFields = isDropAllFields;
        return this;
    }

    @JsonProperty(value="is_drop_all_fields")
    @ApiModelProperty(example="true", value="A boolean that determines whether to drop all fields in this document. If set, input and output fields should not be set")
    public Boolean isIsDropAllFields() {
        return this.isDropAllFields;
    }

    public void setIsDropAllFields(Boolean isDropAllFields) {
        this.isDropAllFields = isDropAllFields;
    }

    public FieldMappingV2 name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="myTestMapping", value="A user specified string that is a name for this mapping.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FieldMappingV2 outputField(OutputField outputField) {
        this.outputField = outputField;
        return this;
    }

    @JsonProperty(value="output_field")
    @ApiModelProperty(value="An OutputField for this mapping.")
    public OutputField getOutputField() {
        return this.outputField;
    }

    public void setOutputField(OutputField outputField) {
        this.outputField = outputField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMappingV2 fieldMappingV2 = (FieldMappingV2)o;
        return Objects.equals(this.inputFields, fieldMappingV2.inputFields) && Objects.equals(this.isDropAllFields, fieldMappingV2.isDropAllFields) && Objects.equals(this.name, fieldMappingV2.name) && Objects.equals(this.outputField, fieldMappingV2.outputField);
    }

    public int hashCode() {
        return Objects.hash(this.inputFields, this.isDropAllFields, this.name, this.outputField);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldMappingV2 {\n");
        sb.append("    inputFields: ").append(this.toIndentedString(this.inputFields)).append("\n");
        sb.append("    isDropAllFields: ").append(this.toIndentedString(this.isDropAllFields)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    outputField: ").append(this.toIndentedString(this.outputField)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

