/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FieldPartition {
    @SerializedName(value="field_name")
    private String fieldName = null;
    @SerializedName(value="keys")
    private List<String> keys = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public FieldPartition fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @JsonProperty(value="field_name")
    @ApiModelProperty(example="address.city.zipcode", value="The name of a field, parsed as a SQL qualified name.")
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public FieldPartition keys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    public FieldPartition addKeysItem(String keysItem) {
        if (this.keys == null) {
            this.keys = new ArrayList<String>();
        }
        this.keys.add(keysItem);
        return this;
    }

    @JsonProperty(value="keys")
    @ApiModelProperty(example="\"[\\\"value1\\\", \\\"value2\\\"]\"", value="The values for partitioning of a field. Unneeded if the partition type is AUTO.")
    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public FieldPartition type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @ApiModelProperty(example="AUTO", value="The type of partitions on a field.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPartition fieldPartition = (FieldPartition)o;
        return Objects.equals(this.fieldName, fieldPartition.fieldName) && Objects.equals(this.keys, fieldPartition.keys) && Objects.equals((Object)this.type, (Object)fieldPartition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.keys, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldPartition {\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    keys: ").append(this.toIndentedString(this.keys)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        AUTO("AUTO");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

