/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class InputField {
    @SerializedName(value="field_name")
    private String fieldName = null;
    @SerializedName(value="if_missing")
    private IfMissingEnum ifMissing = null;
    @SerializedName(value="is_drop")
    private Boolean isDrop = null;
    @SerializedName(value="param")
    private String param = null;

    public InputField fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @JsonProperty(value="field_name")
    @ApiModelProperty(example="address.city.zipcode", value="The name of a field, parsed as a SQL qualified name.")
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public InputField ifMissing(IfMissingEnum ifMissing) {
        this.ifMissing = ifMissing;
        return this;
    }

    @JsonProperty(value="if_missing")
    @ApiModelProperty(example="SKIP", value="Define the behaviour if fieldName is missing or is null.")
    public IfMissingEnum getIfMissing() {
        return this.ifMissing;
    }

    public void setIfMissing(IfMissingEnum ifMissing) {
        this.ifMissing = ifMissing;
    }

    public InputField isDrop(Boolean isDrop) {
        this.isDrop = isDrop;
        return this;
    }

    @JsonProperty(value="is_drop")
    @ApiModelProperty(example="true", value="If true, then drop fieldName from the document.")
    public Boolean isIsDrop() {
        return this.isDrop;
    }

    public void setIsDrop(Boolean isDrop) {
        this.isDrop = isDrop;
    }

    public InputField param(String param) {
        this.param = param;
        return this;
    }

    @JsonProperty(value="param")
    @ApiModelProperty(example="zip", value="Sql parameter name.")
    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputField inputField = (InputField)o;
        return Objects.equals(this.fieldName, inputField.fieldName) && Objects.equals((Object)this.ifMissing, (Object)inputField.ifMissing) && Objects.equals(this.isDrop, inputField.isDrop) && Objects.equals(this.param, inputField.param);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.ifMissing, this.isDrop, this.param});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputField {\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    ifMissing: ").append(this.toIndentedString((Object)this.ifMissing)).append("\n");
        sb.append("    isDrop: ").append(this.toIndentedString(this.isDrop)).append("\n");
        sb.append("    param: ").append(this.toIndentedString(this.param)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IfMissingEnum {
        SKIP("SKIP"),
        PASS("PASS");

        private String value;

        private IfMissingEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IfMissingEnum fromValue(String text) {
            for (IfMissingEnum b : IfMissingEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<IfMissingEnum> {
            public void write(JsonWriter jsonWriter, IfMissingEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IfMissingEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IfMissingEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

