/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.AzureBlobStorageIntegration;
import com.rockset.client.model.AzureEventHubsIntegration;
import com.rockset.client.model.AzureServiceBusIntegration;
import com.rockset.client.model.Collection;
import com.rockset.client.model.DynamodbIntegration;
import com.rockset.client.model.GcsIntegration;
import com.rockset.client.model.KafkaIntegration;
import com.rockset.client.model.KinesisIntegration;
import com.rockset.client.model.MongoDbIntegration;
import com.rockset.client.model.S3Integration;
import com.rockset.client.model.SnowflakeIntegration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Integrations that can be associated with data sources to create collections. Only one type of integration may be specified.")
public class Integration {
    @SerializedName(value="azure_blob_storage")
    private AzureBlobStorageIntegration azureBlobStorage = null;
    @SerializedName(value="azure_event_hubs")
    private AzureEventHubsIntegration azureEventHubs = null;
    @SerializedName(value="azure_service_bus")
    private AzureServiceBusIntegration azureServiceBus = null;
    @SerializedName(value="collections")
    private List<Collection> collections = null;
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="created_by")
    private String createdBy = null;
    @SerializedName(value="created_by_apikey_name")
    private String createdByApikeyName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="dynamodb")
    private DynamodbIntegration dynamodb = null;
    @SerializedName(value="gcs")
    private GcsIntegration gcs = null;
    @SerializedName(value="kafka")
    private KafkaIntegration kafka = null;
    @SerializedName(value="kinesis")
    private KinesisIntegration kinesis = null;
    @SerializedName(value="mongodb")
    private MongoDbIntegration mongodb = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="owner_email")
    private String ownerEmail = null;
    @SerializedName(value="s3")
    private S3Integration s3 = null;
    @SerializedName(value="snowflake")
    private SnowflakeIntegration snowflake = null;

    public Integration azureBlobStorage(AzureBlobStorageIntegration azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    @JsonProperty(value="azure_blob_storage")
    @ApiModelProperty(value="Azure Blob Storage details.")
    public AzureBlobStorageIntegration getAzureBlobStorage() {
        return this.azureBlobStorage;
    }

    public void setAzureBlobStorage(AzureBlobStorageIntegration azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
    }

    public Integration azureEventHubs(AzureEventHubsIntegration azureEventHubs) {
        this.azureEventHubs = azureEventHubs;
        return this;
    }

    @JsonProperty(value="azure_event_hubs")
    @ApiModelProperty(value="Azure Event Hubs details.")
    public AzureEventHubsIntegration getAzureEventHubs() {
        return this.azureEventHubs;
    }

    public void setAzureEventHubs(AzureEventHubsIntegration azureEventHubs) {
        this.azureEventHubs = azureEventHubs;
    }

    public Integration azureServiceBus(AzureServiceBusIntegration azureServiceBus) {
        this.azureServiceBus = azureServiceBus;
        return this;
    }

    @JsonProperty(value="azure_service_bus")
    @ApiModelProperty(value="Azure Service Bus details.")
    public AzureServiceBusIntegration getAzureServiceBus() {
        return this.azureServiceBus;
    }

    public void setAzureServiceBus(AzureServiceBusIntegration azureServiceBus) {
        this.azureServiceBus = azureServiceBus;
    }

    public Integration collections(List<Collection> collections) {
        this.collections = collections;
        return this;
    }

    public Integration addCollectionsItem(Collection collectionsItem) {
        if (this.collections == null) {
            this.collections = new ArrayList<Collection>();
        }
        this.collections.add(collectionsItem);
        return this;
    }

    @JsonProperty(value="collections")
    @ApiModelProperty(value="List of collections that use the integration.")
    public List<Collection> getCollections() {
        return this.collections;
    }

    public void setCollections(List<Collection> collections) {
        this.collections = collections;
    }

    public Integration createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Integration createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="created_by")
    @ApiModelProperty(example="hello@rockset.com", required=true, value="Email of user who created the integration.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Integration createdByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
        return this;
    }

    @JsonProperty(value="created_by_apikey_name")
    @ApiModelProperty(value="Name of the API key that was used to create this object if one was used.")
    public String getCreatedByApikeyName() {
        return this.createdByApikeyName;
    }

    public void setCreatedByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
    }

    public Integration description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="AWS account with event data for the data science team.", value="Longer explanation for the integration.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integration dynamodb(DynamodbIntegration dynamodb) {
        this.dynamodb = dynamodb;
        return this;
    }

    @JsonProperty(value="dynamodb")
    @ApiModelProperty(value="Amazon DynamoDB details, must have one of aws_access_key or aws_role.")
    public DynamodbIntegration getDynamodb() {
        return this.dynamodb;
    }

    public void setDynamodb(DynamodbIntegration dynamodb) {
        this.dynamodb = dynamodb;
    }

    public Integration gcs(GcsIntegration gcs) {
        this.gcs = gcs;
        return this;
    }

    @JsonProperty(value="gcs")
    @ApiModelProperty(value="GCS details.")
    public GcsIntegration getGcs() {
        return this.gcs;
    }

    public void setGcs(GcsIntegration gcs) {
        this.gcs = gcs;
    }

    public Integration kafka(KafkaIntegration kafka) {
        this.kafka = kafka;
        return this;
    }

    @JsonProperty(value="kafka")
    @ApiModelProperty(value="Kafka details.")
    public KafkaIntegration getKafka() {
        return this.kafka;
    }

    public void setKafka(KafkaIntegration kafka) {
        this.kafka = kafka;
    }

    public Integration kinesis(KinesisIntegration kinesis) {
        this.kinesis = kinesis;
        return this;
    }

    @JsonProperty(value="kinesis")
    @ApiModelProperty(value="Amazon Kinesis details, must have one of aws_access_key or aws_role.")
    public KinesisIntegration getKinesis() {
        return this.kinesis;
    }

    public void setKinesis(KinesisIntegration kinesis) {
        this.kinesis = kinesis;
    }

    public Integration mongodb(MongoDbIntegration mongodb) {
        this.mongodb = mongodb;
        return this;
    }

    @JsonProperty(value="mongodb")
    @ApiModelProperty(value="MongoDb details.")
    public MongoDbIntegration getMongodb() {
        return this.mongodb;
    }

    public void setMongodb(MongoDbIntegration mongodb) {
        this.mongodb = mongodb;
    }

    public Integration name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="event-logs", required=true, value="Descriptive label and unique identifier.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integration ownerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
        return this;
    }

    @JsonProperty(value="owner_email")
    @ApiModelProperty(example="abc@rockset.com", value="User that owns this integration.")
    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public Integration s3(S3Integration s3) {
        this.s3 = s3;
        return this;
    }

    @JsonProperty(value="s3")
    @ApiModelProperty(value="Amazon S3 details, must have one of aws_access_key or aws_role.")
    public S3Integration getS3() {
        return this.s3;
    }

    public void setS3(S3Integration s3) {
        this.s3 = s3;
    }

    public Integration snowflake(SnowflakeIntegration snowflake) {
        this.snowflake = snowflake;
        return this;
    }

    @JsonProperty(value="snowflake")
    @ApiModelProperty(value="Snowflake details.")
    public SnowflakeIntegration getSnowflake() {
        return this.snowflake;
    }

    public void setSnowflake(SnowflakeIntegration snowflake) {
        this.snowflake = snowflake;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Integration integration = (Integration)o;
        return Objects.equals(this.azureBlobStorage, integration.azureBlobStorage) && Objects.equals(this.azureEventHubs, integration.azureEventHubs) && Objects.equals(this.azureServiceBus, integration.azureServiceBus) && Objects.equals(this.collections, integration.collections) && Objects.equals(this.createdAt, integration.createdAt) && Objects.equals(this.createdBy, integration.createdBy) && Objects.equals(this.createdByApikeyName, integration.createdByApikeyName) && Objects.equals(this.description, integration.description) && Objects.equals(this.dynamodb, integration.dynamodb) && Objects.equals(this.gcs, integration.gcs) && Objects.equals(this.kafka, integration.kafka) && Objects.equals(this.kinesis, integration.kinesis) && Objects.equals(this.mongodb, integration.mongodb) && Objects.equals(this.name, integration.name) && Objects.equals(this.ownerEmail, integration.ownerEmail) && Objects.equals(this.s3, integration.s3) && Objects.equals(this.snowflake, integration.snowflake);
    }

    public int hashCode() {
        return Objects.hash(this.azureBlobStorage, this.azureEventHubs, this.azureServiceBus, this.collections, this.createdAt, this.createdBy, this.createdByApikeyName, this.description, this.dynamodb, this.gcs, this.kafka, this.kinesis, this.mongodb, this.name, this.ownerEmail, this.s3, this.snowflake);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Integration {\n");
        sb.append("    azureBlobStorage: ").append(this.toIndentedString(this.azureBlobStorage)).append("\n");
        sb.append("    azureEventHubs: ").append(this.toIndentedString(this.azureEventHubs)).append("\n");
        sb.append("    azureServiceBus: ").append(this.toIndentedString(this.azureServiceBus)).append("\n");
        sb.append("    collections: ").append(this.toIndentedString(this.collections)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdByApikeyName: ").append(this.toIndentedString(this.createdByApikeyName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dynamodb: ").append(this.toIndentedString(this.dynamodb)).append("\n");
        sb.append("    gcs: ").append(this.toIndentedString(this.gcs)).append("\n");
        sb.append("    kafka: ").append(this.toIndentedString(this.kafka)).append("\n");
        sb.append("    kinesis: ").append(this.toIndentedString(this.kinesis)).append("\n");
        sb.append("    mongodb: ").append(this.toIndentedString(this.mongodb)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerEmail: ").append(this.toIndentedString(this.ownerEmail)).append("\n");
        sb.append("    s3: ").append(this.toIndentedString(this.s3)).append("\n");
        sb.append("    snowflake: ").append(this.toIndentedString(this.snowflake)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

