/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.AwsRole;
import com.rockset.client.model.KafkaV3SecurityConfig;
import com.rockset.client.model.SchemaRegistryConfig;
import com.rockset.client.model.StatusKafka;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KafkaIntegration {
    @SerializedName(value="aws_role")
    private AwsRole awsRole = null;
    @SerializedName(value="bootstrap_servers")
    private String bootstrapServers = null;
    @SerializedName(value="connection_string")
    private String connectionString = null;
    @SerializedName(value="kafka_data_format")
    private KafkaDataFormatEnum kafkaDataFormat = null;
    @SerializedName(value="kafka_topic_names")
    private List<String> kafkaTopicNames = null;
    @SerializedName(value="schema_registry_config")
    private SchemaRegistryConfig schemaRegistryConfig = null;
    @SerializedName(value="security_config")
    private KafkaV3SecurityConfig securityConfig = null;
    @SerializedName(value="source_status_by_topic")
    private Map<String, StatusKafka> sourceStatusByTopic = null;
    @SerializedName(value="use_v3")
    private Boolean useV3 = null;

    public KafkaIntegration awsRole(AwsRole awsRole) {
        this.awsRole = awsRole;
        return this;
    }

    @JsonProperty(value="aws_role")
    @ApiModelProperty(value="Details of an AWS cross-account role integration.")
    public AwsRole getAwsRole() {
        return this.awsRole;
    }

    public void setAwsRole(AwsRole awsRole) {
        this.awsRole = awsRole;
    }

    public KafkaIntegration bootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    @JsonProperty(value="bootstrap_servers")
    @ApiModelProperty(example="localhost:9092", value="The Kafka bootstrap server url(s). Required only for V3 integration.")
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public KafkaIntegration connectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    @JsonProperty(value="connection_string")
    @ApiModelProperty(value="Kafka connection string.")
    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public KafkaIntegration kafkaDataFormat(KafkaDataFormatEnum kafkaDataFormat) {
        this.kafkaDataFormat = kafkaDataFormat;
        return this;
    }

    @JsonProperty(value="kafka_data_format")
    @ApiModelProperty(example="JSON", value="The format of the Kafka topics being tailed.")
    public KafkaDataFormatEnum getKafkaDataFormat() {
        return this.kafkaDataFormat;
    }

    public void setKafkaDataFormat(KafkaDataFormatEnum kafkaDataFormat) {
        this.kafkaDataFormat = kafkaDataFormat;
    }

    public KafkaIntegration kafkaTopicNames(List<String> kafkaTopicNames) {
        this.kafkaTopicNames = kafkaTopicNames;
        return this;
    }

    public KafkaIntegration addKafkaTopicNamesItem(String kafkaTopicNamesItem) {
        if (this.kafkaTopicNames == null) {
            this.kafkaTopicNames = new ArrayList<String>();
        }
        this.kafkaTopicNames.add(kafkaTopicNamesItem);
        return this;
    }

    @JsonProperty(value="kafka_topic_names")
    @ApiModelProperty(value="Kafka topics to tail.")
    public List<String> getKafkaTopicNames() {
        return this.kafkaTopicNames;
    }

    public void setKafkaTopicNames(List<String> kafkaTopicNames) {
        this.kafkaTopicNames = kafkaTopicNames;
    }

    public KafkaIntegration schemaRegistryConfig(SchemaRegistryConfig schemaRegistryConfig) {
        this.schemaRegistryConfig = schemaRegistryConfig;
        return this;
    }

    @JsonProperty(value="schema_registry_config")
    @ApiModelProperty(value="Kafka configurations for schema registry.")
    public SchemaRegistryConfig getSchemaRegistryConfig() {
        return this.schemaRegistryConfig;
    }

    public void setSchemaRegistryConfig(SchemaRegistryConfig schemaRegistryConfig) {
        this.schemaRegistryConfig = schemaRegistryConfig;
    }

    public KafkaIntegration securityConfig(KafkaV3SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
        return this;
    }

    @JsonProperty(value="security_config")
    @ApiModelProperty(value="Kafka security configurations.")
    public KafkaV3SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(KafkaV3SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    @JsonProperty(value="source_status_by_topic")
    @ApiModelProperty(example="\"{\\\"topic-a\\\": \\\"DORMANT\\\"}\"", value="The status of the Kafka source by topic.")
    public Map<String, StatusKafka> getSourceStatusByTopic() {
        return this.sourceStatusByTopic;
    }

    public KafkaIntegration useV3(Boolean useV3) {
        this.useV3 = useV3;
        return this;
    }

    @JsonProperty(value="use_v3")
    @ApiModelProperty(value="")
    public Boolean isUseV3() {
        return this.useV3;
    }

    public void setUseV3(Boolean useV3) {
        this.useV3 = useV3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaIntegration kafkaIntegration = (KafkaIntegration)o;
        return Objects.equals(this.awsRole, kafkaIntegration.awsRole) && Objects.equals(this.bootstrapServers, kafkaIntegration.bootstrapServers) && Objects.equals(this.connectionString, kafkaIntegration.connectionString) && Objects.equals((Object)this.kafkaDataFormat, (Object)kafkaIntegration.kafkaDataFormat) && Objects.equals(this.kafkaTopicNames, kafkaIntegration.kafkaTopicNames) && Objects.equals(this.schemaRegistryConfig, kafkaIntegration.schemaRegistryConfig) && Objects.equals(this.securityConfig, kafkaIntegration.securityConfig) && Objects.equals(this.sourceStatusByTopic, kafkaIntegration.sourceStatusByTopic) && Objects.equals(this.useV3, kafkaIntegration.useV3);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.awsRole, this.bootstrapServers, this.connectionString, this.kafkaDataFormat, this.kafkaTopicNames, this.schemaRegistryConfig, this.securityConfig, this.sourceStatusByTopic, this.useV3});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KafkaIntegration {\n");
        sb.append("    awsRole: ").append(this.toIndentedString(this.awsRole)).append("\n");
        sb.append("    bootstrapServers: ").append(this.toIndentedString(this.bootstrapServers)).append("\n");
        sb.append("    connectionString: ").append(this.toIndentedString(this.connectionString)).append("\n");
        sb.append("    kafkaDataFormat: ").append(this.toIndentedString((Object)this.kafkaDataFormat)).append("\n");
        sb.append("    kafkaTopicNames: ").append(this.toIndentedString(this.kafkaTopicNames)).append("\n");
        sb.append("    schemaRegistryConfig: ").append(this.toIndentedString(this.schemaRegistryConfig)).append("\n");
        sb.append("    securityConfig: ").append(this.toIndentedString(this.securityConfig)).append("\n");
        sb.append("    sourceStatusByTopic: ").append(this.toIndentedString(this.sourceStatusByTopic)).append("\n");
        sb.append("    useV3: ").append(this.toIndentedString(this.useV3)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KafkaDataFormatEnum {
        JSON("JSON"),
        AVRO("AVRO");

        private String value;

        private KafkaDataFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KafkaDataFormatEnum fromValue(String text) {
            for (KafkaDataFormatEnum b : KafkaDataFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<KafkaDataFormatEnum> {
            public void write(JsonWriter jsonWriter, KafkaDataFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KafkaDataFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KafkaDataFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

