/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.TLSConfig;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class MongoDbIntegration {
    @SerializedName(value="connection_uri")
    private String connectionUri = null;
    @SerializedName(value="tls")
    private TLSConfig tls = null;

    public MongoDbIntegration connectionUri(String connectionUri) {
        this.connectionUri = connectionUri;
        return this;
    }

    @JsonProperty(value="connection_uri")
    @ApiModelProperty(example="mongodb+srv://<username>:<password>@server.example.com/", required=true, value="MongoDB connection URI string.")
    public String getConnectionUri() {
        return this.connectionUri;
    }

    public void setConnectionUri(String connectionUri) {
        this.connectionUri = connectionUri;
    }

    public MongoDbIntegration tls(TLSConfig tls) {
        this.tls = tls;
        return this;
    }

    @JsonProperty(value="tls")
    @ApiModelProperty(value="TLS configuration for mongo connection")
    public TLSConfig getTls() {
        return this.tls;
    }

    public void setTls(TLSConfig tls) {
        this.tls = tls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDbIntegration mongoDbIntegration = (MongoDbIntegration)o;
        return Objects.equals(this.connectionUri, mongoDbIntegration.connectionUri) && Objects.equals(this.tls, mongoDbIntegration.tls);
    }

    public int hashCode() {
        return Objects.hash(this.connectionUri, this.tls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MongoDbIntegration {\n");
        sb.append("    connectionUri: ").append(this.toIndentedString(this.connectionUri)).append("\n");
        sb.append("    tls: ").append(this.toIndentedString(this.tls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

