/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class OperatorStats {
    @SerializedName(value="worker")
    private String worker = null;
    @SerializedName(value="fragment")
    private Long fragment = null;
    @SerializedName(value="task")
    private String task = null;
    @SerializedName(value="operator_id")
    private Long operatorId = null;
    @SerializedName(value="operator_name")
    private String operatorName = null;
    @SerializedName(value="start_time_us")
    private Long startTimeUs = null;
    @SerializedName(value="end_time_us")
    private Long endTimeUs = null;
    @SerializedName(value="max_memory")
    private Long maxMemory = null;
    @SerializedName(value="input_bytes")
    private Long inputBytes = null;
    @SerializedName(value="input_rows")
    private Long inputRows = null;
    @SerializedName(value="output_bytes")
    private Long outputBytes = null;
    @SerializedName(value="output_rows")
    private Long outputRows = null;
    @SerializedName(value="processing_time_us")
    private Long processingTimeUs = null;
    @SerializedName(value="term_iterator_merge_count")
    private Long termIteratorMergeCount = null;
    @SerializedName(value="term_iterator_merge_operand_count")
    private Long termIteratorMergeOperandCount = null;
    @SerializedName(value="term_iterator_merge_duration_secs")
    private Long termIteratorMergeDurationSecs = null;
    @SerializedName(value="term_iterator_max_merged_value_size")
    private Long termIteratorMaxMergedValueSize = null;
    @SerializedName(value="disagg_read_count")
    private Long disaggReadCount = null;
    @SerializedName(value="disagg_read_bytes")
    private Long disaggReadBytes = null;

    public OperatorStats worker(String worker) {
        this.worker = worker;
        return this;
    }

    @JsonProperty(value="worker")
    @ApiModelProperty(example="aggregator", value="The id of the worker this operator ran on")
    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public OperatorStats fragment(Long fragment) {
        this.fragment = fragment;
        return this;
    }

    @JsonProperty(value="fragment")
    @ApiModelProperty(example="13", value="The id of the fragment this operator belonged to")
    public Long getFragment() {
        return this.fragment;
    }

    public void setFragment(Long fragment) {
        this.fragment = fragment;
    }

    public OperatorStats task(String task) {
        this.task = task;
        return this;
    }

    @JsonProperty(value="task")
    @ApiModelProperty(example="2", value="The id of the task this operator belonged to")
    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public OperatorStats operatorId(Long operatorId) {
        this.operatorId = operatorId;
        return this;
    }

    @JsonProperty(value="operator_id")
    @ApiModelProperty(example="3", value="The id of this operator in the task")
    public Long getOperatorId() {
        return this.operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public OperatorStats operatorName(String operatorName) {
        this.operatorName = operatorName;
        return this;
    }

    @JsonProperty(value="operator_name")
    @ApiModelProperty(example="ColumnScan", value="The class name of this operator")
    public String getOperatorName() {
        return this.operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public OperatorStats startTimeUs(Long startTimeUs) {
        this.startTimeUs = startTimeUs;
        return this;
    }

    @JsonProperty(value="start_time_us")
    @ApiModelProperty(example="1579631642603344", value="Microseconds since UNIX epoch of the first time data was received from any of this operator's inputs")
    public Long getStartTimeUs() {
        return this.startTimeUs;
    }

    public void setStartTimeUs(Long startTimeUs) {
        this.startTimeUs = startTimeUs;
    }

    public OperatorStats endTimeUs(Long endTimeUs) {
        this.endTimeUs = endTimeUs;
        return this;
    }

    @JsonProperty(value="end_time_us")
    @ApiModelProperty(example="1579631642603346", value="Microseconds since UNIX epoch of the last time data was sent to any of this operator's outputs")
    public Long getEndTimeUs() {
        return this.endTimeUs;
    }

    public void setEndTimeUs(Long endTimeUs) {
        this.endTimeUs = endTimeUs;
    }

    public OperatorStats maxMemory(Long maxMemory) {
        this.maxMemory = maxMemory;
        return this;
    }

    @JsonProperty(value="max_memory")
    @ApiModelProperty(example="14928", value="Maximum memory used by this operator during execution")
    public Long getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(Long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public OperatorStats inputBytes(Long inputBytes) {
        this.inputBytes = inputBytes;
        return this;
    }

    @JsonProperty(value="input_bytes")
    @ApiModelProperty(example="48004800", value="Total bytes received across all inputs")
    public Long getInputBytes() {
        return this.inputBytes;
    }

    public void setInputBytes(Long inputBytes) {
        this.inputBytes = inputBytes;
    }

    public OperatorStats inputRows(Long inputRows) {
        this.inputRows = inputRows;
        return this;
    }

    @JsonProperty(value="input_rows")
    @ApiModelProperty(example="1000100", value="Total rows received across all inputs")
    public Long getInputRows() {
        return this.inputRows;
    }

    public void setInputRows(Long inputRows) {
        this.inputRows = inputRows;
    }

    public OperatorStats outputBytes(Long outputBytes) {
        this.outputBytes = outputBytes;
        return this;
    }

    @JsonProperty(value="output_bytes")
    @ApiModelProperty(example="1600", value="Total bytes sent across all outputs")
    public Long getOutputBytes() {
        return this.outputBytes;
    }

    public void setOutputBytes(Long outputBytes) {
        this.outputBytes = outputBytes;
    }

    public OperatorStats outputRows(Long outputRows) {
        this.outputRows = outputRows;
        return this;
    }

    @JsonProperty(value="output_rows")
    @ApiModelProperty(example="100", value="Total rows sent across all outputs")
    public Long getOutputRows() {
        return this.outputRows;
    }

    public void setOutputRows(Long outputRows) {
        this.outputRows = outputRows;
    }

    public OperatorStats processingTimeUs(Long processingTimeUs) {
        this.processingTimeUs = processingTimeUs;
        return this;
    }

    @JsonProperty(value="processing_time_us")
    @ApiModelProperty(example="2500", value="Total time in microseconds spent doing useful work")
    public Long getProcessingTimeUs() {
        return this.processingTimeUs;
    }

    public void setProcessingTimeUs(Long processingTimeUs) {
        this.processingTimeUs = processingTimeUs;
    }

    public OperatorStats termIteratorMergeCount(Long termIteratorMergeCount) {
        this.termIteratorMergeCount = termIteratorMergeCount;
        return this;
    }

    @JsonProperty(value="term_iterator_merge_count")
    @ApiModelProperty(example="10", value="Number of times InvertedIndexLazyMergeOperator is invoked to perform lazy merge")
    public Long getTermIteratorMergeCount() {
        return this.termIteratorMergeCount;
    }

    public void setTermIteratorMergeCount(Long termIteratorMergeCount) {
        this.termIteratorMergeCount = termIteratorMergeCount;
    }

    public OperatorStats termIteratorMergeOperandCount(Long termIteratorMergeOperandCount) {
        this.termIteratorMergeOperandCount = termIteratorMergeOperandCount;
        return this;
    }

    @JsonProperty(value="term_iterator_merge_operand_count")
    @ApiModelProperty(example="10", value="Number of operands InvertedIndexLazyMergeOperator merged in total")
    public Long getTermIteratorMergeOperandCount() {
        return this.termIteratorMergeOperandCount;
    }

    public void setTermIteratorMergeOperandCount(Long termIteratorMergeOperandCount) {
        this.termIteratorMergeOperandCount = termIteratorMergeOperandCount;
    }

    public OperatorStats termIteratorMergeDurationSecs(Long termIteratorMergeDurationSecs) {
        this.termIteratorMergeDurationSecs = termIteratorMergeDurationSecs;
        return this;
    }

    @JsonProperty(value="term_iterator_merge_duration_secs")
    @ApiModelProperty(example="10", value="Time spent in the merge operation in InvertedIndexLazyMergeOperator")
    public Long getTermIteratorMergeDurationSecs() {
        return this.termIteratorMergeDurationSecs;
    }

    public void setTermIteratorMergeDurationSecs(Long termIteratorMergeDurationSecs) {
        this.termIteratorMergeDurationSecs = termIteratorMergeDurationSecs;
    }

    public OperatorStats termIteratorMaxMergedValueSize(Long termIteratorMaxMergedValueSize) {
        this.termIteratorMaxMergedValueSize = termIteratorMaxMergedValueSize;
        return this;
    }

    @JsonProperty(value="term_iterator_max_merged_value_size")
    @ApiModelProperty(example="10", value="Max size of value merged by InvertedIndexLazyMergeOperator")
    public Long getTermIteratorMaxMergedValueSize() {
        return this.termIteratorMaxMergedValueSize;
    }

    public void setTermIteratorMaxMergedValueSize(Long termIteratorMaxMergedValueSize) {
        this.termIteratorMaxMergedValueSize = termIteratorMaxMergedValueSize;
    }

    public OperatorStats disaggReadCount(Long disaggReadCount) {
        this.disaggReadCount = disaggReadCount;
        return this;
    }

    @JsonProperty(value="disagg_read_count")
    @ApiModelProperty(example="1", value="Number of RPCs made to disagg layer")
    public Long getDisaggReadCount() {
        return this.disaggReadCount;
    }

    public void setDisaggReadCount(Long disaggReadCount) {
        this.disaggReadCount = disaggReadCount;
    }

    public OperatorStats disaggReadBytes(Long disaggReadBytes) {
        this.disaggReadBytes = disaggReadBytes;
        return this;
    }

    @JsonProperty(value="disagg_read_bytes")
    @ApiModelProperty(example="1", value="Total bytes read from disagg layer")
    public Long getDisaggReadBytes() {
        return this.disaggReadBytes;
    }

    public void setDisaggReadBytes(Long disaggReadBytes) {
        this.disaggReadBytes = disaggReadBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorStats operatorStats = (OperatorStats)o;
        return Objects.equals(this.worker, operatorStats.worker) && Objects.equals(this.fragment, operatorStats.fragment) && Objects.equals(this.task, operatorStats.task) && Objects.equals(this.operatorId, operatorStats.operatorId) && Objects.equals(this.operatorName, operatorStats.operatorName) && Objects.equals(this.startTimeUs, operatorStats.startTimeUs) && Objects.equals(this.endTimeUs, operatorStats.endTimeUs) && Objects.equals(this.maxMemory, operatorStats.maxMemory) && Objects.equals(this.inputBytes, operatorStats.inputBytes) && Objects.equals(this.inputRows, operatorStats.inputRows) && Objects.equals(this.outputBytes, operatorStats.outputBytes) && Objects.equals(this.outputRows, operatorStats.outputRows) && Objects.equals(this.processingTimeUs, operatorStats.processingTimeUs) && Objects.equals(this.termIteratorMergeCount, operatorStats.termIteratorMergeCount) && Objects.equals(this.termIteratorMergeOperandCount, operatorStats.termIteratorMergeOperandCount) && Objects.equals(this.termIteratorMergeDurationSecs, operatorStats.termIteratorMergeDurationSecs) && Objects.equals(this.termIteratorMaxMergedValueSize, operatorStats.termIteratorMaxMergedValueSize) && Objects.equals(this.disaggReadCount, operatorStats.disaggReadCount) && Objects.equals(this.disaggReadBytes, operatorStats.disaggReadBytes);
    }

    public int hashCode() {
        return Objects.hash(this.worker, this.fragment, this.task, this.operatorId, this.operatorName, this.startTimeUs, this.endTimeUs, this.maxMemory, this.inputBytes, this.inputRows, this.outputBytes, this.outputRows, this.processingTimeUs, this.termIteratorMergeCount, this.termIteratorMergeOperandCount, this.termIteratorMergeDurationSecs, this.termIteratorMaxMergedValueSize, this.disaggReadCount, this.disaggReadBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperatorStats {\n");
        sb.append("    worker: ").append(this.toIndentedString(this.worker)).append("\n");
        sb.append("    fragment: ").append(this.toIndentedString(this.fragment)).append("\n");
        sb.append("    task: ").append(this.toIndentedString(this.task)).append("\n");
        sb.append("    operatorId: ").append(this.toIndentedString(this.operatorId)).append("\n");
        sb.append("    operatorName: ").append(this.toIndentedString(this.operatorName)).append("\n");
        sb.append("    startTimeUs: ").append(this.toIndentedString(this.startTimeUs)).append("\n");
        sb.append("    endTimeUs: ").append(this.toIndentedString(this.endTimeUs)).append("\n");
        sb.append("    maxMemory: ").append(this.toIndentedString(this.maxMemory)).append("\n");
        sb.append("    inputBytes: ").append(this.toIndentedString(this.inputBytes)).append("\n");
        sb.append("    inputRows: ").append(this.toIndentedString(this.inputRows)).append("\n");
        sb.append("    outputBytes: ").append(this.toIndentedString(this.outputBytes)).append("\n");
        sb.append("    outputRows: ").append(this.toIndentedString(this.outputRows)).append("\n");
        sb.append("    processingTimeUs: ").append(this.toIndentedString(this.processingTimeUs)).append("\n");
        sb.append("    termIteratorMergeCount: ").append(this.toIndentedString(this.termIteratorMergeCount)).append("\n");
        sb.append("    termIteratorMergeOperandCount: ").append(this.toIndentedString(this.termIteratorMergeOperandCount)).append("\n");
        sb.append("    termIteratorMergeDurationSecs: ").append(this.toIndentedString(this.termIteratorMergeDurationSecs)).append("\n");
        sb.append("    termIteratorMaxMergedValueSize: ").append(this.toIndentedString(this.termIteratorMaxMergedValueSize)).append("\n");
        sb.append("    disaggReadCount: ").append(this.toIndentedString(this.disaggReadCount)).append("\n");
        sb.append("    disaggReadBytes: ").append(this.toIndentedString(this.disaggReadBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

