/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.Organization;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrgMembership {
    @SerializedName(value="organization")
    private Organization organization = null;
    @SerializedName(value="roles")
    private List<String> roles = new ArrayList<String>();
    @SerializedName(value="invite_state")
    private InviteStateEnum inviteState = null;
    @SerializedName(value="invited_by")
    private String invitedBy = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="expires_at")
    private String expiresAt = null;
    @SerializedName(value="created_at")
    private String createdAt = null;

    public OrgMembership organization(Organization organization) {
        this.organization = organization;
        return this;
    }

    @JsonProperty(value="organization")
    @ApiModelProperty(required=true, value="")
    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public OrgMembership roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public OrgMembership addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @JsonProperty(value="roles")
    @ApiModelProperty(required=true, value="")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public OrgMembership inviteState(InviteStateEnum inviteState) {
        this.inviteState = inviteState;
        return this;
    }

    @JsonProperty(value="invite_state")
    @ApiModelProperty(required=true, value="")
    public InviteStateEnum getInviteState() {
        return this.inviteState;
    }

    public void setInviteState(InviteStateEnum inviteState) {
        this.inviteState = inviteState;
    }

    public OrgMembership invitedBy(String invitedBy) {
        this.invitedBy = invitedBy;
        return this;
    }

    @JsonProperty(value="invited_by")
    @ApiModelProperty(required=true, value="")
    public String getInvitedBy() {
        return this.invitedBy;
    }

    public void setInvitedBy(String invitedBy) {
        this.invitedBy = invitedBy;
    }

    public OrgMembership email(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="email")
    @ApiModelProperty(value="email of the user")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="expires_at")
    @ApiModelProperty(example="2001-08-29T00:23:41Z", required=true, value="ISO-8601 date")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public OrgMembership createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", required=true, value="ISO-8601 date")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrgMembership orgMembership = (OrgMembership)o;
        return Objects.equals(this.organization, orgMembership.organization) && Objects.equals(this.roles, orgMembership.roles) && Objects.equals((Object)this.inviteState, (Object)orgMembership.inviteState) && Objects.equals(this.invitedBy, orgMembership.invitedBy) && Objects.equals(this.email, orgMembership.email) && Objects.equals(this.expiresAt, orgMembership.expiresAt) && Objects.equals(this.createdAt, orgMembership.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.organization, this.roles, this.inviteState, this.invitedBy, this.email, this.expiresAt, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgMembership {\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    inviteState: ").append(this.toIndentedString((Object)this.inviteState)).append("\n");
        sb.append("    invitedBy: ").append(this.toIndentedString(this.invitedBy)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InviteStateEnum {
        PENDING("PENDING"),
        ACCEPTED("ACCEPTED"),
        EXPIRED("EXPIRED"),
        CANCELLED("CANCELLED");

        private String value;

        private InviteStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InviteStateEnum fromValue(String text) {
            for (InviteStateEnum b : InviteStateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<InviteStateEnum> {
            public void write(JsonWriter jsonWriter, InviteStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public InviteStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InviteStateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

