/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.Cluster;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An organization in Rockset is a container for users and collections.")
public class Organization {
    @SerializedName(value="clusters")
    private List<Cluster> clusters = null;
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="display_name")
    private String displayName = null;
    @SerializedName(value="external_id")
    private String externalId = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="rockset_user")
    private String rocksetUser = null;
    @SerializedName(value="sso_connection")
    private String ssoConnection = null;
    @SerializedName(value="sso_only")
    private Boolean ssoOnly = null;

    public Organization clusters(List<Cluster> clusters) {
        this.clusters = clusters;
        return this;
    }

    public Organization addClustersItem(Cluster clustersItem) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<Cluster>();
        }
        this.clusters.add(clustersItem);
        return this;
    }

    @JsonProperty(value="clusters")
    @ApiModelProperty(example="\"[{ ... }]\"", value="List of clusters associated with this org.")
    public List<Cluster> getClusters() {
        return this.clusters;
    }

    public void setClusters(List<Cluster> clusters) {
        this.clusters = clusters;
    }

    public Organization createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Organization displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="display_name")
    @ApiModelProperty(example="Rockset, Inc", value="Name of the organization.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Organization externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @JsonProperty(value="external_id")
    @ApiModelProperty(example="<hash>", value="Organization's unique external ID within Rockset.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Organization id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @ApiModelProperty(example="rockset", value="Unique identifier for the organization.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Organization rocksetUser(String rocksetUser) {
        this.rocksetUser = rocksetUser;
        return this;
    }

    @JsonProperty(value="rockset_user")
    @ApiModelProperty(example="<id>", value="Rockset's global AWS user.")
    public String getRocksetUser() {
        return this.rocksetUser;
    }

    public void setRocksetUser(String rocksetUser) {
        this.rocksetUser = rocksetUser;
    }

    public Organization ssoConnection(String ssoConnection) {
        this.ssoConnection = ssoConnection;
        return this;
    }

    @JsonProperty(value="sso_connection")
    @ApiModelProperty(example="rockset", value="Connection name of SSO connection.")
    public String getSsoConnection() {
        return this.ssoConnection;
    }

    public void setSsoConnection(String ssoConnection) {
        this.ssoConnection = ssoConnection;
    }

    public Organization ssoOnly(Boolean ssoOnly) {
        this.ssoOnly = ssoOnly;
        return this;
    }

    @JsonProperty(value="sso_only")
    @ApiModelProperty(example="true", value="Whether or not SSO is the only permitted form of auth.")
    public Boolean isSsoOnly() {
        return this.ssoOnly;
    }

    public void setSsoOnly(Boolean ssoOnly) {
        this.ssoOnly = ssoOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization organization = (Organization)o;
        return Objects.equals(this.clusters, organization.clusters) && Objects.equals(this.createdAt, organization.createdAt) && Objects.equals(this.displayName, organization.displayName) && Objects.equals(this.externalId, organization.externalId) && Objects.equals(this.id, organization.id) && Objects.equals(this.rocksetUser, organization.rocksetUser) && Objects.equals(this.ssoConnection, organization.ssoConnection) && Objects.equals(this.ssoOnly, organization.ssoOnly);
    }

    public int hashCode() {
        return Objects.hash(this.clusters, this.createdAt, this.displayName, this.externalId, this.id, this.rocksetUser, this.ssoConnection, this.ssoOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organization {\n");
        sb.append("    clusters: ").append(this.toIndentedString(this.clusters)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    rocksetUser: ").append(this.toIndentedString(this.rocksetUser)).append("\n");
        sb.append("    ssoConnection: ").append(this.toIndentedString(this.ssoConnection)).append("\n");
        sb.append("    ssoOnly: ").append(this.toIndentedString(this.ssoOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

