/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class PatchOperation {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="op")
    private OpEnum op = null;
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="value")
    private Object value = null;

    public PatchOperation from(String from) {
        this.from = from;
        return this;
    }

    @JsonProperty(value="from")
    @ApiModelProperty(value="[JSON Pointer](https://datatracker.ietf.org/doc/html/rfc6901) referencing a location in the target document. Required for `COPY` and `MOVE` operations.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public PatchOperation op(OpEnum op) {
        this.op = op;
        return this;
    }

    @JsonProperty(value="op")
    @ApiModelProperty(example="ADD", required=true, value="[JSON Patch operation](https://datatracker.ietf.org/doc/html/rfc6902#page-4) to be performed in this patch. Case insensitive.")
    public OpEnum getOp() {
        return this.op;
    }

    public void setOp(OpEnum op) {
        this.op = op;
    }

    public PatchOperation path(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="path")
    @ApiModelProperty(example="/foo/bar", required=true, value="[JSON Pointer](https://datatracker.ietf.org/doc/html/rfc6901) referencing a location in the target document where the operation is performed")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PatchOperation value(Object value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="value")
    @ApiModelProperty(example="\"baz\"", value="Value used in the patch operation. Required for `ADD`, `REPLACE`, `TEST`, and `INCREMENT` operations.")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchOperation patchOperation = (PatchOperation)o;
        return Objects.equals(this.from, patchOperation.from) && Objects.equals((Object)this.op, (Object)patchOperation.op) && Objects.equals(this.path, patchOperation.path) && Objects.equals(this.value, patchOperation.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.op, this.path, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchOperation {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    op: ").append(this.toIndentedString((Object)this.op)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OpEnum {
        ADD("ADD"),
        REPLACE("REPLACE"),
        REMOVE("REMOVE"),
        COPY("COPY"),
        MOVE("MOVE"),
        TEST("TEST"),
        INCREMENT("INCREMENT");

        private String value;

        private OpEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OpEnum fromValue(String text) {
            for (OpEnum b : OpEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OpEnum> {
            public void write(JsonWriter jsonWriter, OpEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OpEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OpEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

