/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class Privilege {
    @SerializedName(value="action")
    private ActionEnum action = null;
    @SerializedName(value="cluster")
    private String cluster = null;
    @SerializedName(value="resource_name")
    private String resourceName = null;

    public Privilege action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @JsonProperty(value="action")
    @ApiModelProperty(example="CREATE_COLLECTION_WS", value="The action allowed by this privilege.")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public Privilege cluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    @JsonProperty(value="cluster")
    @ApiModelProperty(example="*ALL*", value="Cluster ID (`usw2a1` for us-west-2, `use1a1` for us-east-1, `euc1a1` for eu-central-1) for which the action is allowed. Defaults to '*All*' if not specified.")
    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public Privilege resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    @JsonProperty(value="resource_name")
    @ApiModelProperty(example="commons", value="The resources on which the action is allowed. Defaults to '*All*' if not specified.")
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege privilege = (Privilege)o;
        return Objects.equals((Object)this.action, (Object)privilege.action) && Objects.equals(this.cluster, privilege.cluster) && Objects.equals(this.resourceName, privilege.resourceName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.cluster, this.resourceName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Privilege {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    cluster: ").append(this.toIndentedString(this.cluster)).append("\n");
        sb.append("    resourceName: ").append(this.toIndentedString(this.resourceName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionEnum {
        ALL_GLOBAL_ACTIONS("ALLGLOBALACTIONS"),
        GET_ORG_GLOBAL("GETORGGLOBAL"),
        GET_CURRENT_USER_GLOBAL("GETCURRENTUSERGLOBAL"),
        INVITE_USER_GLOBAL("INVITEUSERGLOBAL"),
        DELETE_USER_GLOBAL("DELETEUSERGLOBAL"),
        LIST_USERS_GLOBAL("LISTUSERSGLOBAL"),
        GET_BILLING_GLOBAL("GETBILLINGGLOBAL"),
        UPDATE_BILLING_GLOBAL("UPDATEBILLINGGLOBAL"),
        UPDATE_SETTINGS_GLOBAL("UPDATESETTINGSGLOBAL"),
        GET_METRICS_GLOBAL("GETMETRICSGLOBAL"),
        CREATE_VI_GLOBAL("CREATEVIGLOBAL"),
        UPDATE_VI_GLOBAL("UPDATEVIGLOBAL"),
        LIST_VI_GLOBAL("LISTVIGLOBAL"),
        CREATE_WS_GLOBAL("CREATEWSGLOBAL"),
        LIST_WS_GLOBAL("LISTWSGLOBAL"),
        CREATE_INTEGRATION_GLOBAL("CREATEINTEGRATIONGLOBAL"),
        DELETE_INTEGRATION_GLOBAL("DELETEINTEGRATIONGLOBAL"),
        LIST_INTEGRATIONS_GLOBAL("LISTINTEGRATIONSGLOBAL"),
        EXPORT_DATA_GLOBAL("EXPORTDATAGLOBAL"),
        UPDATE_RESOURCE_OWNER_GLOBAL("UPDATERESOURCEOWNERGLOBAL"),
        CREATE_API_KEY_GLOBAL("CREATEAPIKEYGLOBAL"),
        CREATE_ROLE_GLOBAL("CREATEROLEGLOBAL"),
        UPDATE_ROLE_GLOBAL("UPDATEROLEGLOBAL"),
        DELETE_ROLE_GLOBAL("DELETEROLEGLOBAL"),
        LIST_ROLES_GLOBAL("LISTROLESGLOBAL"),
        GRANT_REVOKE_ROLE_GLOBAL("GRANTREVOKEROLEGLOBAL"),
        CREATE_QUERY_LOGS_COLLECTION_GLOBAL("CREATEQUERYLOGSCOLLECTIONGLOBAL"),
        CREATE_INGEST_LOGS_COLLECTION_GLOBAL("CREATEINGESTLOGSCOLLECTIONGLOBAL"),
        ALL_INTEGRATION_ACTIONS("ALLINTEGRATIONACTIONS"),
        CREATE_COLLECTION_INTEGRATION("CREATECOLLECTIONINTEGRATION"),
        ALL_WORKSPACE_ACTIONS("ALLWORKSPACEACTIONS"),
        DELETE_WS("DELETEWS"),
        QUERY_DATA_WS("QUERYDATAWS"),
        WRITE_DATA_WS("WRITEDATAWS"),
        CREATE_COLLECTION_WS("CREATECOLLECTIONWS"),
        DELETE_COLLECTION_WS("DELETECOLLECTIONWS"),
        UPDATE_COLLECTION_WS("UPDATECOLLECTIONWS"),
        CREATE_ALIAS_WS("CREATEALIASWS"),
        DELETE_ALIAS_WS("DELETEALIASWS"),
        CREATE_SNAPSHOT_WS("CREATESNAPSHOTWS"),
        LIST_RESOURCES_WS("LISTRESOURCESWS"),
        CREATE_QUERY_LAMBDA_WS("CREATEQUERYLAMBDAWS"),
        DELETE_QUERY_LAMBDA_WS("DELETEQUERYLAMBDAWS"),
        EXECUTE_QUERY_LAMBDA_WS("EXECUTEQUERYLAMBDAWS"),
        CREATE_SCHEDULED_LAMBDA_WS("CREATESCHEDULEDLAMBDAWS"),
        DELETE_SCHEDULED_LAMBDA_WS("DELETESCHEDULEDLAMBDAWS"),
        CREATE_VIEW_WS("CREATEVIEWWS"),
        DELETE_VIEW_WS("DELETEVIEWWS"),
        ALL_VI_ACTIONS("ALLVIACTIONS"),
        QUERY_VI("QUERYVI"),
        UPDATE_VI("UPDATEVI"),
        SUSPEND_RESUME_VI("SUSPENDRESUMEVI"),
        DELETE_VI("DELETEVI"),
        CREATE_SIMILARITY_INDEX_WS("CREATESIMILARITYINDEXWS"),
        DELETE_SIMILARITY_INDEX_WS("DELETESIMILARITYINDEXWS"),
        CREATE_NETWORK_CONFIGURATION_GLOBAL("CREATENETWORKCONFIGURATIONGLOBAL"),
        DELETE_NETWORK_CONFIGURATION_GLOBAL("DELETENETWORKCONFIGURATIONGLOBAL"),
        LIST_NETWORK_CONFIGURATIONS_GLOBAL("LISTNETWORKCONFIGURATIONSGLOBAL"),
        UPDATE_ORG_QUERY_ROUTING("UPDATEORGQUERYROUTING");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String text) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionEnum> {
            public void write(JsonWriter jsonWriter, ActionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

