/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.Pagination;
import com.rockset.client.model.QueryError;
import com.rockset.client.model.Stats;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class QueryInfo {
    @SerializedName(value="executed_by")
    private String executedBy = null;
    @SerializedName(value="expires_at")
    private String expiresAt = null;
    @SerializedName(value="last_offset")
    private String lastOffset = null;
    @SerializedName(value="pagination")
    private Pagination pagination = null;
    @SerializedName(value="query_errors")
    private List<QueryError> queryErrors = null;
    @SerializedName(value="query_id")
    private String queryId = null;
    @SerializedName(value="sql")
    private String sql = null;
    @SerializedName(value="stats")
    private Stats stats = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="submitted_at")
    private String submittedAt = null;

    public QueryInfo executedBy(String executedBy) {
        this.executedBy = executedBy;
        return this;
    }

    @JsonProperty(value="executed_by")
    @ApiModelProperty(example="xyz@rockset.com", value="User ID who executed the query.")
    public String getExecutedBy() {
        return this.executedBy;
    }

    public void setExecutedBy(String executedBy) {
        this.executedBy = executedBy;
    }

    public QueryInfo expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @JsonProperty(value="expires_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="Time (UTC) that query results expire. Only populated if `status` is `COMPLETE`.")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public QueryInfo lastOffset(String lastOffset) {
        this.lastOffset = lastOffset;
        return this;
    }

    @JsonProperty(value="last_offset")
    @ApiModelProperty(value="The log offset that query results were written to in the destination collection. Only populated for INSERT INTO queries.")
    public String getLastOffset() {
        return this.lastOffset;
    }

    public void setLastOffset(String lastOffset) {
        this.lastOffset = lastOffset;
    }

    public QueryInfo pagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @JsonProperty(value="pagination")
    @ApiModelProperty(value="Information for fetching query results pages. Only populated if `status` is `COMPLETE`.")
    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public QueryInfo queryErrors(List<QueryError> queryErrors) {
        this.queryErrors = queryErrors;
        return this;
    }

    public QueryInfo addQueryErrorsItem(QueryError queryErrorsItem) {
        if (this.queryErrors == null) {
            this.queryErrors = new ArrayList<QueryError>();
        }
        this.queryErrors.add(queryErrorsItem);
        return this;
    }

    @JsonProperty(value="query_errors")
    @ApiModelProperty(value="Errors encountered while executing the query.")
    public List<QueryError> getQueryErrors() {
        return this.queryErrors;
    }

    public void setQueryErrors(List<QueryError> queryErrors) {
        this.queryErrors = queryErrors;
    }

    public QueryInfo queryId(String queryId) {
        this.queryId = queryId;
        return this;
    }

    @JsonProperty(value="query_id")
    @ApiModelProperty(example="5b596206-c632-4a08-8343-0c560f7ef7f1", value="Unique Query ID.")
    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public QueryInfo sql(String sql) {
        this.sql = sql;
        return this;
    }

    @JsonProperty(value="sql")
    @ApiModelProperty(value="The SQL query for this request")
    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public QueryInfo stats(Stats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="stats")
    @ApiModelProperty(value="Various stats about the query's execution.")
    public Stats getStats() {
        return this.stats;
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public QueryInfo status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(example="RUNNING", value="Status of the query.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public QueryInfo submittedAt(String submittedAt) {
        this.submittedAt = submittedAt;
        return this;
    }

    @JsonProperty(value="submitted_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="Time (UTC) the query request was first received and queued for execution.")
    public String getSubmittedAt() {
        return this.submittedAt;
    }

    public void setSubmittedAt(String submittedAt) {
        this.submittedAt = submittedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryInfo queryInfo = (QueryInfo)o;
        return Objects.equals(this.executedBy, queryInfo.executedBy) && Objects.equals(this.expiresAt, queryInfo.expiresAt) && Objects.equals(this.lastOffset, queryInfo.lastOffset) && Objects.equals(this.pagination, queryInfo.pagination) && Objects.equals(this.queryErrors, queryInfo.queryErrors) && Objects.equals(this.queryId, queryInfo.queryId) && Objects.equals(this.sql, queryInfo.sql) && Objects.equals(this.stats, queryInfo.stats) && Objects.equals((Object)this.status, (Object)queryInfo.status) && Objects.equals(this.submittedAt, queryInfo.submittedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.executedBy, this.expiresAt, this.lastOffset, this.pagination, this.queryErrors, this.queryId, this.sql, this.stats, this.status, this.submittedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryInfo {\n");
        sb.append("    executedBy: ").append(this.toIndentedString(this.executedBy)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    lastOffset: ").append(this.toIndentedString(this.lastOffset)).append("\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("    queryErrors: ").append(this.toIndentedString(this.queryErrors)).append("\n");
        sb.append("    queryId: ").append(this.toIndentedString(this.queryId)).append("\n");
        sb.append("    sql: ").append(this.toIndentedString(this.sql)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    submittedAt: ").append(this.toIndentedString(this.submittedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        QUEUED("QUEUED"),
        RUNNING("RUNNING"),
        COMPLETED("COMPLETED"),
        ERROR("ERROR"),
        CANCELLED("CANCELLED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

