/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.QueryLambdaVersion;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class QueryLambda {
    @SerializedName(value="collections")
    private List<String> collections = null;
    @SerializedName(value="last_updated")
    private String lastUpdated = null;
    @SerializedName(value="last_updated_by")
    private String lastUpdatedBy = null;
    @SerializedName(value="latest_version")
    private QueryLambdaVersion latestVersion = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="version_count")
    private Integer versionCount = null;
    @SerializedName(value="workspace")
    private String workspace = null;

    public QueryLambda collections(List<String> collections) {
        this.collections = collections;
        return this;
    }

    public QueryLambda addCollectionsItem(String collectionsItem) {
        if (this.collections == null) {
            this.collections = new ArrayList<String>();
        }
        this.collections.add(collectionsItem);
        return this;
    }

    @JsonProperty(value="collections")
    @ApiModelProperty(value="Collections/aliases queried by underlying SQL query.")
    public List<String> getCollections() {
        return this.collections;
    }

    public void setCollections(List<String> collections) {
        this.collections = collections;
    }

    public QueryLambda lastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty(value="last_updated")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when Query Lambda was last updated.")
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public QueryLambda lastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty(value="last_updated_by")
    @ApiModelProperty(example="..@rockset.com", value="User that created this Query Lambda.")
    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public QueryLambda latestVersion(QueryLambdaVersion latestVersion) {
        this.latestVersion = latestVersion;
        return this;
    }

    @JsonProperty(value="latest_version")
    @ApiModelProperty(value="Query Lambda version details for most recently created version.")
    public QueryLambdaVersion getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(QueryLambdaVersion latestVersion) {
        this.latestVersion = latestVersion;
    }

    public QueryLambda name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="myQuery", value="Query Lambda name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryLambda versionCount(Integer versionCount) {
        this.versionCount = versionCount;
        return this;
    }

    @JsonProperty(value="version_count")
    @ApiModelProperty(example="1", value="Number of Query Lambda versions.")
    public Integer getVersionCount() {
        return this.versionCount;
    }

    public void setVersionCount(Integer versionCount) {
        this.versionCount = versionCount;
    }

    public QueryLambda workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @JsonProperty(value="workspace")
    @ApiModelProperty(example="commons", value="Workspace of this Query Lambda.")
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryLambda queryLambda = (QueryLambda)o;
        return Objects.equals(this.collections, queryLambda.collections) && Objects.equals(this.lastUpdated, queryLambda.lastUpdated) && Objects.equals(this.lastUpdatedBy, queryLambda.lastUpdatedBy) && Objects.equals(this.latestVersion, queryLambda.latestVersion) && Objects.equals(this.name, queryLambda.name) && Objects.equals(this.versionCount, queryLambda.versionCount) && Objects.equals(this.workspace, queryLambda.workspace);
    }

    public int hashCode() {
        return Objects.hash(this.collections, this.lastUpdated, this.lastUpdatedBy, this.latestVersion, this.name, this.versionCount, this.workspace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryLambda {\n");
        sb.append("    collections: ").append(this.toIndentedString(this.collections)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    lastUpdatedBy: ").append(this.toIndentedString(this.lastUpdatedBy)).append("\n");
        sb.append("    latestVersion: ").append(this.toIndentedString(this.latestVersion)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    versionCount: ").append(this.toIndentedString(this.versionCount)).append("\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

