/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.QueryLambdaSql;
import com.rockset.client.model.QueryLambdaStats;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class QueryLambdaVersion {
    @SerializedName(value="collections")
    private List<String> collections = null;
    @SerializedName(value="created_at")
    private String createdAt = null;
    @SerializedName(value="created_by")
    private String createdBy = null;
    @SerializedName(value="created_by_apikey_name")
    private String createdByApikeyName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="public_access_id")
    private String publicAccessId = null;
    @SerializedName(value="sql")
    private QueryLambdaSql sql = null;
    @SerializedName(value="state")
    private StateEnum state = null;
    @SerializedName(value="stats")
    private QueryLambdaStats stats = null;
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="workspace")
    private String workspace = null;

    public QueryLambdaVersion collections(List<String> collections) {
        this.collections = collections;
        return this;
    }

    public QueryLambdaVersion addCollectionsItem(String collectionsItem) {
        if (this.collections == null) {
            this.collections = new ArrayList<String>();
        }
        this.collections.add(collectionsItem);
        return this;
    }

    @JsonProperty(value="collections")
    @ApiModelProperty(value="Collections queried by underlying SQL query.")
    public List<String> getCollections() {
        return this.collections;
    }

    public void setCollections(List<String> collections) {
        this.collections = collections;
    }

    public QueryLambdaVersion createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="created_at")
    @ApiModelProperty(example="2001-08-28T00:23:41Z", value="ISO-8601 date of when Query Lambda was created.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public QueryLambdaVersion createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="created_by")
    @ApiModelProperty(example="..@rockset.com", value="User that created this Query Lambda.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public QueryLambdaVersion createdByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
        return this;
    }

    @JsonProperty(value="created_by_apikey_name")
    @ApiModelProperty(value="Name of the API key that was used to create this object if one was used.")
    public String getCreatedByApikeyName() {
        return this.createdByApikeyName;
    }

    public void setCreatedByApikeyName(String createdByApikeyName) {
        this.createdByApikeyName = createdByApikeyName;
    }

    public QueryLambdaVersion description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(example="production version foo", value="Optional description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public QueryLambdaVersion name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @ApiModelProperty(example="myQuery", value="Query Lambda name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryLambdaVersion publicAccessId(String publicAccessId) {
        this.publicAccessId = publicAccessId;
        return this;
    }

    @JsonProperty(value="public_access_id")
    @ApiModelProperty(value="Public access ID associated with this QL version")
    public String getPublicAccessId() {
        return this.publicAccessId;
    }

    public void setPublicAccessId(String publicAccessId) {
        this.publicAccessId = publicAccessId;
    }

    public QueryLambdaVersion sql(QueryLambdaSql sql) {
        this.sql = sql;
        return this;
    }

    @JsonProperty(value="sql")
    @ApiModelProperty(value="Query Lambda SQL query.")
    public QueryLambdaSql getSql() {
        return this.sql;
    }

    public void setSql(QueryLambdaSql sql) {
        this.sql = sql;
    }

    public QueryLambdaVersion state(StateEnum state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    @ApiModelProperty(example="ACTIVE", value="Status of this Query Lambda.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public QueryLambdaVersion stats(QueryLambdaStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="stats")
    @ApiModelProperty(value="Stats related to this Query Lambda.")
    public QueryLambdaStats getStats() {
        return this.stats;
    }

    public void setStats(QueryLambdaStats stats) {
        this.stats = stats;
    }

    public QueryLambdaVersion version(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @ApiModelProperty(example="acb99feg92bcaf", value="Query Lambda version.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public QueryLambdaVersion workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @JsonProperty(value="workspace")
    @ApiModelProperty(example="commons", value="Workspace of this Query Lambda.")
    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryLambdaVersion queryLambdaVersion = (QueryLambdaVersion)o;
        return Objects.equals(this.collections, queryLambdaVersion.collections) && Objects.equals(this.createdAt, queryLambdaVersion.createdAt) && Objects.equals(this.createdBy, queryLambdaVersion.createdBy) && Objects.equals(this.createdByApikeyName, queryLambdaVersion.createdByApikeyName) && Objects.equals(this.description, queryLambdaVersion.description) && Objects.equals(this.name, queryLambdaVersion.name) && Objects.equals(this.publicAccessId, queryLambdaVersion.publicAccessId) && Objects.equals(this.sql, queryLambdaVersion.sql) && Objects.equals((Object)this.state, (Object)queryLambdaVersion.state) && Objects.equals(this.stats, queryLambdaVersion.stats) && Objects.equals(this.version, queryLambdaVersion.version) && Objects.equals(this.workspace, queryLambdaVersion.workspace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.collections, this.createdAt, this.createdBy, this.createdByApikeyName, this.description, this.name, this.publicAccessId, this.sql, this.state, this.stats, this.version, this.workspace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryLambdaVersion {\n");
        sb.append("    collections: ").append(this.toIndentedString(this.collections)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdByApikeyName: ").append(this.toIndentedString(this.createdByApikeyName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    publicAccessId: ").append(this.toIndentedString(this.publicAccessId)).append("\n");
        sb.append("    sql: ").append(this.toIndentedString(this.sql)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACTIVE("ACTIVE"),
        INVALID_SQL("INVALIDSQL");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

