/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.AsyncQueryOptions;
import com.rockset.client.model.QueryRequestSql;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class QueryRequest {
    @SerializedName(value="async")
    private Boolean async = null;
    @SerializedName(value="async_options")
    private AsyncQueryOptions asyncOptions = null;
    @SerializedName(value="debug_threshold_ms")
    private Long debugThresholdMs = null;
    @SerializedName(value="max_initial_results")
    private Long maxInitialResults = null;
    @SerializedName(value="sql")
    private QueryRequestSql sql = null;
    @SerializedName(value="timeout_ms")
    private Long timeoutMs = null;

    public QueryRequest async(Boolean async) {
        this.async = async;
        return this;
    }

    @JsonProperty(value="async")
    @ApiModelProperty(value="If true, the query will run asynchronously for up to 30 minutes. The query request will immediately return with a query id that can be used to retrieve the query status and results. If false or not specified, the query will return with results once completed or timeout after 2 minutes. (To return results directly for shorter queries while still allowing a timeout of up to 30 minutes, set `async_options.client_timeout_ms`.) ")
    public Boolean isAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public QueryRequest asyncOptions(AsyncQueryOptions asyncOptions) {
        this.asyncOptions = asyncOptions;
        return this;
    }

    @JsonProperty(value="async_options")
    @ApiModelProperty(value="Options for configuring Asynchronous Query Mode.")
    public AsyncQueryOptions getAsyncOptions() {
        return this.asyncOptions;
    }

    public void setAsyncOptions(AsyncQueryOptions asyncOptions) {
        this.asyncOptions = asyncOptions;
    }

    public QueryRequest debugThresholdMs(Long debugThresholdMs) {
        this.debugThresholdMs = debugThresholdMs;
        return this;
    }

    @JsonProperty(value="debug_threshold_ms")
    @ApiModelProperty(value="If query execution takes longer than this value, debug information will be logged. If the query text includes the DEBUG hint and this parameter is also provided, only this value will be used and the DEBUG hint will be ignored.")
    public Long getDebugThresholdMs() {
        return this.debugThresholdMs;
    }

    public void setDebugThresholdMs(Long debugThresholdMs) {
        this.debugThresholdMs = debugThresholdMs;
    }

    public QueryRequest maxInitialResults(Long maxInitialResults) {
        this.maxInitialResults = maxInitialResults;
        return this;
    }

    @JsonProperty(value="max_initial_results")
    @ApiModelProperty(value="This limits the maximum number of results in the initial response. A pagination cursor is returned if the number of results exceeds `max_initial_results`. If `max_initial_results` is not set, all results will be returned in the initial response up to 4 million. If `max_initial_results` is set, the value must be between 0 and 100,000. If the query is async and `client_timeout_ms` is exceeded, `max_initial_results` does not apply since none of the results will be returned with the initial response.")
    public Long getMaxInitialResults() {
        return this.maxInitialResults;
    }

    public void setMaxInitialResults(Long maxInitialResults) {
        this.maxInitialResults = maxInitialResults;
    }

    public QueryRequest sql(QueryRequestSql sql) {
        this.sql = sql;
        return this;
    }

    @JsonProperty(value="sql")
    @ApiModelProperty(required=true, value="Main query request body.")
    public QueryRequestSql getSql() {
        return this.sql;
    }

    public void setSql(QueryRequestSql sql) {
        this.sql = sql;
    }

    public QueryRequest timeoutMs(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    @JsonProperty(value="timeout_ms")
    @ApiModelProperty(value="If a query exceeds the specified timeout, the query will automatically stop and return an error. The query timeout defaults to a maximum of 2 minutes. If `async` is true, the query timeout defaults to a maximum of 30 minutes.")
    public Long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setTimeoutMs(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRequest queryRequest = (QueryRequest)o;
        return Objects.equals(this.async, queryRequest.async) && Objects.equals(this.asyncOptions, queryRequest.asyncOptions) && Objects.equals(this.debugThresholdMs, queryRequest.debugThresholdMs) && Objects.equals(this.maxInitialResults, queryRequest.maxInitialResults) && Objects.equals(this.sql, queryRequest.sql) && Objects.equals(this.timeoutMs, queryRequest.timeoutMs);
    }

    public int hashCode() {
        return Objects.hash(this.async, this.asyncOptions, this.debugThresholdMs, this.maxInitialResults, this.sql, this.timeoutMs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryRequest {\n");
        sb.append("    async: ").append(this.toIndentedString(this.async)).append("\n");
        sb.append("    asyncOptions: ").append(this.toIndentedString(this.asyncOptions)).append("\n");
        sb.append("    debugThresholdMs: ").append(this.toIndentedString(this.debugThresholdMs)).append("\n");
        sb.append("    maxInitialResults: ").append(this.toIndentedString(this.maxInitialResults)).append("\n");
        sb.append("    sql: ").append(this.toIndentedString(this.sql)).append("\n");
        sb.append("    timeoutMs: ").append(this.toIndentedString(this.timeoutMs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

