/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rockset.client.model.PaginationInfo;
import com.rockset.client.model.QueryError;
import com.rockset.client.model.QueryFieldType;
import com.rockset.client.model.QueryResponseStats;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class QueryResponse {
    @SerializedName(value="collections")
    private List<String> collections = null;
    @SerializedName(value="column_fields")
    private List<QueryFieldType> columnFields = null;
    @SerializedName(value="last_offset")
    private String lastOffset = null;
    @SerializedName(value="pagination")
    private PaginationInfo pagination = null;
    @SerializedName(value="query_errors")
    private List<QueryError> queryErrors = null;
    @SerializedName(value="query_id")
    private String queryId = null;
    @SerializedName(value="query_lambda_path")
    private String queryLambdaPath = null;
    @SerializedName(value="results")
    private List<Object> results = null;
    @SerializedName(value="results_total_doc_count")
    private Long resultsTotalDocCount = null;
    @SerializedName(value="stats")
    private QueryResponseStats stats = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="warnings")
    private List<String> warnings = null;

    public QueryResponse collections(List<String> collections) {
        this.collections = collections;
        return this;
    }

    public QueryResponse addCollectionsItem(String collectionsItem) {
        if (this.collections == null) {
            this.collections = new ArrayList<String>();
        }
        this.collections.add(collectionsItem);
        return this;
    }

    @JsonProperty(value="collections")
    @ApiModelProperty(value="List of collections referenced in the query.")
    public List<String> getCollections() {
        return this.collections;
    }

    public void setCollections(List<String> collections) {
        this.collections = collections;
    }

    public QueryResponse columnFields(List<QueryFieldType> columnFields) {
        this.columnFields = columnFields;
        return this;
    }

    public QueryResponse addColumnFieldsItem(QueryFieldType columnFieldsItem) {
        if (this.columnFields == null) {
            this.columnFields = new ArrayList<QueryFieldType>();
        }
        this.columnFields.add(columnFieldsItem);
        return this;
    }

    @JsonProperty(value="column_fields")
    @ApiModelProperty(value="Meta information about each column in the result set. Not populated in `SELECT *` queries.")
    public List<QueryFieldType> getColumnFields() {
        return this.columnFields;
    }

    public void setColumnFields(List<QueryFieldType> columnFields) {
        this.columnFields = columnFields;
    }

    public QueryResponse lastOffset(String lastOffset) {
        this.lastOffset = lastOffset;
        return this;
    }

    @JsonProperty(value="last_offset")
    @ApiModelProperty(value="If this was a write query, this is the log offset the query was written to.")
    public String getLastOffset() {
        return this.lastOffset;
    }

    public void setLastOffset(String lastOffset) {
        this.lastOffset = lastOffset;
    }

    public QueryResponse pagination(PaginationInfo pagination) {
        this.pagination = pagination;
        return this;
    }

    @JsonProperty(value="pagination")
    @ApiModelProperty(value="Pagination information. Only populated if `paginate` is specified in the query request.")
    public PaginationInfo getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationInfo pagination) {
        this.pagination = pagination;
    }

    public QueryResponse queryErrors(List<QueryError> queryErrors) {
        this.queryErrors = queryErrors;
        return this;
    }

    public QueryResponse addQueryErrorsItem(QueryError queryErrorsItem) {
        if (this.queryErrors == null) {
            this.queryErrors = new ArrayList<QueryError>();
        }
        this.queryErrors.add(queryErrorsItem);
        return this;
    }

    @JsonProperty(value="query_errors")
    @ApiModelProperty(value="Errors encountered while executing the query.")
    public List<QueryError> getQueryErrors() {
        return this.queryErrors;
    }

    public void setQueryErrors(List<QueryError> queryErrors) {
        this.queryErrors = queryErrors;
    }

    public QueryResponse queryId(String queryId) {
        this.queryId = queryId;
        return this;
    }

    @JsonProperty(value="query_id")
    @ApiModelProperty(value="Unique ID for this query.")
    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public QueryResponse queryLambdaPath(String queryLambdaPath) {
        this.queryLambdaPath = queryLambdaPath;
        return this;
    }

    @JsonProperty(value="query_lambda_path")
    @ApiModelProperty(value="The full path of the executed query lambda. Includes version information.")
    public String getQueryLambdaPath() {
        return this.queryLambdaPath;
    }

    public void setQueryLambdaPath(String queryLambdaPath) {
        this.queryLambdaPath = queryLambdaPath;
    }

    public QueryResponse results(List<Object> results) {
        this.results = results;
        return this;
    }

    public QueryResponse addResultsItem(Object resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<Object>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @JsonProperty(value="results")
    @ApiModelProperty(value="Results from the query.")
    public List<Object> getResults() {
        return this.results;
    }

    public void setResults(List<Object> results) {
        this.results = results;
    }

    public QueryResponse resultsTotalDocCount(Long resultsTotalDocCount) {
        this.resultsTotalDocCount = resultsTotalDocCount;
        return this;
    }

    @JsonProperty(value="results_total_doc_count")
    @ApiModelProperty(value="Number of results generated by the query.")
    public Long getResultsTotalDocCount() {
        return this.resultsTotalDocCount;
    }

    public void setResultsTotalDocCount(Long resultsTotalDocCount) {
        this.resultsTotalDocCount = resultsTotalDocCount;
    }

    public QueryResponse stats(QueryResponseStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="stats")
    @ApiModelProperty(value="Meta information about the query including execution latencies.")
    public QueryResponseStats getStats() {
        return this.stats;
    }

    public void setStats(QueryResponseStats stats) {
        this.stats = stats;
    }

    public QueryResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @ApiModelProperty(example="RUNNING", value="Status of query execution. Possible values: `QUEUED`, `RUNNING`, `COMPLETED`, `ERROR`.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public QueryResponse warnings(List<String> warnings) {
        this.warnings = warnings;
        return this;
    }

    public QueryResponse addWarningsItem(String warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @JsonProperty(value="warnings")
    @ApiModelProperty(value="")
    public List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResponse queryResponse = (QueryResponse)o;
        return Objects.equals(this.collections, queryResponse.collections) && Objects.equals(this.columnFields, queryResponse.columnFields) && Objects.equals(this.lastOffset, queryResponse.lastOffset) && Objects.equals(this.pagination, queryResponse.pagination) && Objects.equals(this.queryErrors, queryResponse.queryErrors) && Objects.equals(this.queryId, queryResponse.queryId) && Objects.equals(this.queryLambdaPath, queryResponse.queryLambdaPath) && Objects.equals(this.results, queryResponse.results) && Objects.equals(this.resultsTotalDocCount, queryResponse.resultsTotalDocCount) && Objects.equals(this.stats, queryResponse.stats) && Objects.equals((Object)this.status, (Object)queryResponse.status) && Objects.equals(this.warnings, queryResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.collections, this.columnFields, this.lastOffset, this.pagination, this.queryErrors, this.queryId, this.queryLambdaPath, this.results, this.resultsTotalDocCount, this.stats, this.status, this.warnings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryResponse {\n");
        sb.append("    collections: ").append(this.toIndentedString(this.collections)).append("\n");
        sb.append("    columnFields: ").append(this.toIndentedString(this.columnFields)).append("\n");
        sb.append("    lastOffset: ").append(this.toIndentedString(this.lastOffset)).append("\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("    queryErrors: ").append(this.toIndentedString(this.queryErrors)).append("\n");
        sb.append("    queryId: ").append(this.toIndentedString(this.queryId)).append("\n");
        sb.append("    queryLambdaPath: ").append(this.toIndentedString(this.queryLambdaPath)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    resultsTotalDocCount: ").append(this.toIndentedString(this.resultsTotalDocCount)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        QUEUED("QUEUED"),
        RUNNING("RUNNING"),
        COMPLETED("COMPLETED"),
        ERROR("ERROR");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

