/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.OperatorStats;
import com.rockset.client.model.RpcSinkStats;
import com.rockset.client.model.RpcSourceStats;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class QueryStats {
    @SerializedName(value="elapsed_time_ms")
    private Long elapsedTimeMs = null;
    @SerializedName(value="rows_scanned")
    private Long rowsScanned = null;
    @SerializedName(value="rows_returned")
    private Long rowsReturned = null;
    @SerializedName(value="operators")
    private List<OperatorStats> operators = null;
    @SerializedName(value="exchange_sources")
    private List<RpcSourceStats> exchangeSources = null;
    @SerializedName(value="exchange_sinks")
    private List<RpcSinkStats> exchangeSinks = null;
    @SerializedName(value="execution_graph")
    private String executionGraph = null;
    @SerializedName(value="execution_plan")
    private String executionPlan = null;
    @SerializedName(value="operator_metadata")
    private String operatorMetadata = null;
    @SerializedName(value="query_text")
    private String queryText = null;

    public QueryStats elapsedTimeMs(Long elapsedTimeMs) {
        this.elapsedTimeMs = elapsedTimeMs;
        return this;
    }

    @JsonProperty(value="elapsed_time_ms")
    @ApiModelProperty(example="126", value="query time in milliseconds")
    public Long getElapsedTimeMs() {
        return this.elapsedTimeMs;
    }

    public void setElapsedTimeMs(Long elapsedTimeMs) {
        this.elapsedTimeMs = elapsedTimeMs;
    }

    public QueryStats rowsScanned(Long rowsScanned) {
        this.rowsScanned = rowsScanned;
        return this;
    }

    @JsonProperty(value="rows_scanned")
    @ApiModelProperty(example="25000", value="rows scanned as part of query execution")
    public Long getRowsScanned() {
        return this.rowsScanned;
    }

    public void setRowsScanned(Long rowsScanned) {
        this.rowsScanned = rowsScanned;
    }

    public QueryStats rowsReturned(Long rowsReturned) {
        this.rowsReturned = rowsReturned;
        return this;
    }

    @JsonProperty(value="rows_returned")
    @ApiModelProperty(example="100", value="number of rows returned from the query")
    public Long getRowsReturned() {
        return this.rowsReturned;
    }

    public void setRowsReturned(Long rowsReturned) {
        this.rowsReturned = rowsReturned;
    }

    public QueryStats operators(List<OperatorStats> operators) {
        this.operators = operators;
        return this;
    }

    public QueryStats addOperatorsItem(OperatorStats operatorsItem) {
        if (this.operators == null) {
            this.operators = new ArrayList<OperatorStats>();
        }
        this.operators.add(operatorsItem);
        return this;
    }

    @JsonProperty(value="operators")
    @ApiModelProperty(value="Statistics for each operator from query execution")
    public List<OperatorStats> getOperators() {
        return this.operators;
    }

    public void setOperators(List<OperatorStats> operators) {
        this.operators = operators;
    }

    public QueryStats exchangeSources(List<RpcSourceStats> exchangeSources) {
        this.exchangeSources = exchangeSources;
        return this;
    }

    public QueryStats addExchangeSourcesItem(RpcSourceStats exchangeSourcesItem) {
        if (this.exchangeSources == null) {
            this.exchangeSources = new ArrayList<RpcSourceStats>();
        }
        this.exchangeSources.add(exchangeSourcesItem);
        return this;
    }

    @JsonProperty(value="exchange_sources")
    @ApiModelProperty(value="Statistics for each exchange source from query execution")
    public List<RpcSourceStats> getExchangeSources() {
        return this.exchangeSources;
    }

    public void setExchangeSources(List<RpcSourceStats> exchangeSources) {
        this.exchangeSources = exchangeSources;
    }

    public QueryStats exchangeSinks(List<RpcSinkStats> exchangeSinks) {
        this.exchangeSinks = exchangeSinks;
        return this;
    }

    public QueryStats addExchangeSinksItem(RpcSinkStats exchangeSinksItem) {
        if (this.exchangeSinks == null) {
            this.exchangeSinks = new ArrayList<RpcSinkStats>();
        }
        this.exchangeSinks.add(exchangeSinksItem);
        return this;
    }

    @JsonProperty(value="exchange_sinks")
    @ApiModelProperty(value="Statistics for each exchange sink from query execution")
    public List<RpcSinkStats> getExchangeSinks() {
        return this.exchangeSinks;
    }

    public void setExchangeSinks(List<RpcSinkStats> exchangeSinks) {
        this.exchangeSinks = exchangeSinks;
    }

    public QueryStats executionGraph(String executionGraph) {
        this.executionGraph = executionGraph;
        return this;
    }

    @JsonProperty(value="execution_graph")
    @ApiModelProperty(value="DOT graph representing the execution steps of this query")
    public String getExecutionGraph() {
        return this.executionGraph;
    }

    public void setExecutionGraph(String executionGraph) {
        this.executionGraph = executionGraph;
    }

    public QueryStats executionPlan(String executionPlan) {
        this.executionPlan = executionPlan;
        return this;
    }

    @JsonProperty(value="execution_plan")
    @ApiModelProperty(value="Execution plan (output of EXPLAIN) of this query")
    public String getExecutionPlan() {
        return this.executionPlan;
    }

    public void setExecutionPlan(String executionPlan) {
        this.executionPlan = executionPlan;
    }

    public QueryStats operatorMetadata(String operatorMetadata) {
        this.operatorMetadata = operatorMetadata;
        return this;
    }

    @JsonProperty(value="operator_metadata")
    @ApiModelProperty(value="Information about each physical operator, like what fields it is fetching")
    public String getOperatorMetadata() {
        return this.operatorMetadata;
    }

    public void setOperatorMetadata(String operatorMetadata) {
        this.operatorMetadata = operatorMetadata;
    }

    public QueryStats queryText(String queryText) {
        this.queryText = queryText;
        return this;
    }

    @JsonProperty(value="query_text")
    @ApiModelProperty(value="SQL text of Query that was executed")
    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryStats queryStats = (QueryStats)o;
        return Objects.equals(this.elapsedTimeMs, queryStats.elapsedTimeMs) && Objects.equals(this.rowsScanned, queryStats.rowsScanned) && Objects.equals(this.rowsReturned, queryStats.rowsReturned) && Objects.equals(this.operators, queryStats.operators) && Objects.equals(this.exchangeSources, queryStats.exchangeSources) && Objects.equals(this.exchangeSinks, queryStats.exchangeSinks) && Objects.equals(this.executionGraph, queryStats.executionGraph) && Objects.equals(this.executionPlan, queryStats.executionPlan) && Objects.equals(this.operatorMetadata, queryStats.operatorMetadata) && Objects.equals(this.queryText, queryStats.queryText);
    }

    public int hashCode() {
        return Objects.hash(this.elapsedTimeMs, this.rowsScanned, this.rowsReturned, this.operators, this.exchangeSources, this.exchangeSinks, this.executionGraph, this.executionPlan, this.operatorMetadata, this.queryText);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryStats {\n");
        sb.append("    elapsedTimeMs: ").append(this.toIndentedString(this.elapsedTimeMs)).append("\n");
        sb.append("    rowsScanned: ").append(this.toIndentedString(this.rowsScanned)).append("\n");
        sb.append("    rowsReturned: ").append(this.toIndentedString(this.rowsReturned)).append("\n");
        sb.append("    operators: ").append(this.toIndentedString(this.operators)).append("\n");
        sb.append("    exchangeSources: ").append(this.toIndentedString(this.exchangeSources)).append("\n");
        sb.append("    exchangeSinks: ").append(this.toIndentedString(this.exchangeSinks)).append("\n");
        sb.append("    executionGraph: ").append(this.toIndentedString(this.executionGraph)).append("\n");
        sb.append("    executionPlan: ").append(this.toIndentedString(this.executionPlan)).append("\n");
        sb.append("    operatorMetadata: ").append(this.toIndentedString(this.operatorMetadata)).append("\n");
        sb.append("    queryText: ").append(this.toIndentedString(this.queryText)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

