/*
 * Decompiled with CFR 0.152.
 */
package com.rockset.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import com.rockset.client.model.AwsAccessKey;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class RedshiftIntegration {
    @SerializedName(value="aws_access_key")
    private AwsAccessKey awsAccessKey = null;
    @SerializedName(value="username")
    private String username = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="host")
    private String host = null;
    @SerializedName(value="port")
    private Integer port = null;
    @SerializedName(value="s3_bucket_path")
    private String s3BucketPath = null;

    public RedshiftIntegration awsAccessKey(AwsAccessKey awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    @JsonProperty(value="aws_access_key")
    @ApiModelProperty(value="AWS access key credentials")
    public AwsAccessKey getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(AwsAccessKey awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public RedshiftIntegration username(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="username")
    @ApiModelProperty(example="awsuser", required=true, value="Username associated with Redshift cluster")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public RedshiftIntegration password(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="password")
    @ApiModelProperty(example="pswd....", required=true, value="Password associated with Redshift cluster")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public RedshiftIntegration host(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="host")
    @ApiModelProperty(example="test.yuyugt.us-west-2.redshift.amazonaws.com", required=true, value="Redshift Cluster host")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public RedshiftIntegration port(Integer port) {
        this.port = port;
        return this;
    }

    @JsonProperty(value="port")
    @ApiModelProperty(example="5439", required=true, value="Redshift Cluster port")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public RedshiftIntegration s3BucketPath(String s3BucketPath) {
        this.s3BucketPath = s3BucketPath;
        return this;
    }

    @JsonProperty(value="s3_bucket_path")
    @ApiModelProperty(example="s3://redshift-unload", required=true, value="unload S3 bucket path")
    public String getS3BucketPath() {
        return this.s3BucketPath;
    }

    public void setS3BucketPath(String s3BucketPath) {
        this.s3BucketPath = s3BucketPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedshiftIntegration redshiftIntegration = (RedshiftIntegration)o;
        return Objects.equals(this.awsAccessKey, redshiftIntegration.awsAccessKey) && Objects.equals(this.username, redshiftIntegration.username) && Objects.equals(this.password, redshiftIntegration.password) && Objects.equals(this.host, redshiftIntegration.host) && Objects.equals(this.port, redshiftIntegration.port) && Objects.equals(this.s3BucketPath, redshiftIntegration.s3BucketPath);
    }

    public int hashCode() {
        return Objects.hash(this.awsAccessKey, this.username, this.password, this.host, this.port, this.s3BucketPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RedshiftIntegration {\n");
        sb.append("    awsAccessKey: ").append(this.toIndentedString(this.awsAccessKey)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    s3BucketPath: ").append(this.toIndentedString(this.s3BucketPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

